/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.util;

import com.hbm.nucleartech.block.custom.RadResistantBlock;
import com.hbm.nucleartech.capability.HbmCapabilities;
import com.hbm.nucleartech.damagesource.RegisterDamageSources;
import com.hbm.nucleartech.handler.HazmatRegistry;
import com.hbm.nucleartech.handler.RadiationSystemChunksNT;
import com.hbm.nucleartech.hazard.HazardBlockItem;
import com.hbm.nucleartech.hazard.HazardItem;
import com.hbm.nucleartech.hazard.HazardSystem;
import com.hbm.nucleartech.interfaces.IEntityCapabilityBase;
import com.hbm.nucleartech.interfaces.IItemHazard;
import com.hbm.nucleartech.interfaces.IRadResistantBlock;
import com.hbm.nucleartech.lib.Library;
import com.hbm.nucleartech.modules.ItemHazardModule;
import com.hbm.nucleartech.saveddata.RadiationSavedData;
import com.hbm.nucleartech.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class ContaminationUtil {
    private static final String NTM_NEUTRON_NBT_KEY = "ntm_neutron";

    public static void radiate(ServerLevel level, double x, double y, double z, double range, float rad3d, BlockPos worldPosition) {
        ContaminationUtil.radiate(level, x, y, z, range, rad3d, 0.0f, 0.0f, 0.0f, 0.0, worldPosition);
    }

    public static void radiate(ServerLevel level, double x, double y, double z, double range, float rad3d, float dig3d, float fire3d, BlockPos worldPosition) {
        ContaminationUtil.radiate(level, x, y, z, range, rad3d, dig3d, fire3d, 0.0f, 0.0, worldPosition);
    }

    public static void radiate(ServerLevel level, double x, double y, double z, double range, float rad3d, float dig3d, float fire3d, float blast3d, BlockPos worldPosition) {
        ContaminationUtil.radiate(level, x, y, z, range, rad3d, dig3d, fire3d, blast3d, range, worldPosition);
    }

    public static void radiate(ServerLevel pLevel, double x, double y, double z, double range, float rad3d, float dig3d, float fire3d, float blast3d, double blastRange, BlockPos worldPosition) {
        ArrayList entities;
        if (pLevel == null) {
            return;
        }
        try {
            entities = new ArrayList(pLevel.m_45933_(null, new AABB(x - range, y - range, z - range, x + range, y + range, z + range)));
        }
        catch (Exception e) {
            System.err.println("Failed to get entities for radiation calculation: " + e.getMessage());
            return;
        }
        ArrayList<RadiationSystemChunksNT.RadPocket> pockets = new ArrayList<RadiationSystemChunksNT.RadPocket>();
        RadiationSystemChunksNT.RadPocket ppppppp = RadiationSystemChunksNT.getPocket((Level)pLevel, worldPosition);
        RadiationSavedData.incrementRad(pLevel, worldPosition, rad3d, rad3d);
        pockets.add(ppppppp);
        for (Entity e : entities) {
            com.hbm.nucleartech.render.amlfrom1710.Vec3 vec;
            double len;
            if (ContaminationUtil.isExplosionExempt(e) || (len = (vec = com.hbm.nucleartech.render.amlfrom1710.Vec3.createVectorHelper(e.m_20185_() - x, e.m_20186_() + (double)e.m_20192_() - y, e.m_20189_() - z)).lengthVector()) > range) continue;
            vec = vec.normalize();
            double dmgLen = Math.max(len, range * 0.05);
            float res = 0.0f;
            ArrayList<Vec2> radResistantBlocks = new ArrayList<Vec2>();
            int i = 1;
            while ((double)i < len) {
                int iz;
                int iy;
                int ix = (int)Math.floor(x + vec.xCoord * (double)i);
                BlockPos stepPos = new BlockPos(ix, iy = (int)Math.floor(y + vec.yCoord * (double)i), iz = (int)Math.floor(z + vec.zCoord * (double)i));
                Block block = pLevel.m_8055_(stepPos).m_60734_();
                if (block instanceof IRadResistantBlock) {
                    IRadResistantBlock radBlock = (IRadResistantBlock)block;
                    radResistantBlocks.add(new Vec2(((RadResistantBlock)radBlock).\u03bc, ((RadResistantBlock)radBlock).thickness));
                } else {
                    res += block.getExplosionResistance(block.m_49966_(), (BlockGetter)pLevel, stepPos, null);
                }
                ++i;
            }
            boolean isLiving = e instanceof LivingEntity;
            if (res < 1.0f) {
                res = 1.0f;
            }
            if (isLiving && rad3d > 0.0f) {
                BlockPos dPos;
                RadiationSystemChunksNT.RadPocket decidedPocket;
                float eRads = rad3d;
                eRads /= (float)(dmgLen * dmgLen * Math.sqrt(res));
                for (Vec2 vec2 : radResistantBlocks) {
                    double exp = Math.exp(-vec2.f_82470_ * vec2.f_82471_);
                    eRads = eRads * (float)exp * 1000.0f;
                }
                if (eRads > 1.0E-4f) {
                    ContaminationUtil.contaminate((LivingEntity)e, HazardType.RADIATION, ContaminationType.CREATIVE, eRads);
                }
                if (!pockets.contains(decidedPocket = RadiationSystemChunksNT.getPocket((Level)pLevel, dPos = e.m_20097_().m_7918_(0, 1, 0)))) {
                    RadiationSavedData.incrementRad(pLevel, dPos, eRads, eRads);
                    pockets.add(decidedPocket);
                }
            }
            if (isLiving && dig3d > 0.0f) {
                float eDig = dig3d;
                ContaminationUtil.contaminate((LivingEntity)e, HazardType.DIGAMMA, ContaminationType.DIGAMMA, eDig /= (float)(dmgLen * dmgLen * dmgLen));
            }
            if (fire3d > 0.025f) {
                float fireDmg = fire3d;
                if ((fireDmg /= (float)(dmgLen * dmgLen * (double)res * (double)res)) > 0.025f) {
                    if (fireDmg > 0.1f && e instanceof Player) {
                        Player dPos = (Player)e;
                    }
                    if (radResistantBlocks.isEmpty()) {
                        e.m_6469_(pLevel.m_269111_().m_269387_(), fireDmg);
                        e.m_20254_(5);
                    }
                }
            }
            if (!(len < blastRange) || !(blast3d > 0.025f)) continue;
            float blastDmg = blast3d;
            if ((blastDmg /= (float)(dmgLen * dmgLen * (double)res)) > 0.025f) {
                if (rad3d > 0.0f) {
                    e.m_6469_(RegisterDamageSources.NUCLEAR_BLAST, blastDmg);
                } else {
                    e.m_6469_(RegisterDamageSources.BLAST, blastDmg);
                }
            }
            Vec3 cVel = e.m_20184_();
            e.m_20334_(cVel.f_82479_ + vec.xCoord * 0.005 * (double)blastDmg, cVel.f_82480_ + vec.yCoord * 0.005 * (double)blastDmg, cVel.f_82481_ + vec.zCoord * 0.005 * (double)blastDmg);
        }
    }

    private static boolean isExplosionExempt(Entity e) {
        return e instanceof Ocelot;
    }

    public static void setEntityENV(LivingEntity entity, Level level) {
        double env = 0.0;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                IItemHazard hazardItem;
                Item item = stack.m_41720_();
                if (!(item instanceof IItemHazard) || !(hazardItem = (IItemHazard)item).getModule().isRadioactive()) continue;
                env += hazardItem.getModule().radiation * (double)stack.m_41613_();
            }
        }
        RadiationSystemChunksNT.RadPocket ePoc = RadiationSystemChunksNT.getPocket(level, entity.m_20097_().m_7918_(0, 1, 0));
        HbmCapabilities.getData((Entity)entity).setValue(IEntityCapabilityBase.Type.RADENV, (float)(env += (double)ePoc.radiation));
        HbmCapabilities.getData((Entity)entity).syncLivingVariables((Entity)entity);
    }

    public static boolean contaminate(LivingEntity entity, HazardType hazard, ContaminationType cont, float amount) {
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_()) && cont != ContaminationType.NONE) {
            return false;
        }
        if ((hazard == HazardType.RADIATION || hazard == HazardType.NEUTRON) && ContaminationUtil.isRadImmune((Entity)entity)) {
            return false;
        }
        switch (hazard) {
            case RADIATION: {
                if (entity instanceof Player) {
                    player = (Player)entity;
                    amount *= 1.0f - (float)((double)((int)(10000.0 - (double)ContaminationUtil.calculateRadiationMod((LivingEntity)player) * 10000.0)) / 100.0) / 100.0f;
                }
                HbmCapabilities.getData((Entity)entity).addValue(IEntityCapabilityBase.Type.RADIATION, amount);
                if (entity instanceof Player) {
                    HbmCapabilities.getData((Entity)entity).syncLivingVariables((Entity)entity);
                }
                return true;
            }
            case NEUTRON: {
                if (entity instanceof Player) {
                    player = (Player)entity;
                    amount *= 1.0f - (float)((double)((int)(10000.0 - (double)ContaminationUtil.calculateRadiationMod((LivingEntity)player) * 10000.0)) / 100.0) / 100.0f;
                }
                HbmCapabilities.getData((Entity)entity).addValue(IEntityCapabilityBase.Type.RADIATION, amount);
                if (entity instanceof Player) {
                    HbmCapabilities.getData((Entity)entity).syncLivingVariables((Entity)entity);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isRadImmune(Entity e) {
        return e instanceof Zombie || e instanceof Skeleton || e instanceof Ocelot || e instanceof MushroomCow || e instanceof ZombieHorse || e instanceof SkeletonHorse || e instanceof ArmorStand;
    }

    public static void printGeigerData(Player player) {
        double playerContamination = HbmCapabilities.getData((Entity)player).getValue(IEntityCapabilityBase.Type.RADIATION) * 10.0 / 10.0;
        double environmentalRads = HbmCapabilities.getData((Entity)player).getValue(IEntityCapabilityBase.Type.RADENV) * 10.0 / 10.0;
        double neutronRads = HbmCapabilities.getData((Entity)player).getValue(IEntityCapabilityBase.Type.NEUTRON) * 10.0 / 10.0;
        double res = (double)((int)(10000.0 - (double)ContaminationUtil.calculateRadiationMod((LivingEntity)player) * 10000.0)) / 100.0;
        double resKoeff = (double)((int)((double)HazmatRegistry.getResistance(player) * 100.0)) / 100.0;
        String envPrefix = ContaminationUtil.getPrefixFromRad(environmentalRads);
        Object radPrefix = "";
        String resPrefix = String.valueOf(ChatFormatting.WHITE);
        radPrefix = playerContamination < 200.0 ? (String)radPrefix + String.valueOf(ChatFormatting.GREEN) : (playerContamination < 400.0 ? (String)radPrefix + String.valueOf(ChatFormatting.YELLOW) : (playerContamination < 600.0 ? (String)radPrefix + String.valueOf(ChatFormatting.GOLD) : (playerContamination < 800.0 ? (String)radPrefix + String.valueOf(ChatFormatting.RED) : (playerContamination < 1000.0 ? (String)radPrefix + String.valueOf(ChatFormatting.DARK_RED) : (String)radPrefix + String.valueOf(ChatFormatting.DARK_GRAY)))));
        if (resKoeff > 0.0) {
            resPrefix = resPrefix + String.valueOf(ChatFormatting.GREEN);
        }
        player.m_213846_((Component)Component.m_237113_((String)"===== \u2622 ").m_7220_((Component)Component.m_237115_((String)"geiger.title")).m_7220_((Component)Component.m_237113_((String)" \u2622 =====")).m_130940_(ChatFormatting.GOLD));
        player.m_213846_((Component)Component.m_237115_((String)"geiger.env_rad").m_7220_((Component)Component.m_237113_((String)(" " + envPrefix + String.format("%.1f", environmentalRads + neutronRads) + " RAD/s"))).m_130940_(ChatFormatting.YELLOW));
        player.m_213846_((Component)Component.m_237115_((String)"geiger.player_rad").m_7220_((Component)Component.m_237113_((String)(" " + (String)radPrefix + String.format("%.1f", playerContamination) + " RAD"))).m_130940_(ChatFormatting.YELLOW));
        player.m_213846_((Component)Component.m_237115_((String)"geiger.player_res").m_7220_((Component)Component.m_237113_((String)(" " + resPrefix + res + "% (" + resKoeff + ")"))).m_130940_(ChatFormatting.YELLOW));
    }

    public static float calculateRadiationMod(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float koeff = 10.0f;
            return (float)Math.pow(koeff, -HazmatRegistry.getResistance(player));
        }
        return 1.0f;
    }

    public static double getNoNeutronPlayerRads(LivingEntity entity) {
        return HbmCapabilities.getData((Entity)entity).getValue(IEntityCapabilityBase.Type.RADENV) * (double)ContaminationUtil.calculateRadiationMod(entity);
    }

    public static float getPlayerNeutronRads(Player player) {
        float radBuffer = 0.0f;
        for (ItemStack slotI : player.m_150109_().f_35974_) {
            radBuffer += ContaminationUtil.getNeutronRads(slotI);
        }
        for (ItemStack slotA : player.m_150109_().f_35975_) {
            radBuffer += ContaminationUtil.getNeutronRads(slotA);
        }
        HbmCapabilities.getData((Entity)player).setValue(IEntityCapabilityBase.Type.NEUTRON, radBuffer);
        HbmCapabilities.getData((Entity)player).syncLivingVariables((Entity)player);
        return radBuffer;
    }

    public static boolean isRadItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return HazardSystem.getRawRadsFromStack(stack) > 0.0f;
    }

    public static float getNeutronRads(ItemStack stack) {
        CompoundTag nbt;
        if (stack != null && !stack.m_41619_() && !ContaminationUtil.isRadItem(stack) && stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_(NTM_NEUTRON_NBT_KEY)) {
            return nbt.m_128457_(NTM_NEUTRON_NBT_KEY) * (float)stack.m_41613_();
        }
        return 0.0f;
    }

    public static void addNeutronRadInfo(ItemStack stack, Player player, List<Component> list, TooltipFlag flagIn) {
        float activationRads = ContaminationUtil.getNeutronRads(stack);
        if (activationRads > 0.0f) {
            list.add((Component)Component.m_237113_((String)("\u00a7a[" + I18nUtil.resolveKey("trait.radioactive", new Object[0]) + "]")));
            float stackRad = activationRads / (float)stack.m_41613_();
            list.add((Component)Component.m_237113_((String)(" \u00a7e" + Library.roundFloat((float)ItemHazardModule.getNewValue(stackRad), 3) + ItemHazardModule.getSuffix(stackRad) + " RAD/s")));
            if (stack.m_41613_() > 1) {
                list.add((Component)Component.m_237113_((String)(" \u00a7eStack: " + Library.roundFloat((float)ItemHazardModule.getNewValue(activationRads), 3) + ItemHazardModule.getSuffix(activationRads) + " RAD/s")));
            }
        }
    }

    public static void neutronActivateInventory(Player player, float rad, float decay) {
        for (ItemStack slotI : player.m_150109_().f_35974_) {
            if (slotI == player.m_150109_().m_36056_() || slotI.m_41720_() instanceof HazardItem || slotI.m_41720_() instanceof HazardBlockItem) continue;
            ContaminationUtil.neutronActivateItem(slotI, rad, decay);
        }
        for (ItemStack slotA : player.m_150109_().f_35975_) {
            ContaminationUtil.neutronActivateItem(slotA, rad, decay);
        }
    }

    public static void neutronActivateItem(ItemStack stack, float rad, float decay) {
        if (stack != null && !stack.m_41619_() && !ContaminationUtil.isRadItem(stack)) {
            CompoundTag nbt = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
            float prevActivation = 0.0f;
            if (nbt.m_128441_(NTM_NEUTRON_NBT_KEY)) {
                prevActivation = nbt.m_128457_(NTM_NEUTRON_NBT_KEY);
            }
            if (prevActivation + rad == 0.0f) {
                return;
            }
            float newActivation = prevActivation * decay + rad / (float)stack.m_41613_();
            if (prevActivation * decay + rad < 1.0E-4f || rad <= 0.0f && newActivation < 0.001f) {
                nbt.m_128473_(NTM_NEUTRON_NBT_KEY);
            } else {
                nbt.m_128350_(NTM_NEUTRON_NBT_KEY, newActivation);
            }
            if (nbt.m_128456_()) {
                stack.m_41751_(null);
            } else {
                stack.m_41751_(nbt);
            }
        }
    }

    public static String getPrefixFromRad(double rads) {
        Object chunkPrefix = "";
        chunkPrefix = rads == 0.0 ? (String)chunkPrefix + String.valueOf(ChatFormatting.GREEN) : (rads < 1.0 ? (String)chunkPrefix + String.valueOf(ChatFormatting.YELLOW) : (rads < 10.0 ? (String)chunkPrefix + String.valueOf(ChatFormatting.GOLD) : (rads < 100.0 ? (String)chunkPrefix + String.valueOf(ChatFormatting.RED) : (rads < 1000.0 ? (String)chunkPrefix + String.valueOf(ChatFormatting.DARK_RED) : (String)chunkPrefix + String.valueOf(ChatFormatting.DARK_GRAY)))));
        return chunkPrefix;
    }

    public static enum HazardType {
        ASBESTOS,
        BLINDING,
        COAL,
        CONTAMINATING,
        CRYOGENIC,
        DIGAMMA,
        EXPLOSIVE,
        HOT,
        HYDROACTIVE,
        RADIATION,
        TOXIC,
        UNSTABLE,
        NEUTRON;

    }

    public static enum ContaminationType {
        GAS,
        GAS_NON_REACTIVE,
        GOGGLES,
        FARADAY,
        HAZMAT,
        HAZMAT2,
        DIGAMMA,
        DIGAMMA2,
        CREATIVE,
        RAD_BYPASS,
        NONE;

    }
}

