/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.util;

import com.hbm.nucleartech.util.LeadingLong;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FloatingLong
extends Number
implements Comparable<FloatingLong> {
    protected long num;
    protected LeadingLong dec;
    protected long exp;
    protected Type type;
    protected String not;
    private static final Pattern FLOAT_STR_PATTERN = Pattern.compile("^([+-]?\\d+)(?:\\.(\\d*))?(?:[eE]([+-]?\\d+))?$");
    public static final FloatingLong ZERO = FloatingLong.create();
    public static final FloatingLong MAX_VALUE = FloatingLong.create(0x7FFFFFFFFFFFFFFEL, new LeadingLong(0x7FFFFFFFFFFFFFFEL), 0x7FFFFFFFFFFFFFFEL);
    public static final FloatingLong MIN_VALUE = FloatingLong.create(-9223372036854775807L, new LeadingLong(0x7FFFFFFFFFFFFFFEL), 0x7FFFFFFFFFFFFFFEL);
    private static final int ADD_ALIGN_THRESHOLD = 19;
    private static final int DIV_SCALE = 30;

    FloatingLong convertIfFits() {
        if (this.type != Type.exponential) {
            return this;
        }
        try {
            BigDecimal bd = new BigDecimal(this.not);
            bd = bd.stripTrailingZeros();
            String plain = bd.toPlainString();
            int MAX_PLAIN_LEN = 2000;
            if (plain.isEmpty() || plain.length() > 2000) {
                return this;
            }
            return new FloatingLong(plain);
        }
        catch (Exception e) {
            return this;
        }
    }

    private FloatingLong(String input) {
        String trimmedDec;
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        String trimmed = input.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("input cannot be empty");
        }
        Matcher m = FLOAT_STR_PATTERN.matcher(trimmed);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid floating-long format: " + input);
        }
        this.not = trimmed;
        String intPart = m.group(1);
        String decPart = m.group(2);
        String expPart = m.group(3);
        this.num = Long.parseLong(intPart);
        this.dec = decPart != null ? ((trimmedDec = decPart.replaceFirst("0+$", "")).isEmpty() ? new LeadingLong(0L) : new LeadingLong(trimmedDec)) : new LeadingLong(0L);
        long l = this.exp = expPart != null ? Long.parseLong(expPart) : 0L;
        this.type = this.exp != 0L ? Type.exponential : (this.dec.longValue() != 0L ? Type.fractional : Type.integral);
        this.not = (this.not.charAt(0) == '-' && this.not.charAt(1) == '0' ? "-" : "") + this.num + "." + this.dec.toString() + "E" + this.exp;
    }

    private FloatingLong(long integer, LeadingLong decimal, long exponent) {
        this.num = integer;
        this.dec = decimal;
        this.exp = exponent;
        StringBuilder sb = new StringBuilder();
        sb.append(Long.toString(this.num));
        sb.append('.').append(this.dec.toString());
        if (this.exp != 0L) {
            sb.append('E').append(this.exp);
        }
        this.not = sb.toString();
        this.type = this.exp != 0L ? Type.exponential : (this.dec.longValue() != 0L ? Type.fractional : Type.integral);
        this.not = (this.not.charAt(0) == '-' && this.not.charAt(1) == '0' ? "-" : "") + this.num + "." + this.dec.toString() + "E" + this.exp;
    }

    public FloatingLong copy() {
        return this;
    }

    public FloatingLong shaveDecimal() {
        return FloatingLong.create(this.num, new LeadingLong(0L), this.exp);
    }

    public static FloatingLong create() {
        return new FloatingLong("0");
    }

    public static FloatingLong create(String input) {
        if (input.isEmpty()) {
            input = "0";
        }
        return new FloatingLong(input.replaceAll(",", "").toUpperCase()).convertIfFits();
    }

    public static FloatingLong create(long integer, LeadingLong decimal, long exponent) {
        return new FloatingLong(integer, decimal, exponent).convertIfFits();
    }

    public static FloatingLong create(long input) {
        return new FloatingLong(input, new LeadingLong(0L), 0L);
    }

    public static FloatingLong create(float input) {
        return new FloatingLong(BigDecimal.valueOf(input).toString().replaceAll(",", "").toUpperCase()).convertIfFits();
    }

    public static FloatingLong create(int input) {
        return new FloatingLong(input, new LeadingLong(0L), 0L);
    }

    public static FloatingLong create(double input) {
        return new FloatingLong(BigDecimal.valueOf(input).toString().replaceAll(",", "").toUpperCase()).convertIfFits();
    }

    public String toString() {
        return this.not;
    }

    private static int safeDigitsCount(long v) {
        if (v == 0L) {
            return 1;
        }
        if (v == Long.MIN_VALUE) {
            return 19;
        }
        return Long.toString(Math.abs(v)).length();
    }

    private static BigInteger buildUnscaledBigIntegerUnsigned(long num, LeadingLong dec) {
        StringBuilder s = new StringBuilder();
        if (num == Long.MIN_VALUE) {
            s.append("9223372036854775808");
        } else {
            s.append(Long.toString(Math.abs(num)));
        }
        if (dec != null && dec.length() > 0) {
            s.append(dec.toString());
        }
        return new BigInteger(s.toString());
    }

    private static BigInteger buildSignedUnscaledBigInteger(long num, LeadingLong dec) {
        StringBuilder sb = new StringBuilder();
        String absStr = num == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(num));
        sb.append(absStr);
        if (dec != null && dec.length() > 0) {
            sb.append(dec.toString());
        }
        BigInteger bi = new BigInteger(sb.toString());
        if (num < 0L) {
            bi = bi.negate();
        }
        return bi;
    }

    @Override
    public int intValue() {
        long shift;
        BigInteger INT_MAX_BI = BigInteger.valueOf(Integer.MAX_VALUE);
        BigInteger INT_MIN_BI = BigInteger.valueOf(Integer.MIN_VALUE);
        int decLen = this.dec.length();
        int numDigits = FloatingLong.safeDigitsCount(this.num);
        long unscaledDigits = (long)numDigits + (long)decLen;
        long approxDigits = FloatingLong.getApproxDigits(unscaledDigits, shift = this.exp - (long)decLen);
        if (approxDigits > 10L) {
            return this.num >= 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        if (approxDigits <= 0L) {
            return 0;
        }
        BigInteger unscaled = FloatingLong.buildSignedUnscaledBigInteger(this.num, this.dec);
        if (shift > 0L) {
            unscaled = unscaled.multiply(BigInteger.TEN.pow((int)shift));
        } else if (shift < 0L) {
            unscaled = unscaled.divide(BigInteger.TEN.pow((int)(-shift)));
        }
        if (unscaled.compareTo(INT_MAX_BI) > 0) {
            return Integer.MAX_VALUE;
        }
        if (unscaled.compareTo(INT_MIN_BI) < 0) {
            return Integer.MIN_VALUE;
        }
        return unscaled.intValue();
    }

    @Override
    public long longValue() {
        long shift;
        if (this.num == 0L && (this.dec.length() == 0 || this.dec.longValue() == 0L) && this.exp == 0L) {
            return 0L;
        }
        BigInteger LONG_MAX_BI = BigInteger.valueOf(Long.MAX_VALUE);
        BigInteger LONG_MIN_BI = BigInteger.valueOf(Long.MIN_VALUE);
        int decLen = this.dec.length();
        int numDigits = FloatingLong.safeDigitsCount(this.num);
        long unscaledDigits = (long)numDigits + (long)decLen;
        long approxDigits = FloatingLong.getApproxDigits(unscaledDigits, shift = this.exp - (long)decLen);
        if (approxDigits > 19L) {
            return this.num >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        if (approxDigits <= 0L) {
            return 0L;
        }
        BigInteger unscaled = FloatingLong.buildSignedUnscaledBigInteger(this.num, this.dec);
        if (shift > 0L) {
            unscaled = unscaled.multiply(BigInteger.TEN.pow((int)shift));
        } else if (shift < 0L) {
            unscaled = unscaled.divide(BigInteger.TEN.pow((int)(-shift)));
        }
        if (unscaled.compareTo(LONG_MAX_BI) > 0) {
            return Long.MAX_VALUE;
        }
        if (unscaled.compareTo(LONG_MIN_BI) < 0) {
            return Long.MIN_VALUE;
        }
        return unscaled.longValue();
    }

    private static long getApproxDigits(long unscaledDigits, long shift) {
        return switch (FloatingLong.isSafe(unscaledDigits, shift)) {
            case -1 -> Long.MIN_VALUE;
            case 0 -> unscaledDigits + shift;
            case 1 -> Long.MAX_VALUE;
            default -> 0L;
        };
    }

    private static int getApproxDigits(int unscaledDigits, int shift) {
        return switch (FloatingLong.isSafe(unscaledDigits, shift)) {
            case -1 -> Integer.MIN_VALUE;
            case 0 -> unscaledDigits + shift;
            case 1 -> Integer.MAX_VALUE;
            default -> 0;
        };
    }

    private static float getApproxDigits(float unscaledDigits, float shift) {
        return switch (FloatingLong.isSafe(unscaledDigits, shift)) {
            case -1 -> -3.4028235E38f;
            case 0 -> unscaledDigits + shift;
            case 1 -> Float.MAX_VALUE;
            default -> 0.0f;
        };
    }

    private static double getApproxDigits(double unscaledDigits, double shift) {
        return switch (FloatingLong.isSafe(unscaledDigits, shift)) {
            case -1 -> -1.7976931348623157E308;
            case 0 -> unscaledDigits + shift;
            case 1 -> Double.MAX_VALUE;
            default -> 0.0;
        };
    }

    @Override
    public float floatValue() {
        long shift;
        if (this.num == 0L && (this.dec.length() == 0 || this.dec.longValue() == 0L) && this.exp == 0L) {
            return 0.0f;
        }
        int FLOAT_MAX_DIGITS = 38;
        int FLOAT_MIN_DIGITS = -45;
        int decLen = this.dec.length();
        int numDigits = FloatingLong.safeDigitsCount(this.num);
        long unscaledDigits = (long)numDigits + (long)decLen;
        long approxDigits = FloatingLong.getApproxDigits(unscaledDigits, shift = this.exp - (long)decLen);
        if (approxDigits > 38L) {
            return this.num >= 0L ? Float.MAX_VALUE : -3.4028235E38f;
        }
        if (approxDigits <= -45L) {
            return 0.0f;
        }
        BigInteger unscaled = FloatingLong.buildSignedUnscaledBigInteger(this.num, this.dec);
        try {
            float f;
            BigDecimal bd = new BigDecimal(unscaled);
            if (shift != 0L) {
                if (Math.abs(shift) > Integer.MAX_VALUE) {
                    return this.num >= 0L ? Float.MAX_VALUE : -3.4028235E38f;
                }
                bd = bd.scaleByPowerOfTen((int)shift);
            }
            if (Float.isInfinite(f = bd.floatValue())) {
                return f > 0.0f ? Float.MAX_VALUE : -3.4028235E38f;
            }
            return f;
        }
        catch (Exception ex) {
            if (shift > 0L) {
                unscaled = unscaled.multiply(BigInteger.TEN.pow((int)shift));
            } else if (shift < 0L) {
                unscaled = unscaled.divide(BigInteger.TEN.pow((int)(-shift)));
            }
            float f = unscaled.floatValue();
            if (Float.isInfinite(f)) {
                return f > 0.0f ? Float.MAX_VALUE : -3.4028235E38f;
            }
            return f;
        }
    }

    @Override
    public double doubleValue() {
        long shift;
        if (this.num == 0L && (this.dec.length() == 0 || this.dec.longValue() == 0L) && this.exp == 0L) {
            return 0.0;
        }
        int DOUBLE_MAX_DIGITS = 308;
        int DOUBLE_MIN_DIGITS = -324;
        int decLen = this.dec.length();
        int numDigits = FloatingLong.safeDigitsCount(this.num);
        long unscaledDigits = (long)numDigits + (long)decLen;
        long approxDigits = FloatingLong.getApproxDigits(unscaledDigits, shift = this.exp - (long)decLen);
        if (approxDigits > 308L) {
            return this.num >= 0L ? Double.MAX_VALUE : -1.7976931348623157E308;
        }
        if (approxDigits <= -324L) {
            return 0.0;
        }
        BigInteger unscaled = FloatingLong.buildSignedUnscaledBigInteger(this.num, this.dec);
        try {
            double d;
            BigDecimal bd = new BigDecimal(unscaled);
            if (shift != 0L) {
                if (Math.abs(shift) > Integer.MAX_VALUE) {
                    return this.num >= 0L ? Double.MAX_VALUE : -1.7976931348623157E308;
                }
                bd = bd.scaleByPowerOfTen((int)shift);
            }
            if (Double.isInfinite(d = bd.doubleValue())) {
                return d > 0.0 ? Double.MAX_VALUE : -1.7976931348623157E308;
            }
            return d;
        }
        catch (Exception ex) {
            if (shift > 0L) {
                unscaled = unscaled.multiply(BigInteger.TEN.pow((int)shift));
            } else if (shift < 0L) {
                unscaled = unscaled.divide(BigInteger.TEN.pow((int)(-shift)));
            }
            double d = unscaled.doubleValue();
            if (Double.isInfinite(d)) {
                return d > 0.0 ? Double.MAX_VALUE : -1.7976931348623157E308;
            }
            return d;
        }
    }

    private boolean isNegative() {
        if (this.num < 0L) {
            return true;
        }
        return this.num == 0L && this.not != null && this.not.startsWith("-");
    }

    @Override
    public int compareTo(@NotNull FloatingLong o) {
        boolean negB;
        if (this == o) {
            return 0;
        }
        if (Objects.equals(this.not, o.not)) {
            return 0;
        }
        int decLenA = this.dec.length();
        int decLenB = o.dec == null ? 0 : o.dec.length();
        long shiftA = this.exp - (long)decLenA;
        long shiftB = o.exp - (long)decLenB;
        BigInteger unscaledA_unsigned = FloatingLong.buildUnscaledBigIntegerUnsigned(this.num, this.dec);
        BigInteger unscaledB_unsigned = FloatingLong.buildUnscaledBigIntegerUnsigned(o.num, o.dec);
        int unscaledDigitsA = unscaledA_unsigned.equals(BigInteger.ZERO) ? 1 : unscaledA_unsigned.toString().replaceFirst("^0+", "").length();
        int unscaledDigitsB = unscaledB_unsigned.equals(BigInteger.ZERO) ? 1 : unscaledB_unsigned.toString().replaceFirst("^0+", "").length();
        long magA = (long)unscaledDigitsA + shiftA;
        long magB = (long)unscaledDigitsB + shiftB;
        boolean negA = this.isNegative();
        if (negA != (negB = o.isNegative())) {
            return negA ? -1 : 1;
        }
        if (magA != magB) {
            if (!negA) {
                return Long.compare(magA, magB);
            }
            return Long.compare(magB, magA);
        }
        BigInteger unscaledA = unscaledA_unsigned;
        BigInteger unscaledB = unscaledB_unsigned;
        long diff = shiftA - shiftB;
        if (diff == 0L) {
            BigInteger signedA = negA ? unscaledA.negate() : unscaledA;
            BigInteger signedB = negB ? unscaledB.negate() : unscaledB;
            return signedA.compareTo(signedB);
        }
        if (Math.abs(diff) > 1000L) {
            return 0;
        }
        if (diff > 0L) {
            unscaledA = unscaledA.multiply(BigInteger.TEN.pow((int)diff));
        } else {
            unscaledB = unscaledB.multiply(BigInteger.TEN.pow((int)(-diff)));
        }
        if (negA) {
            unscaledA = unscaledA.negate();
        }
        if (negB) {
            unscaledB = unscaledB.negate();
        }
        return unscaledA.compareTo(unscaledB);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatingLong)) {
            return false;
        }
        FloatingLong other = (FloatingLong)obj;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int decLen = this.dec.length();
        long shift = this.exp - (long)decLen;
        BigInteger absUnscaled = FloatingLong.buildUnscaledBigIntegerUnsigned(this.num, this.dec);
        while (!absUnscaled.equals(BigInteger.ZERO) && absUnscaled.mod(BigInteger.TEN).equals(BigInteger.ZERO)) {
            absUnscaled = absUnscaled.divide(BigInteger.TEN);
            ++shift;
        }
        int hash = 1;
        hash = 31 * hash + absUnscaled.hashCode();
        hash = 31 * hash + Long.hashCode(shift);
        hash = 31 * hash + Long.hashCode(this.isNegative() ? -1L : 1L);
        return hash;
    }

    public FloatingLong getValue() {
        return this;
    }

    public FloatingLong negate() {
        if (this.not != null) {
            if (this.not.startsWith("-")) {
                return new FloatingLong(this.not.substring(1));
            }
            return new FloatingLong("-" + this.not);
        }
        StringBuilder sb = new StringBuilder();
        if (this.num == 0L && this.not != null && this.not.startsWith("-")) {
            sb.append('-').append("0");
        } else {
            sb.append(Long.toString(-this.num));
        }
        if (this.dec != null) {
            sb.append('.').append(this.dec.toString());
        }
        if (this.exp != 0L) {
            sb.append('E').append(this.exp);
        }
        return new FloatingLong(sb.toString());
    }

    public static boolean fitsInLong(@NotNull String str) {
        String s = str.startsWith("-") ? str.substring(1) : str;
        if ((s = s.replaceFirst("^0+(?!$)", "")).length() < 19) {
            return true;
        }
        if (s.length() > 19) {
            return false;
        }
        String max = str.startsWith("-") ? "9223372036854775808" : "9223372036854775807";
        return s.compareTo(max) <= 0;
    }

    public static void dbgFL(String tag, FloatingLong f) {
        System.err.println(tag + ": not=" + f.toString() + "  num=" + f.num + " dec=" + (f.dec == null ? "<null>" : f.dec.toString()) + " exp=" + f.exp);
    }

    public FloatingLong shift(long shift) {
        Object fracPart;
        Object intPart;
        String decStr;
        if (shift == 0L) {
            return this;
        }
        BigInteger unscaledUnsigned = FloatingLong.buildUnscaledBigIntegerUnsigned(this.num, this.dec);
        if (unscaledUnsigned.equals(BigInteger.ZERO)) {
            return ZERO;
        }
        long MAX_SHIFT_SAFE = 1000000L;
        if (shift > 1000000L || shift < -1000000L) {
            return this;
        }
        String absNumStr = this.num == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(this.num));
        String combined = absNumStr + (decStr = this.dec.toString());
        int combinedLen = combined.length();
        if (combinedLen == 0) {
            return this;
        }
        long newIntLenLong = (long)combinedLen - shift;
        if (newIntLenLong < -1000000L || newIntLenLong > (long)combinedLen + 1000000L) {
            return this;
        }
        if (newIntLenLong > (long)combinedLen) {
            int addZeros = (int)(newIntLenLong - (long)combinedLen);
            if (addZeros < 0 || addZeros > 1000000) {
                return this;
            }
            intPart = combined + "0".repeat(addZeros);
            fracPart = "";
        } else if (newIntLenLong > 0L) {
            int newIntLen = (int)newIntLenLong;
            intPart = combined.substring(0, newIntLen);
            fracPart = combined.substring(newIntLen);
        } else {
            int leadingZeros = (int)(-newIntLenLong);
            if (leadingZeros < 0 || leadingZeros > 1000000) {
                return this;
            }
            intPart = "0";
            fracPart = "0".repeat(leadingZeros) + combined;
        }
        intPart = ((String)intPart).replaceFirst("^0+(?!$)", "");
        fracPart = ((String)fracPart).replaceFirst("0+$", "");
        long newExp = this.exp + shift;
        String signPrefix = this.isNegative() ? "-" : "";
        String signedIntCandidate = signPrefix + (String)(((String)intPart).isEmpty() ? "0" : intPart);
        while (!FloatingLong.fitsInLong(signedIntCandidate)) {
            if (((String)intPart).length() <= 1) {
                return this;
            }
            int keep = Math.min(18, ((String)intPart).length());
            String left = ((String)intPart).substring(0, keep);
            String moved = ((String)intPart).substring(keep);
            intPart = left;
            fracPart = moved + (String)fracPart;
            signedIntCandidate = signPrefix + (String)intPart;
        }
        if (!FloatingLong.fitsInLong(Long.toString(newExp))) {
            return this;
        }
        while (!((String)fracPart).isEmpty() && !FloatingLong.fitsInLong((String)fracPart)) {
            fracPart = ((String)fracPart).substring(0, ((String)fracPart).length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        if (this.isNegative()) {
            sb.append('-');
        }
        sb.append((String)(((String)intPart).isEmpty() ? "0" : intPart));
        if (!((String)fracPart).isEmpty()) {
            sb.append('.').append((String)fracPart);
        }
        if (newExp != 0L) {
            sb.append('E').append(newExp);
        }
        try {
            return FloatingLong.create(sb.toString());
        }
        catch (Exception ex) {
            return this;
        }
    }

    public static byte isSafe(long a, long b) {
        if (b > 0L && a > Long.MAX_VALUE - b) {
            return 1;
        }
        if (b < 0L && a < Long.MIN_VALUE - b) {
            return -1;
        }
        return 0;
    }

    public static byte isSafe(int a, int b) {
        if (b > 0 && a > Integer.MAX_VALUE - b) {
            return 1;
        }
        if (b < 0 && a < Integer.MIN_VALUE - b) {
            return -1;
        }
        return 0;
    }

    public static byte isSafe(float a, float b) {
        if (b > 0.0f && a > Float.MAX_VALUE - b) {
            return 1;
        }
        if (b < 0.0f && a < -3.4028235E38f - b) {
            return -1;
        }
        return 0;
    }

    public static byte isSafe(double a, double b) {
        if (b > 0.0 && a > Double.MAX_VALUE - b) {
            return 1;
        }
        if (b < 0.0 && a < -1.7976931348623157E308 - b) {
            return -1;
        }
        return 0;
    }

    public FloatingLong add(FloatingLong other) {
        long resultNum;
        BigInteger resultUnscaled;
        if (this.num == 0L && (this.dec == null || this.dec.longValue() == 0L) && this.exp == 0L) {
            return other;
        }
        if (other.num == 0L && (other.dec == null || other.dec.longValue() == 0L) && other.exp == 0L) {
            return this;
        }
        int decLenA = this.dec.length();
        int decLenB = other.dec == null ? 0 : other.dec.length();
        long shiftA = this.exp - (long)decLenA;
        long shiftB = other.exp - (long)decLenB;
        int numDigitsA = FloatingLong.safeDigitsCount(this.num);
        int numDigitsB = FloatingLong.safeDigitsCount(other.num);
        long unscaledDigitsA = (long)numDigitsA + (long)decLenA;
        long unscaledDigitsB = (long)numDigitsB + (long)decLenB;
        long magA = 0L;
        switch (FloatingLong.isSafe(unscaledDigitsA, shiftA)) {
            case -1: {
                magA = Long.MIN_VALUE;
                break;
            }
            case 0: {
                magA = unscaledDigitsA + shiftA;
                break;
            }
            case 1: {
                magA = Long.MAX_VALUE;
            }
        }
        long magB = 0L;
        switch (FloatingLong.isSafe(unscaledDigitsB, shiftB)) {
            case -1: {
                magB = Long.MIN_VALUE;
                break;
            }
            case 0: {
                magB = unscaledDigitsB + shiftB;
                break;
            }
            case 1: {
                magB = Long.MAX_VALUE;
            }
        }
        long diffShift = Math.abs(shiftA - shiftB);
        if (diffShift > 19L) {
            if (magA > magB) {
                return this;
            }
            if (magB > magA) {
                return other;
            }
        }
        long commonShift = Math.min(shiftA, shiftB);
        BigInteger unscaledA = FloatingLong.buildUnscaledBigIntegerUnsigned(this.num, this.dec);
        BigInteger unscaledB = FloatingLong.buildUnscaledBigIntegerUnsigned(other.num, other.dec);
        if (this.isNegative()) {
            unscaledA = unscaledA.negate();
        }
        if (other.isNegative()) {
            unscaledB = unscaledB.negate();
        }
        if (shiftA > commonShift) {
            unscaledA = unscaledA.multiply(BigInteger.TEN.pow((int)(shiftA - commonShift)));
        }
        if (shiftB > commonShift) {
            unscaledB = unscaledB.multiply(BigInteger.TEN.pow((int)(shiftB - commonShift)));
        }
        if ((resultUnscaled = unscaledA.add(unscaledB)).signum() == 0) {
            return ZERO;
        }
        boolean resultNeg = resultUnscaled.signum() < 0;
        BigInteger absResult = resultUnscaled.abs();
        String raw = absResult.toString();
        LeadingLong resultDec = new LeadingLong(0L);
        if (raw.length() > 18) {
            String numPart = raw.substring(0, 18);
            String decPart = raw.substring(18);
            resultNum = Long.parseLong(numPart);
            String decFinal = decPart.replaceFirst("0+$", "");
            resultDec = decFinal.isEmpty() ? new LeadingLong(0L) : new LeadingLong(decFinal);
            int movedDigits = decFinal.length();
            commonShift += (long)movedDigits;
        } else {
            resultNum = Long.parseLong(raw);
        }
        if (resultNeg) {
            resultNum = -resultNum;
        }
        return FloatingLong.create(resultNum, resultDec, commonShift);
    }

    public FloatingLong subtract(FloatingLong other) {
        return this.add(other.negate());
    }

    public FloatingLong multiply(double other) {
        return this.multiply(FloatingLong.create(BigDecimal.valueOf(other).toPlainString()));
    }

    private BigDecimal toBigDecimal() {
        int decLen = this.dec.length();
        BigInteger unscaled = FloatingLong.buildSignedUnscaledBigInteger(this.num, this.dec);
        int scale = decLen - (int)this.exp;
        return new BigDecimal(unscaled, scale);
    }

    public FloatingLong multiply(FloatingLong other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be null");
        }
        if (this.num == 0L && (this.dec == null || this.dec.length() == 0 || this.dec.longValue() == 0L) && this.exp == 0L || other.num == 0L && (other.dec == null || other.dec.length() == 0 || other.dec.longValue() == 0L) && other.exp == 0L) {
            return ZERO;
        }
        BigDecimal a = this.toBigDecimal();
        BigDecimal b = other.toBigDecimal();
        int PREC = 4;
        MathContext mc = new MathContext(4, RoundingMode.HALF_UP);
        BigDecimal prod = a.multiply(b, mc);
        BigDecimal normalized = prod.stripTrailingZeros();
        String out = normalized.toString();
        return FloatingLong.create(out);
    }

    public FloatingLong divide(double other) {
        return this.divide(FloatingLong.create(BigDecimal.valueOf(other).toPlainString()));
    }

    public FloatingLong divide(FloatingLong other) {
        long resultNum;
        if (other == null) {
            throw new IllegalArgumentException("other cannot be null");
        }
        if (other.num == 0L && (other.dec == null || other.dec.length() == 0 || other.dec.longValue() == 0L) && other.exp == 0L) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.num == 0L && (this.dec == null || this.dec.length() == 0 || this.dec.longValue() == 0L) && this.exp == 0L) {
            return ZERO;
        }
        int decLenA = this.dec.length();
        int decLenB = other.dec == null ? 0 : other.dec.length();
        long shiftA = this.exp - (long)decLenA;
        long shiftB = other.exp - (long)decLenB;
        long resultShift = shiftA - shiftB;
        BigInteger unscaledA = FloatingLong.buildSignedUnscaledBigInteger(this.num, this.dec);
        BigInteger unscaledB = FloatingLong.buildSignedUnscaledBigInteger(other.num, other.dec);
        boolean negative = unscaledA.signum() < 0 ^ unscaledB.signum() < 0;
        BigInteger absA = unscaledA.abs();
        BigInteger absB = unscaledB.abs();
        BigInteger quotient = absA.divide(absB);
        BigInteger remainder = absA.remainder(absB);
        if (quotient.equals(BigInteger.ZERO) && remainder.equals(BigInteger.ZERO)) {
            return ZERO;
        }
        String qStr = quotient.toString();
        LeadingLong resultDec = new LeadingLong(0L);
        if (qStr.length() > 18) {
            String numPart = qStr.substring(0, 18);
            String decPart = qStr.substring(18);
            if (decPart.length() > 18) {
                decPart = decPart.substring(0, 18);
            }
            resultNum = Long.parseLong(numPart);
            StringBuilder decBuilder = new StringBuilder(decPart);
            int extraDigits = 30;
            for (int i = 0; i < extraDigits && !remainder.equals(BigInteger.ZERO); ++i) {
                remainder = remainder.multiply(BigInteger.TEN);
                BigInteger digit = remainder.divide(absB);
                decBuilder.append(digit.toString());
                remainder = remainder.remainder(absB);
            }
            String decFinal = decBuilder.toString().replaceFirst("0+$", "");
            if (!decFinal.isEmpty()) {
                resultDec = new LeadingLong(decFinal);
            }
        } else {
            resultNum = Long.parseLong(qStr);
            if (!remainder.equals(BigInteger.ZERO)) {
                StringBuilder decBuilder = new StringBuilder();
                int extraDigits = 30;
                for (int i = 0; i < extraDigits && !remainder.equals(BigInteger.ZERO); ++i) {
                    remainder = remainder.multiply(BigInteger.TEN);
                    BigInteger digit = remainder.divide(absB);
                    decBuilder.append(digit.toString());
                    remainder = remainder.remainder(absB);
                }
                String decFinal = decBuilder.toString().replaceFirst("0+$", "");
                if (!decFinal.isEmpty()) {
                    resultDec = new LeadingLong(decFinal);
                }
            }
        }
        if (negative) {
            resultNum = -resultNum;
        }
        return FloatingLong.create(resultNum, resultDec, resultShift);
    }

    protected static enum Type {
        integral,
        fractional,
        exponential;

    }
}

