/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.util;

import java.math.BigInteger;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class LeadingLong
extends Number
implements Comparable<LeadingLong> {
    private final String digits;
    private final long value;
    private final int length;

    public LeadingLong(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value must be >= 0");
        }
        String digits = Long.toString(value);
        if (digits.length() > 4) {
            digits = digits.substring(0, 4);
        }
        this.digits = digits;
        this.value = Long.parseLong(this.digits);
        this.length = this.digits.length();
    }

    public LeadingLong(@NotNull String digits) {
        if (digits == null || digits.isEmpty()) {
            throw new IllegalArgumentException("digits must be a non-empty string of 0-9 characters");
        }
        if (!digits.matches("\\d+")) {
            throw new IllegalArgumentException("digits must contain only numeric characters (0-9)");
        }
        if (digits.length() > 4) {
            digits = digits.substring(0, 4);
        }
        this.digits = digits;
        try {
            this.value = Long.parseLong(this.digits);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("digit string too large to parse to long; use smaller groups or adapt code", e);
        }
        this.length = this.digits.length();
    }

    public LeadingLong(@NotNull String lead, long tailValue) {
        if (!lead.matches("\\d*")) {
            throw new IllegalArgumentException("lead must contain only digits (usually zeros)");
        }
        String tail = Long.toString(Math.max(0L, tailValue));
        this.digits = lead + tail;
        try {
            this.value = Long.parseLong(this.digits);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("combined digits too large for long", e);
        }
        this.length = this.digits.length();
    }

    public int length() {
        return this.length;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return Float.parseFloat("0." + this.digits);
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble("0." + this.digits);
    }

    public String toString() {
        return this.digits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LeadingLong)) {
            return false;
        }
        LeadingLong that = (LeadingLong)o;
        return this.length == that.length && this.digits.equals(that.digits);
    }

    public int hashCode() {
        return Objects.hash(this.digits, this.length);
    }

    @Override
    public int compareTo(@NotNull LeadingLong o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.digits.equals(o.digits) && this.length == o.length) {
            return 0;
        }
        int maxLen = Math.max(this.length, o.length);
        BigInteger a = BigInteger.valueOf(this.value).multiply(BigInteger.TEN.pow(maxLen - this.length));
        BigInteger b = BigInteger.valueOf(o.value).multiply(BigInteger.TEN.pow(maxLen - o.length));
        return a.compareTo(b);
    }
}

