/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.nucleartech.util;

import com.hbm.nucleartech.HBM;
import com.hbm.nucleartech.lib.Library;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipesCommon {
    public static ItemStack[] copyStackArray(ItemStack[] array) {
        if (array == null) {
            return null;
        }
        ItemStack[] clone = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            clone[i] = array[i].m_41777_();
        }
        return clone;
    }

    public static ItemStack[] objectToStackArray(Object[] array) {
        if (array == null) {
            return null;
        }
        ItemStack[] clone = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] instanceof ItemStack)) continue;
            clone[i] = (ItemStack)array[i];
        }
        return clone;
    }

    public static class OreDictStack
    extends AStack {
        public TagKey<Item> key;

        public OreDictStack(TagKey<Item> key) {
            this.key = key;
            this.stacksize = 1;
        }

        public OreDictStack(TagKey<Item> key, int stacksize) {
            this(key);
            this.stacksize = stacksize;
        }

        public List<ItemStack> toStacks() {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (Item item : ForgeRegistries.ITEMS) {
                if (!ForgeRegistries.ITEMS.getHolder((Object)item).map(h -> h.m_203656_(this.key)).orElse(false).booleanValue()) continue;
                stacks.add(new ItemStack((ItemLike)item));
            }
            return stacks;
        }

        @Override
        public ItemStack getStack() {
            ItemStack stack = this.toStacks().get(0);
            return new ItemStack((ItemLike)stack.m_41720_(), this.stacksize, stack.m_41783_());
        }

        @Override
        public List<ItemStack> getStackList() {
            List<ItemStack> list = Library.copyItemStackList(this.toStacks());
            for (ItemStack stack : list) {
                stack.m_41764_(this.stacksize);
            }
            return list;
        }

        public int hashCode() {
            return Objects.hash(this.key.f_203868_(), this.stacksize);
        }

        @Override
        public AStack singulize() {
            this.stacksize = 1;
            return this;
        }

        @Override
        public int compareTo(AStack stack) {
            if (stack instanceof OreDictStack) {
                OreDictStack comp = (OreDictStack)stack;
                return this.key.f_203868_().compareTo(comp.key.f_203868_());
            }
            if (stack instanceof ComparableStack) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            if (stack == null || stack.m_41619_()) {
                return false;
            }
            if (!ignoreSize && stack.m_41613_() < this.stacksize) {
                return false;
            }
            return stack.m_204117_(this.key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OreDictStack)) {
                return false;
            }
            OreDictStack other = (OreDictStack)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return this.stacksize == other.stacksize;
        }

        @Override
        public AStack copy() {
            return new OreDictStack(this.key, this.stacksize);
        }

        @Override
        public String toString() {
            return "OreDictStack: name, " + String.valueOf(this.key.f_203868_()) + ", stacksize, " + this.stacksize;
        }
    }

    public static class NbtComparableStack
    extends ComparableStack {
        ItemStack stack;

        public NbtComparableStack(ItemStack stack) {
            super(stack);
            this.stack = stack.m_41777_();
        }

        @Override
        public ComparableStack makeSingular() {
            ItemStack st = this.stack.m_41777_();
            st.m_41764_(1);
            return new NbtComparableStack(st);
        }

        @Override
        public AStack singulize() {
            this.stack.m_41764_(1);
            this.stacksize = 1;
            return this;
        }

        @Override
        public ItemStack toStack() {
            return this.stack.m_41777_();
        }

        @Override
        public ItemStack getStack() {
            return this.toStack();
        }

        @Override
        public int hashCode() {
            if (!this.stack.m_41782_()) {
                return super.hashCode();
            }
            return super.hashCode() * 31 + this.stack.m_41783_().hashCode();
        }

        @Override
        public AStack copy() {
            return new NbtComparableStack(this.stack);
        }

        @Override
        public boolean equals(Object obj) {
            if (!this.stack.m_41782_() || !(obj instanceof NbtComparableStack)) {
                return super.equals(obj);
            }
            return super.equals(obj) && Library.tagContainsOther(this.stack.m_41783_(), ((NbtComparableStack)obj).stack.m_41783_());
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            return super.matchesRecipe(stack, ignoreSize) && Library.tagContainsOther(this.stack.m_41783_(), stack.m_41783_());
        }

        @Override
        public String toString() {
            return "NbtComparableStack: " + this.stack.toString();
        }
    }

    public static class ComparableStack
    extends AStack {
        public Item item;

        public ComparableStack(ItemStack stack) {
            this.item = stack.m_41720_();
            this.stacksize = stack.m_41613_();
        }

        public ComparableStack makeSingular() {
            this.stacksize = 1;
            return this;
        }

        @Override
        public AStack singulize() {
            this.stacksize = 1;
            return this;
        }

        public ComparableStack(Item item) {
            this.item = item;
            this.stacksize = 1;
        }

        public ComparableStack(Block item) {
            this.item = item.m_5456_();
            this.stacksize = 1;
        }

        public ComparableStack(Item item, int stacksize) {
            this(item);
            this.stacksize = stacksize;
        }

        public ComparableStack(Item item, int stacksize, CompoundTag meta) {
            this(item, stacksize);
        }

        public ComparableStack(Block item, int stacksize) {
            this.item = item.m_5456_();
            this.stacksize = stacksize;
        }

        public ItemStack toStack() {
            return new ItemStack((ItemLike)this.item, this.stacksize);
        }

        @Override
        public ItemStack getStack() {
            return this.toStack();
        }

        @Override
        public List<ItemStack> getStackList() {
            return Arrays.asList(this.getStack());
        }

        public String[] getDictKeys() {
            Set tags = ForgeRegistries.ITEMS.getHolder((Object)this.toStack().m_41720_()).stream().flatMap(holder -> holder.m_203616_().map(TagKey::f_203868_)).collect(Collectors.toSet());
            if (tags.isEmpty()) {
                return new String[0];
            }
            ArrayList<String> entries = new ArrayList<String>();
            for (ResourceLocation loc : tags) {
                entries.add(loc.toString());
            }
            return entries.toArray(new String[0]);
        }

        public int hashCode() {
            ResourceLocation name;
            int prime = 31;
            int result = 1;
            if (this.item == null) {
                HBM.LOGGER.error("ComparableStack has a null item! This is a serious issue!");
                Thread.dumpStack();
                this.item = Items.f_42398_;
            }
            if ((name = ForgeRegistries.ITEMS.getKey((Object)this.item)) == null) {
                HBM.LOGGER.error("ComparableStack holds an item that does not seem to be registered. How does that even happen?");
                Thread.dumpStack();
                this.item = Items.f_42398_;
            }
            if (name != null) {
                result = 31 * result + ForgeRegistries.ITEMS.getKey((Object)this.item).hashCode();
            }
            result = 31 * result;
            result = 31 * result + this.stacksize;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ComparableStack)) {
                return false;
            }
            ComparableStack other = (ComparableStack)obj;
            if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
                return false;
            }
            return this.stacksize == other.stacksize;
        }

        @Override
        public int compareTo(AStack stack) {
            if (stack instanceof ComparableStack) {
                int thatID;
                ComparableStack comp = (ComparableStack)stack;
                int thisID = Item.m_41393_((Item)this.item);
                if (thisID > (thatID = Item.m_41393_((Item)comp.item))) {
                    return 1;
                }
                if (thatID > thisID) {
                    return -1;
                }
                return 0;
            }
            if (stack instanceof OreDictStack) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            if (stack == null) {
                return false;
            }
            if (stack.m_41720_() != this.item) {
                return false;
            }
            return ignoreSize || stack.m_41613_() >= this.stacksize;
        }

        @Override
        public AStack copy() {
            return new ComparableStack(this.item, this.stacksize);
        }

        @Override
        public String toString() {
            return "ComparableStack: { " + this.stacksize + " x " + this.item.m_5524_() + "}";
        }
    }

    public static abstract class AStack
    implements Comparable<AStack> {
        protected int stacksize;

        public boolean isApplicable(ItemStack stack) {
            return this.isApplicable(new NbtComparableStack(stack));
        }

        public AStack singulize() {
            this.stacksize = 1;
            return this;
        }

        public int count() {
            return this.stacksize;
        }

        public void setCount(int c) {
            this.stacksize = c;
        }

        public boolean isApplicable(ComparableStack comp) {
            if (this instanceof ComparableStack) {
                return ((ComparableStack)this).equals(comp);
            }
            if (this instanceof OreDictStack) {
                ArrayList<ItemStack> ores = new ArrayList<ItemStack>();
                for (Item item : ForgeRegistries.ITEMS.getValues()) {
                    if (!((Holder)ForgeRegistries.ITEMS.getHolder((Object)item).orElseThrow()).m_203656_(((OreDictStack)this).key)) continue;
                    ores.add(new ItemStack((ItemLike)item));
                }
                for (ItemStack stack : ores) {
                    if (stack.m_41720_() != comp.item) continue;
                    return true;
                }
            }
            return false;
        }

        public abstract boolean matchesRecipe(ItemStack var1, boolean var2);

        public abstract AStack copy();

        public abstract ItemStack getStack();

        public abstract List<ItemStack> getStackList();

        public String toString() {
            return "AStack: size, " + this.stacksize;
        }
    }
}

