/*
 * Decompiled with CFR 0.152.
 */
package com.rakib.lunarblockoverlay;

import com.rakib.lunarblockoverlay.ConfigHandler;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class BlockOverlay {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final ConfigHandler configHandler;
    private int colorIndex = 0;
    public static final Color[] COLORS = new Color[]{Color.WHITE, Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, new Color(75, 0, 130), Color.MAGENTA, Color.BLACK, null, new Color(255, 20, 147)};
    public static final String[] COLOR_NAMES = new String[]{"White", "Red", "Orange", "Yellow", "Green", "Blue", "Indigo", "Pink", "Black", "None", "Chromatic"};
    private static final String[] COLOR_CODES = new String[]{"\u00c2\u00a7f", "\u00c2\u00a7c", "\u00c2\u00a76", "\u00c2\u00a7e", "\u00c2\u00a7a", "\u00c2\u00a79", "\u00c2\u00a75", "\u00c2\u00a7d", "\u00c2\u00a70", "\u00c2\u00a77", "\u00c2\u00a7d"};
    private static final float[] THICKNESS_LEVELS = new float[]{0.5f, 0.8f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f};
    private int thicknessIndex = 3;
    private OverlayStyle currentStyle = OverlayStyle.DEFAULT;
    private boolean enabled = true;
    private static final double MAX_RENDER_DISTANCE = 32.0;

    public BlockOverlay(ConfigHandler configHandler) {
        this.configHandler = configHandler;
        this.colorIndex = configHandler.getColorIndex();
        this.thicknessIndex = configHandler.getThicknessIndex();
        this.currentStyle = configHandler.getOverlayStyle();
        this.enabled = configHandler.isEnabled();
    }

    public void cycleColor() {
        this.colorIndex = (this.colorIndex + 1) % COLORS.length;
        this.configHandler.setColorIndex(this.colorIndex);
    }

    public void setColor(int index) {
        if (index >= 0 && index < COLORS.length) {
            this.colorIndex = index;
            this.configHandler.setColorIndex(this.colorIndex);
        }
    }

    public void cycleStyle() {
        OverlayStyle[] styles = OverlayStyle.values();
        this.currentStyle = styles[(this.currentStyle.ordinal() + 1) % styles.length];
        this.configHandler.setOverlayStyle(this.currentStyle);
    }

    public void setStyle(OverlayStyle style) {
        this.currentStyle = style;
        this.configHandler.setOverlayStyle(this.currentStyle);
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
        this.configHandler.setEnabled(this.enabled);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.configHandler.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getCurrentColorName() {
        return COLOR_NAMES[this.colorIndex];
    }

    public OverlayStyle getCurrentStyle() {
        return this.currentStyle;
    }

    public String getCurrentStyleName() {
        return this.currentStyle.getName();
    }

    public String getFormattedColorMessage() {
        return "Block Overlay: Color changed to " + COLOR_NAMES[this.colorIndex] + ".";
    }

    public float getOverlayThickness() {
        return THICKNESS_LEVELS[this.thicknessIndex];
    }

    public void setThickness(int index) {
        if (index >= 0 && index < THICKNESS_LEVELS.length) {
            this.thicknessIndex = index;
            this.configHandler.setThicknessIndex(this.thicknessIndex);
        }
    }

    public void increaseThickness() {
        if (this.thicknessIndex < THICKNESS_LEVELS.length - 1) {
            ++this.thicknessIndex;
            this.configHandler.setThicknessIndex(this.thicknessIndex);
        }
    }

    public void decreaseThickness() {
        if (this.thicknessIndex > 0) {
            --this.thicknessIndex;
            this.configHandler.setThicknessIndex(this.thicknessIndex);
        }
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getThicknessIndex() {
        return this.thicknessIndex;
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!this.enabled || COLORS[this.colorIndex] == null || BlockOverlay.mc.field_71439_g == null || BlockOverlay.mc.field_71476_x == null) {
            return;
        }
        MovingObjectPosition mop = BlockOverlay.mc.field_71476_x;
        if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        BlockPos pos = mop.func_178782_a();
        if (pos == null) {
            return;
        }
        double distance = BlockOverlay.mc.field_71439_g.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (distance > 32.0) {
            return;
        }
        double x = (double)pos.func_177958_n() - (BlockOverlay.mc.field_71439_g.field_70142_S + (BlockOverlay.mc.field_71439_g.field_70165_t - BlockOverlay.mc.field_71439_g.field_70142_S) * (double)event.partialTicks);
        double y = (double)pos.func_177956_o() - (BlockOverlay.mc.field_71439_g.field_70137_T + (BlockOverlay.mc.field_71439_g.field_70163_u - BlockOverlay.mc.field_71439_g.field_70137_T) * (double)event.partialTicks);
        double z = (double)pos.func_177952_p() - (BlockOverlay.mc.field_71439_g.field_70136_U + (BlockOverlay.mc.field_71439_g.field_70161_v - BlockOverlay.mc.field_71439_g.field_70136_U) * (double)event.partialTicks);
        Color currentColor = this.colorIndex == COLORS.length - 1 ? this.getChromaticColor() : COLORS[this.colorIndex];
        this.drawStyleOutline(x, y, z, currentColor, this.currentStyle);
    }

    private Color getChromaticColor() {
        long currentTime = System.currentTimeMillis();
        float hue = (float)((double)(currentTime % 5000L) / 5000.0);
        return Color.getHSBColor(hue, 0.8f, 1.0f);
    }

    private void drawStyleOutline(double x, double y, double z, Color color, OverlayStyle style) {
        switch (style) {
            case DEFAULT: {
                this.drawDefaultOutline(x, y, z, color);
                break;
            }
            case FILLED: {
                this.drawFilledOutline(x, y, z, color);
                break;
            }
            case CORNERS: {
                this.drawCornerOutline(x, y, z, color);
                break;
            }
            case GRADIENT: {
                this.drawGradientOutline(x, y, z, color);
            }
        }
    }

    private void drawDefaultOutline(double x, double y, double z, Color color) {
        GlStateManager.func_179094_E();
        this.setupGL();
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
        GL11.glLineWidth((float)this.getOverlayThickness());
        RenderGlobal.func_181561_a((AxisAlignedBB)new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0));
        this.cleanupGL();
        GlStateManager.func_179121_F();
    }

    private void drawFilledOutline(double x, double y, double z, Color color) {
        GlStateManager.func_179094_E();
        GL11.glEnable((int)32823);
        GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
        this.setupGL();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = 0.4f;
        double shrink = 0.001;
        AxisAlignedBB box = new AxisAlignedBB(x + shrink, y + shrink, z + shrink, x + 1.0 - shrink, y + 1.0 - shrink, z + 1.0 - shrink);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        AxisAlignedBB outlineBox = new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
        GL11.glLineWidth((float)this.getOverlayThickness());
        RenderGlobal.func_181561_a((AxisAlignedBB)outlineBox);
        GL11.glDisable((int)32823);
        this.cleanupGL();
        GlStateManager.func_179121_F();
    }

    private void drawCornerOutline(double x, double y, double z, Color color) {
        GlStateManager.func_179094_E();
        this.setupGL();
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
        GL11.glLineWidth((float)(this.getOverlayThickness() * 2.0f));
        AxisAlignedBB box = new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        double cornerSize = 0.2;
        this.addCornerLine(worldRenderer, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72340_a + cornerSize, box.field_72338_b, box.field_72339_c, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72338_b, box.field_72339_c + cornerSize, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72336_d, box.field_72338_b, box.field_72339_c, box.field_72336_d - cornerSize, box.field_72338_b, box.field_72339_c, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72336_d, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72339_c + cornerSize, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72340_a + cornerSize, box.field_72338_b, box.field_72334_f, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72334_f - cornerSize, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72336_d - cornerSize, box.field_72338_b, box.field_72334_f, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72336_d, box.field_72338_b, box.field_72334_f - cornerSize, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72340_a + cornerSize, box.field_72337_e, box.field_72339_c, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72340_a, box.field_72337_e, box.field_72339_c + cornerSize, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72336_d - cornerSize, box.field_72337_e, box.field_72339_c, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72339_c + cornerSize, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72340_a + cornerSize, box.field_72337_e, box.field_72334_f, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72334_f - cornerSize, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72336_d - cornerSize, box.field_72337_e, box.field_72334_f, r, g, b);
        this.addCornerLine(worldRenderer, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72336_d, box.field_72337_e, box.field_72334_f - cornerSize, r, g, b);
        tessellator.func_78381_a();
        this.cleanupGL();
        GlStateManager.func_179121_F();
    }

    private void addCornerLine(WorldRenderer worldRenderer, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b) {
        worldRenderer.func_181662_b(x1, y1, z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(x2, y2, z2).func_181666_a(r, g, b, 1.0f).func_181675_d();
    }

    private void drawGradientOutline(double x, double y, double z, Color color) {
        GlStateManager.func_179094_E();
        this.setupGL();
        AxisAlignedBB box = new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0);
        Color topColor = color.brighter();
        Color bottomColor = color.darker();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        GL11.glLineWidth((float)this.getOverlayThickness());
        worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        this.drawGradientLine(worldRenderer, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72337_e, box.field_72339_c, bottomColor, topColor);
        this.drawGradientLine(worldRenderer, box.field_72336_d, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72339_c, bottomColor, topColor);
        this.drawGradientLine(worldRenderer, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72334_f, bottomColor, topColor);
        this.drawGradientLine(worldRenderer, box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72336_d, box.field_72337_e, box.field_72334_f, bottomColor, topColor);
        this.drawLine(worldRenderer, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72339_c, bottomColor);
        this.drawLine(worldRenderer, box.field_72336_d, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72334_f, bottomColor);
        this.drawLine(worldRenderer, box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72334_f, bottomColor);
        this.drawLine(worldRenderer, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72339_c, bottomColor);
        this.drawLine(worldRenderer, box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72339_c, topColor);
        this.drawLine(worldRenderer, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, topColor);
        this.drawLine(worldRenderer, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72334_f, topColor);
        this.drawLine(worldRenderer, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72339_c, topColor);
        tessellator.func_78381_a();
        this.cleanupGL();
        GlStateManager.func_179121_F();
    }

    private void drawGradientLine(WorldRenderer worldRenderer, double x1, double y1, double z1, double x2, double y2, double z2, Color startColor, Color endColor) {
        int segments = 8;
        for (int i = 0; i < segments; ++i) {
            double progress1 = (double)i / (double)segments;
            double progress2 = (double)(i + 1) / (double)segments;
            Color color1 = this.interpolateColor(startColor, endColor, progress1);
            Color color2 = this.interpolateColor(startColor, endColor, progress2);
            double segX1 = x1 + (x2 - x1) * progress1;
            double segY1 = y1 + (y2 - y1) * progress1;
            double segZ1 = z1 + (z2 - z1) * progress1;
            double segX2 = x1 + (x2 - x1) * progress2;
            double segY2 = y1 + (y2 - y1) * progress2;
            double segZ2 = z1 + (z2 - z1) * progress2;
            this.drawLine(worldRenderer, segX1, segY1, segZ1, segX2, segY2, segZ2, color1);
        }
    }

    private void drawLine(WorldRenderer worldRenderer, double x1, double y1, double z1, double x2, double y2, double z2, Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        worldRenderer.func_181662_b(x1, y1, z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldRenderer.func_181662_b(x2, y2, z2).func_181666_a(r, g, b, 1.0f).func_181675_d();
    }

    private Color interpolateColor(Color start, Color end, double progress) {
        int r = (int)((double)start.getRed() + (double)(end.getRed() - start.getRed()) * progress);
        int g = (int)((double)start.getGreen() + (double)(end.getGreen() - start.getGreen()) * progress);
        int b = (int)((double)start.getBlue() + (double)(end.getBlue() - start.getBlue()) * progress);
        return new Color(r, g, b);
    }

    private void setupGL() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179129_p();
    }

    private void cleanupGL() {
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
    }

    public static enum OverlayStyle {
        DEFAULT("Default"),
        FILLED("Filled"),
        CORNERS("Corners"),
        GRADIENT("Gradient");

        private final String name;

        private OverlayStyle(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

