/*
 * Decompiled with CFR 0.152.
 */
package com.rakib.lunarblockoverlay;

import com.rakib.lunarblockoverlay.BlockOverlay;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;

public class BlockOverlayGui
extends GuiScreen {
    private final BlockOverlay blockOverlay;
    private final GuiScreen parentScreen;
    private GuiButton toggleButton;
    private GuiButton colorButton;
    private GuiButton styleButton;
    private GuiButton thicknessUpButton;
    private GuiButton thicknessDownButton;
    private GuiButton closeButton;

    public BlockOverlayGui(BlockOverlay blockOverlay, GuiScreen parentScreen) {
        this.blockOverlay = blockOverlay;
        this.parentScreen = parentScreen;
    }

    public void func_73866_w_() {
        int centerX = this.field_146294_l / 2;
        int buttonWidth = 150;
        int buttonHeight = 20;
        int startY = this.field_146295_m / 2 - 60;
        int buttonSpacing = 25;
        this.toggleButton = new GuiButton(0, centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight, "");
        this.field_146292_n.add(this.toggleButton);
        this.colorButton = new GuiButton(1, centerX - buttonWidth / 2, startY + buttonSpacing, buttonWidth, buttonHeight, "");
        this.field_146292_n.add(this.colorButton);
        this.styleButton = new GuiButton(2, centerX - buttonWidth / 2, startY + buttonSpacing * 2, buttonWidth, buttonHeight, "");
        this.field_146292_n.add(this.styleButton);
        int thicknessButtonWidth = 70;
        this.thicknessDownButton = new GuiButton(3, centerX - thicknessButtonWidth - 5, startY + buttonSpacing * 3, thicknessButtonWidth, buttonHeight, "Decrease");
        this.field_146292_n.add(this.thicknessDownButton);
        this.thicknessUpButton = new GuiButton(4, centerX + 5, startY + buttonSpacing * 3, thicknessButtonWidth, buttonHeight, "Increase");
        this.field_146292_n.add(this.thicknessUpButton);
        this.closeButton = new GuiButton(5, centerX - buttonWidth / 2, startY + buttonSpacing * 4, buttonWidth, buttonHeight, "Close");
        this.field_146292_n.add(this.closeButton);
        this.updateButtonLabels();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, EnumChatFormatting.GOLD + "Lunar Block Overlay Settings", this.field_146294_l / 2, 40, 0xFFFFFF);
        String status = this.blockOverlay.isEnabled() ? EnumChatFormatting.GREEN + "ENABLED" : EnumChatFormatting.RED + "DISABLED";
        this.func_73732_a(this.field_146289_q, "Status: " + status, this.field_146294_l / 2, 60, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "Color: " + this.blockOverlay.getCurrentColorName(), this.field_146294_l / 2, 72, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "Style: " + this.blockOverlay.getCurrentStyleName(), this.field_146294_l / 2, 84, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "Thickness: " + this.blockOverlay.getOverlayThickness(), this.field_146294_l / 2, 96, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, EnumChatFormatting.GRAY + "You can also use " + EnumChatFormatting.YELLOW + "/bo" + EnumChatFormatting.GRAY + " command", this.field_146294_l / 2, this.field_146295_m - 30, 0xFFFFFF);
        this.updateButtonLabels();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void updateButtonLabels() {
        String toggleText = this.blockOverlay.isEnabled() ? EnumChatFormatting.RED + "Disable" : EnumChatFormatting.GREEN + "Enable";
        this.toggleButton.field_146126_j = toggleText + " Overlay";
        this.colorButton.field_146126_j = "Color: " + this.blockOverlay.getCurrentColorName();
        this.styleButton.field_146126_j = "Style: " + this.blockOverlay.getCurrentStyleName();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                this.blockOverlay.toggleEnabled();
                this.blockOverlay.getConfigHandler().saveConfig();
                break;
            }
            case 1: {
                this.blockOverlay.cycleColor();
                this.blockOverlay.getConfigHandler().saveConfig();
                break;
            }
            case 2: {
                this.blockOverlay.cycleStyle();
                this.blockOverlay.getConfigHandler().saveConfig();
                break;
            }
            case 3: {
                this.blockOverlay.decreaseThickness();
                this.blockOverlay.getConfigHandler().saveConfig();
                break;
            }
            case 4: {
                this.blockOverlay.increaseThickness();
                this.blockOverlay.getConfigHandler().saveConfig();
                break;
            }
            case 5: {
                this.field_146297_k.func_147108_a(this.parentScreen);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.parentScreen);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public boolean func_73868_f() {
        return false;
    }
}

