/*
 * Decompiled with CFR 0.152.
 */
package com.rakib.lunarblockoverlay;

import com.rakib.lunarblockoverlay.BlockOverlay;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    private Configuration config;
    private static final String CATEGORY_VISUAL = "visual";
    private int colorIndex;
    private int thicknessIndex;
    private String overlayStyle;
    private boolean enabled;

    public void init(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.loadConfiguration();
        }
    }

    private void loadConfiguration() {
        this.colorIndex = this.config.getInt("Color Index", CATEGORY_VISUAL, 0, 0, 10, "Current color index (0-10)");
        this.thicknessIndex = this.config.getInt("Thickness Index", CATEGORY_VISUAL, 3, 0, 7, "Current thickness index (0-7)");
        this.overlayStyle = this.config.getString("Overlay Style", CATEGORY_VISUAL, "DEFAULT", "Overlay style (DEFAULT, FILLED, CORNERS, GRADIENT)");
        this.enabled = this.config.getBoolean("Enabled", CATEGORY_VISUAL, true, "Whether the block overlay is enabled");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public void saveConfig() {
        if (this.config != null) {
            this.config.get(CATEGORY_VISUAL, "Color Index", 0).set(this.colorIndex);
            this.config.get(CATEGORY_VISUAL, "Thickness Index", 3).set(this.thicknessIndex);
            this.config.get(CATEGORY_VISUAL, "Overlay Style", "DEFAULT").set(this.overlayStyle);
            this.config.get(CATEGORY_VISUAL, "Enabled", true).set(this.enabled);
            this.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("lunarblockoverlay")) {
            this.loadConfiguration();
        }
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    public int getThicknessIndex() {
        return this.thicknessIndex;
    }

    public void setThicknessIndex(int thicknessIndex) {
        this.thicknessIndex = thicknessIndex;
    }

    public BlockOverlay.OverlayStyle getOverlayStyle() {
        try {
            return BlockOverlay.OverlayStyle.valueOf(this.overlayStyle);
        }
        catch (IllegalArgumentException e) {
            return BlockOverlay.OverlayStyle.DEFAULT;
        }
    }

    public void setOverlayStyle(BlockOverlay.OverlayStyle overlayStyle) {
        this.overlayStyle = overlayStyle.name();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

