/*
 * Decompiled with CFR 0.152.
 */
package com.rakib.lunarblockoverlay;

import com.rakib.lunarblockoverlay.BlockOverlay;
import com.rakib.lunarblockoverlay.BlockOverlayCommand;
import com.rakib.lunarblockoverlay.BlockOverlayGui;
import com.rakib.lunarblockoverlay.ConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(modid="lunarblockoverlay", name="Lunar Block Overlay", version="2.1", clientSideOnly=true, acceptedMinecraftVersions="[1.8.9]")
public class LunarBlockOverlay {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private BlockOverlay blockOverlay;
    private ConfigHandler configHandler;
    private BlockOverlayCommand blockOverlayCommand;
    private KeyBinding toggleKey;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configHandler = new ConfigHandler();
        this.configHandler.init(event.getSuggestedConfigurationFile());
        this.blockOverlay = new BlockOverlay(this.configHandler);
        this.toggleKey = new KeyBinding("Change Block Overlay Color", 43, "Lunar Block Overlay");
        ClientRegistry.registerKeyBinding((KeyBinding)this.toggleKey);
        MinecraftForge.EVENT_BUS.register((Object)this.configHandler);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.blockOverlay);
        this.blockOverlayCommand = new BlockOverlayCommand(this.blockOverlay);
        ClientCommandHandler.instance.func_71560_a((ICommand)this.blockOverlayCommand);
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        if (this.toggleKey.func_151468_f()) {
            this.blockOverlay.cycleColor();
            String colorMessage = this.blockOverlay.getFormattedColorMessage();
            if (LunarBlockOverlay.mc.field_71439_g != null) {
                LunarBlockOverlay.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(colorMessage));
            }
            this.configHandler.saveConfig();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.blockOverlayCommand != null && this.blockOverlayCommand.isGuiRequested()) {
            this.blockOverlayCommand.resetGuiRequest();
            if (LunarBlockOverlay.mc.field_71439_g != null && LunarBlockOverlay.mc.field_71462_r == null) {
                mc.func_147108_a((GuiScreen)new BlockOverlayGui(this.blockOverlay, null));
            }
        }
    }
}

