/*
 * Decompiled with CFR 0.152.
 */
package dev.tvch.staffMode;

import dev.tvch.staffMode.PlayerState;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/tvch/staffMode/PlayerStateManager;", "", "<init>", "()V", "savedStates", "", "Ljava/util/UUID;", "Ldev/tvch/staffMode/PlayerState;", "savePlayerState", "", "player", "Lorg/bukkit/entity/Player;", "restorePlayerState", "staff-mode"})
public final class PlayerStateManager {
    @NotNull
    private final Map<UUID, PlayerState> savedStates = new LinkedHashMap();

    public final void savePlayerState(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        ItemStack[] itemStackArray = (ItemStack[])player.getInventory().getContents().clone();
        ItemStack[] itemStackArray2 = (ItemStack[])player.getInventory().getArmorContents().clone();
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        GameMode gameMode = player.getGameMode();
        Intrinsics.checkNotNullExpressionValue(gameMode, "getGameMode(...)");
        PlayerState state = new PlayerState(itemStackArray, itemStackArray2, location, gameMode, player.getAllowFlight(), player.getHealth(), player.getFoodLevel());
        this.savedStates.put(player.getUniqueId(), state);
    }

    public final void restorePlayerState(@NotNull Player player) {
        block0: {
            Intrinsics.checkNotNullParameter(player, "player");
            PlayerState playerState = this.savedStates.remove(player.getUniqueId());
            if (playerState == null) break block0;
            PlayerState state = playerState;
            boolean bl = false;
            player.getInventory().setContents(state.getInventoryContents());
            player.getInventory().setArmorContents(state.getArmorContents());
            player.teleport(state.getLocation());
            player.setGameMode(state.getGameMode());
            player.setAllowFlight(state.getAllowFlight());
            player.setHealth(state.getHealth());
            player.setFoodLevel(state.getFoodLevel());
        }
    }
}

