/*
 * Decompiled with CFR 0.152.
 */
package dev.tvch.staffMode;

import dev.tvch.staffMode.PlayerStateManager;
import dev.tvch.staffMode.StaffMode;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J5\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/tvch/staffMode/StaffModeCommand;", "Lorg/bukkit/command/CommandExecutor;", "plugin", "Ldev/tvch/staffMode/StaffMode;", "playerStateManager", "Ldev/tvch/staffMode/PlayerStateManager;", "<init>", "(Ldev/tvch/staffMode/StaffMode;Ldev/tvch/staffMode/PlayerStateManager;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "enableStaffMode", "", "player", "Lorg/bukkit/entity/Player;", "disableStaffMode", "createNavigatorTool", "Lorg/bukkit/inventory/ItemStack;", "createInspectorTool", "createInvseeTool", "createFreezeTool", "staff-mode"})
@SourceDebugExtension(value={"SMAP\nStaffModeCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StaffModeCommand.kt\ndev/tvch/staffMode/StaffModeCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1869#2,2:105\n1869#2,2:107\n*S KotlinDebug\n*F\n+ 1 StaffModeCommand.kt\ndev/tvch/staffMode/StaffModeCommand\n*L\n37#1:105,2\n59#1:107,2\n*E\n"})
public final class StaffModeCommand
implements CommandExecutor {
    @NotNull
    private final StaffMode plugin;
    @NotNull
    private final PlayerStateManager playerStateManager;

    public StaffModeCommand(@NotNull StaffMode plugin, @NotNull PlayerStateManager playerStateManager) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(playerStateManager, "playerStateManager");
        this.plugin = plugin;
        this.playerStateManager = playerStateManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        if (!sender.hasPermission("staffmode.use")) {
            sender.sendMessage(ChatColor.RED + "You do not have permission to use this command.");
            return true;
        }
        if (this.plugin.getStaffModePlayers().contains(((Player)sender).getUniqueId())) {
            this.disableStaffMode((Player)sender);
        } else {
            this.enableStaffMode((Player)sender);
        }
        return true;
    }

    private final void enableStaffMode(Player player) {
        Set<UUID> set = this.plugin.getStaffModePlayers();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        set.add(uUID);
        this.playerStateManager.savePlayerState(player);
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player otherPlayer = (Player)element$iv;
            boolean bl = false;
            if (otherPlayer.hasPermission("staffmode.use")) continue;
            otherPlayer.hidePlayer((Plugin)this.plugin, player);
        }
        player.setGameMode(GameMode.CREATIVE);
        player.getInventory().clear();
        player.getInventory().setItem(1, this.createNavigatorTool());
        player.getInventory().setItem(3, this.createFreezeTool());
        player.getInventory().setItem(5, this.createInspectorTool());
        player.getInventory().setItem(7, this.createInvseeTool());
        player.sendMessage(ChatColor.GREEN + "Staff mode enabled. You are now invisible to regular players.");
    }

    private final void disableStaffMode(Player player) {
        this.plugin.getStaffModePlayers().remove(player.getUniqueId());
        player.getInventory().clear();
        this.playerStateManager.restorePlayerState(player);
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player otherPlayer = (Player)element$iv;
            boolean bl = false;
            otherPlayer.showPlayer((Plugin)this.plugin, player);
        }
        player.sendMessage(ChatColor.RED + "Staff mode disabled. You are now visible.");
    }

    private final ItemStack createNavigatorTool() {
        ItemMeta meta;
        ItemStack navigator = new ItemStack(Material.COMPASS);
        ItemMeta itemMeta = meta = navigator.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(ChatColor.GREEN + ChatColor.BOLD + "Player Navigator");
        }
        ItemMeta itemMeta2 = meta;
        if (itemMeta2 != null) {
            String[] stringArray = new String[]{ChatColor.GRAY + "Right-Click: Open player list.", ChatColor.GRAY + "Left-Click: Teleport to block."};
            itemMeta2.setLore(CollectionsKt.listOf(stringArray));
        }
        navigator.setItemMeta(meta);
        return navigator;
    }

    private final ItemStack createInspectorTool() {
        ItemMeta meta;
        ItemStack inspector = new ItemStack(Material.SPYGLASS);
        ItemMeta itemMeta = meta = inspector.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(ChatColor.YELLOW + ChatColor.BOLD + "Player Inspector");
        }
        ItemMeta itemMeta2 = meta;
        if (itemMeta2 != null) {
            itemMeta2.setLore(CollectionsKt.listOf(ChatColor.GRAY + "Right-click a player for details."));
        }
        inspector.setItemMeta(meta);
        return inspector;
    }

    private final ItemStack createInvseeTool() {
        ItemMeta meta;
        ItemStack invseeBook = new ItemStack(Material.BOOK);
        ItemMeta itemMeta = meta = invseeBook.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(ChatColor.AQUA + ChatColor.BOLD + "Invsee");
        }
        ItemMeta itemMeta2 = meta;
        if (itemMeta2 != null) {
            itemMeta2.setLore(CollectionsKt.listOf(ChatColor.GRAY + "Right-click a player to view their inventory."));
        }
        invseeBook.setItemMeta(meta);
        return invseeBook;
    }

    private final ItemStack createFreezeTool() {
        ItemMeta meta;
        ItemStack freezeIce = new ItemStack(Material.ICE);
        ItemMeta itemMeta = meta = freezeIce.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(ChatColor.AQUA + ChatColor.BOLD + "Freeze");
        }
        ItemMeta itemMeta2 = meta;
        if (itemMeta2 != null) {
            itemMeta2.setLore(CollectionsKt.listOf(ChatColor.GRAY + "Right-click a player to freeze them."));
        }
        freezeIce.setItemMeta(meta);
        return freezeIce;
    }
}

