/*
 * Decompiled with CFR 0.152.
 */
package dev.tvch.staffMode;

import dev.tvch.staffMode.PlayerStateManager;
import dev.tvch.staffMode.StaffMode;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 H\u0002J\u0018\u0010$\u001a\u00020\t2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020\t2\u0006\u0010\n\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020\t2\u0006\u0010\n\u001a\u00020(H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/tvch/staffMode/StaffModeListener;", "Lorg/bukkit/event/Listener;", "plugin", "Ldev/tvch/staffMode/StaffMode;", "playerStateManager", "Ldev/tvch/staffMode/PlayerStateManager;", "<init>", "(Ldev/tvch/staffMode/StaffMode;Ldev/tvch/staffMode/PlayerStateManager;)V", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onEntityDamageByEntity", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onEntityPickupItem", "Lorg/bukkit/event/entity/EntityPickupItemEvent;", "onPlayerDropItem", "Lorg/bukkit/event/player/PlayerDropItemEvent;", "onBlockPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onBlockBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "onPlayerInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onInventoryClick", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onPlayerInteractAtEntity", "Lorg/bukkit/event/player/PlayerInteractAtEntityEvent;", "openNavigatorGui", "player", "Lorg/bukkit/entity/Player;", "sendPlayerReport", "staff", "target", "toggleFreeze", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onPlayerChat", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "Companion", "staff-mode"})
@SourceDebugExtension(value={"SMAP\nStaffModeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StaffModeListener.kt\ndev/tvch/staffMode/StaffModeListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1869#2,2:236\n774#2:238\n865#2,2:239\n1869#2,2:241\n*S KotlinDebug\n*F\n+ 1 StaffModeListener.kt\ndev/tvch/staffMode/StaffModeListener\n*L\n35#1:236,2\n168#1:238\n168#1:239,2\n172#1:241,2\n*E\n"})
public final class StaffModeListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StaffMode plugin;
    @NotNull
    private final PlayerStateManager playerStateManager;
    @NotNull
    private static final String NAVIGATOR_GUI_TITLE = ChatColor.DARK_BLUE + "Player Navigator";

    public StaffModeListener(@NotNull StaffMode plugin, @NotNull PlayerStateManager playerStateManager) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(playerStateManager, "playerStateManager");
        this.plugin = plugin;
        this.playerStateManager = playerStateManager;
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player joinedPlayer = player;
        Collection collection = this.plugin.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player onlinePlayer = (Player)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(onlinePlayer.getUniqueId(), joinedPlayer.getUniqueId()) || !this.plugin.getStaffModePlayers().contains(onlinePlayer.getUniqueId())) continue;
            joinedPlayer.hidePlayer((Plugin)this.plugin, onlinePlayer);
        }
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (this.plugin.getStaffModePlayers().contains(player2.getUniqueId())) {
            this.plugin.getStaffModePlayers().remove(player2.getUniqueId());
            this.playerStateManager.restorePlayerState(player2);
        }
        if (this.plugin.getFrozenPlayers().contains(player2.getUniqueId())) {
            BukkitTask bukkitTask = this.plugin.getFrozenTitleTasks().get(player2.getUniqueId());
            if (bukkitTask != null) {
                bukkitTask.cancel();
            }
            this.plugin.getFrozenTitleTasks().remove(player2.getUniqueId());
            this.plugin.getFrozenPlayers().remove(player2.getUniqueId());
            String command = "ban " + player2.getName() + " 7d [StaffMode] Logged out while frozen.";
            Bukkit.dispatchCommand((CommandSender)((CommandSender)Bukkit.getConsoleSender()), (String)command);
        }
    }

    @EventHandler
    public final void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getDamager();
        Intrinsics.checkNotNullExpressionValue(entity, "getDamager(...)");
        Entity damager = entity;
        if (damager instanceof Player && this.plugin.getStaffModePlayers().contains(((Player)damager).getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onEntityPickupItem(@NotNull EntityPickupItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(livingEntity, "getEntity(...)");
        LivingEntity entity = livingEntity;
        if (entity instanceof Player && this.plugin.getStaffModePlayers().contains(((Player)entity).getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPlayerDropItem(@NotNull PlayerDropItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.plugin.getStaffModePlayers().contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onBlockPlace(@NotNull BlockPlaceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.plugin.getStaffModePlayers().contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.plugin.getStaffModePlayers().contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (!this.plugin.getStaffModePlayers().contains(player2.getUniqueId())) {
            return;
        }
        ItemStack itemStack = player2.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        ItemStack itemInHand = itemStack;
        if (itemInHand.getType() == Material.COMPASS && itemInHand.hasItemMeta()) {
            Object object = itemInHand.getItemMeta();
            boolean bl = object != null && (object = object.getDisplayName()) != null ? StringsKt.contains$default((CharSequence)object, "Navigator", false, 2, null) : false;
            if (bl) {
                Block targetBlock;
                event.setCancelled(true);
                if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    this.openNavigatorGui(player2);
                } else if ((event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) && (targetBlock = player2.getTargetBlockExact(100)) != null) {
                    player2.teleport(targetBlock.getLocation().add(0.0, 1.0, 0.0));
                }
            }
        }
    }

    @EventHandler
    public final void onInventoryClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (Intrinsics.areEqual(event.getView().getTitle(), NAVIGATOR_GUI_TITLE)) {
            event.setCancelled(true);
            ItemStack itemStack = event.getCurrentItem();
            if (itemStack == null) {
                return;
            }
            ItemStack clickedItem = itemStack;
            if (clickedItem.getType() == Material.PLAYER_HEAD) {
                Player targetPlayer;
                ItemMeta itemMeta = clickedItem.getItemMeta();
                String targetName = ChatColor.stripColor((String)(itemMeta != null ? itemMeta.getDisplayName() : null));
                String string = targetName;
                if (string == null) {
                    string = "";
                }
                if ((targetPlayer = Bukkit.getPlayer((String)string)) != null) {
                    player2.teleport((Entity)targetPlayer);
                    player2.closeInventory();
                } else {
                    player2.sendMessage(ChatColor.RED + "Player not found.");
                    player2.closeInventory();
                }
            }
            return;
        }
        if (this.plugin.getStaffModePlayers().contains(player2.getUniqueId()) && player2.getGameMode() == GameMode.CREATIVE && !Intrinsics.areEqual(event.getClickedInventory(), player2.getInventory())) {
            event.setCancelled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    public final void onPlayerInteractAtEntity(@NotNull PlayerInteractAtEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player staff = player;
        if (!this.plugin.getStaffModePlayers().contains(staff.getUniqueId())) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Player)) return;
        Player player2 = (Player)entity;
        if (player2 == null) {
            return;
        }
        Player target = player2;
        ItemStack itemStack = staff.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        ItemStack itemInHand = itemStack;
        if (itemInHand.getType() == Material.SPYGLASS) {
            Object object = itemInHand.getItemMeta();
            boolean bl = object != null && (object = object.getDisplayName()) != null ? StringsKt.contains$default((CharSequence)object, "Inspector", false, 2, null) : false;
            if (bl) {
                event.setCancelled(true);
                this.sendPlayerReport(staff, target);
                return;
            }
        }
        if (itemInHand.getType() == Material.BOOK) {
            Object object = itemInHand.getItemMeta();
            boolean bl = object != null && (object = object.getDisplayName()) != null ? StringsKt.contains$default((CharSequence)object, "Invsee", false, 2, null) : false;
            if (bl) {
                event.setCancelled(true);
                staff.openInventory((Inventory)target.getInventory());
                return;
            }
        }
        if (itemInHand.getType() != Material.ICE) return;
        Object object = itemInHand.getItemMeta();
        if (!(object != null && (object = object.getDisplayName()) != null ? StringsKt.contains$default((CharSequence)object, "Freeze", false, 2, null) : false)) return;
        event.setCancelled(true);
        this.toggleFreeze(staff, target);
    }

    /*
     * WARNING - void declaration
     */
    private final void openNavigatorGui(Player player) {
        void $this$filterTo$iv$iv;
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getUniqueId(), player.getUniqueId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List onlinePlayers = (List)destination$iv$iv;
        int guiSize = (onlinePlayers.size() / 9 + 1) * 9;
        Inventory inventory = Bukkit.createInventory(null, (int)guiSize, (String)NAVIGATOR_GUI_TITLE);
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        Inventory gui = inventory;
        Iterable $this$forEach$iv = onlinePlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player target = (Player)element$iv;
            boolean bl = false;
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            ItemMeta itemMeta = head.getItemMeta();
            Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
            SkullMeta meta = (SkullMeta)itemMeta;
            meta.setOwningPlayer((OfflinePlayer)target);
            meta.setDisplayName(ChatColor.YELLOW + target.getName());
            head.setItemMeta((ItemMeta)meta);
            ItemStack[] itemStackArray = new ItemStack[]{head};
            gui.addItem(itemStackArray);
        }
        player.openInventory(gui);
    }

    private final void sendPlayerReport(Player staff, Player target) {
        staff.sendMessage(ChatColor.GRAY + "--- " + ChatColor.YELLOW + "Report: " + target.getName() + " " + ChatColor.GRAY + "---");
        staff.sendMessage(ChatColor.GOLD + "Gamemode: " + ChatColor.WHITE + target.getGameMode());
        String string = "%.1f";
        Object[] objectArray = new Object[]{target.getHealth()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        staff.sendMessage(ChatColor.GOLD + "Health: " + ChatColor.WHITE + string2 + " / 20");
        World world = target.getLocation().getWorld();
        staff.sendMessage(ChatColor.GOLD + "Location: " + ChatColor.WHITE + (world != null ? world.getName() : null) + " (" + target.getLocation().getBlockX() + ", " + target.getLocation().getBlockY() + ", " + target.getLocation().getBlockZ() + ")");
        Object object = target.getAddress();
        if (object == null || (object = ((InetSocketAddress)object).getHostString()) == null) {
            object = "N/A";
        }
        staff.sendMessage(ChatColor.GOLD + "IP Address: " + ChatColor.WHITE + (String)object);
    }

    private final void toggleFreeze(Player staff, Player target) {
        if (this.plugin.getFrozenPlayers().contains(target.getUniqueId())) {
            this.plugin.getFrozenPlayers().remove(target.getUniqueId());
            BukkitTask bukkitTask = this.plugin.getFrozenTitleTasks().get(target.getUniqueId());
            if (bukkitTask != null) {
                bukkitTask.cancel();
            }
            this.plugin.getFrozenTitleTasks().remove(target.getUniqueId());
            staff.sendMessage(ChatColor.YELLOW + "You have unfrozen " + target.getName() + ".");
            target.sendMessage(ChatColor.GREEN + "You have been unfrozen.");
            target.resetTitle();
        } else {
            Set<UUID> set = this.plugin.getFrozenPlayers();
            UUID uUID = target.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            set.add(uUID);
            staff.sendMessage(ChatColor.AQUA + "You have frozen " + target.getName() + ".");
            BukkitTask bukkitTask = new BukkitRunnable(target, this){
                final /* synthetic */ Player $target;
                final /* synthetic */ StaffModeListener this$0;
                {
                    this.$target = $target;
                    this.this$0 = $receiver;
                }

                public void run() {
                    if (!this.$target.isOnline() || !StaffModeListener.access$getPlugin$p(this.this$0).getFrozenPlayers().contains(this.$target.getUniqueId())) {
                        this.cancel();
                        return;
                    }
                    this.$target.sendTitle(ChatColor.AQUA + ChatColor.BOLD + "YOU ARE FROZEN", ChatColor.BLUE + "Logging out will result in a 7-day ban.", 0, 40, 20);
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 30L);
            Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimer(...)");
            BukkitTask task2 = bukkitTask;
            this.plugin.getFrozenTitleTasks().put(target.getUniqueId(), task2);
        }
    }

    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(!this.plugin.getFrozenPlayers().contains(event.getPlayer().getUniqueId()) || event.getFrom().getX() == event.getTo().getX() && event.getFrom().getY() == event.getTo().getY() && event.getFrom().getZ() == event.getTo().getZ())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPlayerChat(@NotNull AsyncPlayerChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.plugin.getFrozenPlayers().contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(ChatColor.RED + "You cannot speak while frozen.");
        }
    }

    public static final /* synthetic */ StaffMode access$getPlugin$p(StaffModeListener $this) {
        return $this.plugin;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/tvch/staffMode/StaffModeListener$Companion;", "", "<init>", "()V", "NAVIGATOR_GUI_TITLE", "", "getNAVIGATOR_GUI_TITLE", "()Ljava/lang/String;", "staff-mode"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNAVIGATOR_GUI_TITLE() {
            return NAVIGATOR_GUI_TITLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

