/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.namefix.enums.ZapinatorType;
import com.namefix.utils.Utils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class LaserProjectile
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(LaserProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Vector3f> SIZE = SynchedEntityData.defineId(LaserProjectile.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    private float baseDamage = 1.0f;
    private float baseKnockback = 0.5f;
    private boolean blockPiercing = false;
    private boolean entityPiercing = false;
    private int piercedEntities = 0;
    private int maxPiercing = 3;
    private ZapinatorType zapinatorType = ZapinatorType.NONE;
    private boolean zapinatorSlowedDown = false;

    public LaserProjectile(EntityType<? extends LaserProjectile> entityType, Level level) {
        super(entityType, level);
    }

    private void updateHitbox() {
        Vec3 direction = this.getDeltaMovement().normalize();
        Vector3f data = (Vector3f)this.getEntityData().get(SIZE);
        double endX = direction.x * (double)data.z;
        double endY = direction.y * (double)data.z;
        double endZ = direction.z * (double)data.z;
        double minX = Math.min(0.0, endX) - (double)(data.x / 2.0f);
        double minY = Math.min(0.0, endY) - (double)(data.y / 2.0f);
        double minZ = Math.min(0.0, endZ) - (double)(data.x / 2.0f);
        double maxX = Math.max(0.0, endX) + (double)(data.x / 2.0f);
        double maxY = Math.max(0.0, endY) + (double)(data.y / 2.0f);
        double maxZ = Math.max(0.0, endZ) + (double)(data.x / 2.0f);
        this.setBoundingBox(new AABB(this.getX() + minX, this.getY() + minY, this.getZ() + minZ, this.getX() + maxX, this.getY() + maxY, this.getZ() + maxZ));
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 200) {
            this.discard();
            return;
        }
        if (this.isOnFire()) {
            this.extinguishFire();
        }
        if (!this.level().isClientSide) {
            EntityHitResult entityHitResult;
            BlockHitResult blockHitResult = this.level().clip(new ClipContext(this.position(), this.position().add(this.getDeltaMovement()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (blockHitResult.getType() == HitResult.Type.BLOCK) {
                this.onHitBlock(blockHitResult);
            }
            if ((entityHitResult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)this.position(), (Vec3)this.position().add(this.getDeltaMovement()), (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(0.2), entity -> !entity.isSpectator() && entity.isAlive())) != null) {
                this.onHitEntity(entityHitResult);
            }
        }
        Vec3 motion = this.getDeltaMovement();
        this.setPos(this.getX() + motion.x, this.getY() + motion.y, this.getZ() + motion.z);
        this.updateHitbox();
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        if (this.level().isClientSide) {
            return;
        }
        if (!this.canPierceBlocks()) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setPos(hitResult.getBlockPos().getX(), hitResult.getBlockPos().getY(), hitResult.getBlockPos().getZ());
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        if (this.level().isClientSide) {
            return;
        }
        Entity target = hitResult.getEntity();
        if (this.getOwner() != null && target.getUUID().equals(this.getOwner().getUUID())) {
            return;
        }
        if (!this.zapinatorType.equals((Object)ZapinatorType.NONE) && target.invulnerableTime == 0) {
            this.handleZapinatorChances(target);
        } else {
            target.hurt(this.damageSources().playerAttack((Player)this.getOwner()), this.baseDamage);
            target.invulnerableTime = 0;
        }
        if (this.canPierceEntities()) {
            ++this.piercedEntities;
        } else {
            this.discard();
        }
        if (this.maxPiercing != -1 && this.piercedEntities >= this.maxPiercing) {
            this.discard();
        }
    }

    protected void handleZapinatorChances(Entity target) {
        boolean customChance;
        boolean slowdown;
        if (this.level().isClientSide) {
            return;
        }
        RandomSource random = this.random;
        float damage = this.baseDamage;
        boolean disableBlockUp = random.nextFloat() < 0.05f;
        boolean disableBlockDown = random.nextFloat() < 0.05f;
        boolean disableBlock = random.nextFloat() < 0.5f;
        boolean backwards = random.nextFloat() < 0.67f;
        boolean shiftRight = random.nextFloat() < 0.145f;
        boolean shiftBottom = random.nextFloat() < 0.145f;
        boolean multiplyKnockback = random.nextFloat() < 0.05f;
        boolean multiplyDamage = random.nextFloat() < 0.02f;
        boolean teleportUp = random.nextFloat() < 0.145f;
        boolean teleportDown = random.nextFloat() < 0.145f;
        boolean mirrorVertical = random.nextFloat() < 0.07f;
        boolean mirrorHorizontal = random.nextFloat() < 0.07f;
        boolean bl = slowdown = random.nextFloat() < 0.1f;
        if (disableBlockUp) {
            this.blockPiercing = true;
            this.move(null, new Vec3(0.0, 8.0, 0.0));
        }
        if (disableBlockDown) {
            this.blockPiercing = true;
            this.move(null, new Vec3(0.0, -8.0, 0.0));
        }
        if (disableBlock) {
            this.blockPiercing = true;
        }
        if (backwards) {
            Utils.mirrorHorizontal((Entity)this);
            Utils.mirrorVertical((Entity)this);
            Vec3 motion = this.getDeltaMovement();
            int moveAmount = random.nextInt(1, 20);
            this.move(null, new Vec3(motion.x * (double)moveAmount, motion.y * (double)moveAmount, motion.z * (double)moveAmount));
        }
        if (shiftRight) {
            Utils.rotateMotionXZ((Entity)this, 30.0f);
        }
        if (shiftBottom) {
            Utils.rotateMotionY((Entity)this, 30.0f);
        }
        if (teleportUp) {
            this.move(null, new Vec3(0.0, (double)random.nextInt(1, 5), 0.0));
        }
        if (teleportDown) {
            this.move(null, new Vec3(0.0, (double)(-random.nextInt(1, 5)), 0.0));
        }
        if (mirrorVertical) {
            Utils.mirrorVertical((Entity)this);
        }
        if (mirrorHorizontal) {
            Utils.mirrorHorizontal((Entity)this);
        }
        if (!this.zapinatorSlowedDown) {
            Utils.slowdownEntity((Entity)this, 40.0f);
            this.baseDamage *= 0.9f;
            this.baseKnockback *= 0.9f;
            this.zapinatorSlowedDown = true;
        }
        if (multiplyKnockback) {
            this.baseKnockback *= 10.0f;
        }
        if (multiplyDamage) {
            damage *= 10.0f;
        }
        if (slowdown) {
            float slowAmount = random.nextFloat() * 10.0f - 0.05f;
            Utils.slowdownEntity((Entity)this, slowAmount);
        }
        boolean bl2 = customChance = random.nextFloat() < 0.5f;
        if (customChance && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            switch (this.zapinatorType) {
                case RED: {
                    livingTarget.setRemainingFireTicks(livingTarget.getRemainingFireTicks() + random.nextInt(5, 201));
                    break;
                }
                case GREEN: {
                    livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, random.nextInt(20, 201), 1));
                    break;
                }
                case BLUE: {
                    livingTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, random.nextInt(20, 201), 1));
                    break;
                }
                case PURPLE: {
                    Utils.applyKnockback(livingTarget, (Entity)this, this.baseKnockback * 10.0f);
                }
            }
        }
        target.hurt(this.damageSources().playerAttack((Player)this.getOwner()), damage);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            Utils.applyKnockback(livingTarget, (Entity)this, this.baseKnockback);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)0xFFFFFF);
        builder.define(SIZE, (Object)new Vector3f(0.15f, 0.15f, 1.6f));
        builder.build();
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void setBaseDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public void setSize(Vector3f size) {
        this.entityData.set(SIZE, (Object)size);
    }

    public Vector3f getSize() {
        return (Vector3f)this.entityData.get(SIZE);
    }

    public void setBlockPiercing(boolean status) {
        this.blockPiercing = status;
        this.noPhysics = status;
    }

    public boolean canPierceBlocks() {
        return this.blockPiercing;
    }

    public void setEntityPiercing(boolean status) {
        this.entityPiercing = status;
    }

    public boolean canPierceEntities() {
        return this.entityPiercing;
    }

    public void setMaxPiercing(int maxPiercing) {
        this.maxPiercing = maxPiercing;
    }

    public int getMaxPiercing() {
        return this.maxPiercing;
    }

    public ZapinatorType getZapinatorType() {
        return this.zapinatorType;
    }

    public void setZapinatorType(ZapinatorType zapinatorType) {
        this.zapinatorType = zapinatorType;
    }
}

