/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.registry;

import com.namefix.registry.ItemRegistry;
import com.namefix.registry.TabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"zapinators", (ResourceKey)Registries.BLOCK);
    public static Tuple<RegistrySupplier<Block>, RegistrySupplier<BlockItem>> METEORITE_ORE = BlockRegistry.registerBlockWithItem("meteorite_ore", (BlockBehaviour.Properties properties) -> new Block(properties.mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f)));
    public static Tuple<RegistrySupplier<Block>, RegistrySupplier<BlockItem>> RAW_METEORITE_BLOCK = BlockRegistry.registerBlockWithItem("raw_meteorite_block", (BlockBehaviour.Properties properties) -> new Block(properties.mapColor(MapColor.RAW_IRON).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static Tuple<RegistrySupplier<Block>, RegistrySupplier<BlockItem>> METEORITE_BLOCK = BlockRegistry.registerBlockWithItem("meteorite_block", (BlockBehaviour.Properties properties) -> new Block(properties.mapColor(MapColor.METAL).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL)));

    public static void register() {
        BLOCKS.register();
    }

    public static RegistrySupplier<Block> registerBlock(String name, BlockBehaviour.Properties base) {
        return BlockRegistry.registerBlock(name, Block::new, base);
    }

    public static RegistrySupplier<Block> registerBlock(String name) {
        return BlockRegistry.registerBlock(name, Block::new);
    }

    public static <T extends Block> RegistrySupplier<T> registerBlock(String name, BlockFactory<T> factory) {
        return BlockRegistry.registerBlock(name, factory, BlockBehaviour.Properties.of());
    }

    public static <T extends Block> RegistrySupplier<T> registerBlock(String name, BlockFactory<T> factory, BlockBehaviour.Properties base) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)name));
        return BLOCKS.register(name, () -> factory.create(base));
    }

    public static Tuple<RegistrySupplier<Block>, RegistrySupplier<BlockItem>> registerBlockWithItem(String name) {
        return BlockRegistry.registerBlockWithItem(name, BlockBehaviour.Properties.of());
    }

    public static Tuple<RegistrySupplier<Block>, RegistrySupplier<BlockItem>> registerBlockWithItem(String name, BlockBehaviour.Properties base) {
        return BlockRegistry.registerBlockWithItem(name, Block::new, base);
    }

    public static <T extends Block> Tuple<RegistrySupplier<T>, RegistrySupplier<BlockItem>> registerBlockWithItem(String name, BlockFactory<T> factory) {
        return BlockRegistry.registerBlockWithItem(name, factory, BlockBehaviour.Properties.of());
    }

    public static <T extends Block> Tuple<RegistrySupplier<T>, RegistrySupplier<BlockItem>> registerBlockWithItem(String name, BlockFactory<T> factory, BlockBehaviour.Properties base) {
        return BlockRegistry.registerBlockWithItem(name, factory, base, (settings, block) -> new BlockItem((Block)block.get(), settings));
    }

    public static <T extends Block, U extends BlockItem> Tuple<RegistrySupplier<T>, RegistrySupplier<U>> registerBlockWithItem(String name, BlockFactory<T> blockFactory, BlockItemFactory<T, U> itemFactory) {
        return BlockRegistry.registerBlockWithItem(name, blockFactory, BlockBehaviour.Properties.of(), itemFactory);
    }

    public static <T extends Block, U extends BlockItem> Tuple<RegistrySupplier<T>, RegistrySupplier<U>> registerBlockWithItem(String name, BlockFactory<T> blockFactory, BlockBehaviour.Properties base, BlockItemFactory<T, U> itemFactory) {
        RegistrySupplier block = BlockRegistry.registerBlock(name, blockFactory, base);
        return new Tuple(block, ItemRegistry.registerItem(name, settings -> itemFactory.create(settings.arch$tab(TabRegistry.ZAPINATORS_TAB), block)));
    }

    @FunctionalInterface
    public static interface BlockFactory<T extends Block> {
        public T create(BlockBehaviour.Properties var1);
    }

    @FunctionalInterface
    public static interface BlockItemFactory<T extends Block, U extends BlockItem> {
        public U create(Item.Properties var1, RegistrySupplier<T> var2);
    }
}

