/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.registry;

import com.namefix.enums.ZapinatorType;
import com.namefix.item.ColorZapinatorItem;
import com.namefix.item.CoreItem;
import com.namefix.item.LaserRifleItem;
import com.namefix.item.MeteoriteArmorItem;
import com.namefix.item.ModArmorMaterials;
import com.namefix.item.SpaceGunItem;
import com.namefix.item.ZapinatorItem;
import com.namefix.registry.TabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SmithingTemplateItem;

public class ItemRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"zapinators", (ResourceKey)Registries.ITEM);
    public static final RegistrySupplier<Item> SPACE_GUN = ItemRegistry.registerItem("space_gun", properties -> new SpaceGunItem(properties.stacksTo(1).arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> LASER_RIFLE = ItemRegistry.registerItem("laser_rifle", properties -> new LaserRifleItem(properties.stacksTo(1).arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> ZAPINATOR = ItemRegistry.registerItem("zapinator", properties -> new ZapinatorItem(properties.stacksTo(1).arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> GRAY_ZAPINATOR = ItemRegistry.registerItem("gray_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1).arch$tab(TabRegistry.ZAPINATORS_TAB), ZapinatorType.GRAY, 2.5f));
    public static final RegistrySupplier<Item> ORANGE_ZAPINATOR = ItemRegistry.registerItem("orange_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1).arch$tab(TabRegistry.ZAPINATORS_TAB), ZapinatorType.ORANGE, 5.0f));
    public static final RegistrySupplier<Item> RED_ZAPINATOR = ItemRegistry.registerItem("red_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1).arch$tab(TabRegistry.ZAPINATORS_TAB), ZapinatorType.RED, 2.5f));
    public static final RegistrySupplier<Item> GREEN_ZAPINATOR = ItemRegistry.registerItem("green_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1).arch$tab(TabRegistry.ZAPINATORS_TAB), ZapinatorType.GREEN, 3.0f));
    public static final RegistrySupplier<Item> BLUE_ZAPINATOR = ItemRegistry.registerItem("blue_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1).arch$tab(TabRegistry.ZAPINATORS_TAB), ZapinatorType.BLUE, 4.0f));
    public static final RegistrySupplier<Item> PURPLE_ZAPINATOR = ItemRegistry.registerItem("purple_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1).arch$tab(TabRegistry.ZAPINATORS_TAB), ZapinatorType.PURPLE, 4.5f));
    public static final RegistrySupplier<Item> BLACK_ZAPINATOR = ItemRegistry.registerItem("black_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1).arch$tab(TabRegistry.ZAPINATORS_TAB).rarity(Rarity.EPIC), ZapinatorType.BLACK, 999.0f));
    public static final RegistrySupplier<Item> GRAY_CORE = ItemRegistry.registerItem("gray_core", properties -> new CoreItem(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> ORANGE_CORE = ItemRegistry.registerItem("orange_core", properties -> new CoreItem(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> RED_CORE = ItemRegistry.registerItem("red_core", properties -> new CoreItem(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> GREEN_CORE = ItemRegistry.registerItem("green_core", properties -> new CoreItem(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> BLUE_CORE = ItemRegistry.registerItem("blue_core", properties -> new CoreItem(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> PURPLE_CORE = ItemRegistry.registerItem("purple_core", properties -> new CoreItem(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> BLACK_CORE = ItemRegistry.registerItem("black_core", properties -> new CoreItem(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> RAW_METEORITE = ItemRegistry.registerItem("raw_meteorite", properties -> new Item(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> METEORITE_INGOT = ItemRegistry.registerItem("meteorite_ingot", properties -> new Item(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> METEORITE_NUGGET = ItemRegistry.registerItem("meteorite_nugget", properties -> new Item(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> ZAPINATOR_RESET_SMITHING_TEMPLATE = ItemRegistry.registerItem("zapinator_reset_smithing_template", properties -> new SmithingTemplateItem((Component)Component.translatable((String)"item.zapinators.smithing_template.zapinator_reset.applies_to").withStyle(ChatFormatting.BLUE), (Component)Component.translatable((String)"item.zapinators.smithing_template.zapinator_reset.ingredients").withStyle(ChatFormatting.BLUE), (Component)Component.translatable((String)"upgrade.zapinators.zapinator_reset").withStyle(ChatFormatting.GRAY), (Component)Component.translatable((String)"item.zapinators.smithing_template.zapinator_reset.base_slot_description"), (Component)Component.translatable((String)"item.zapinators.smithing_template.zapinator_reset.additions_slot_description"), null, null, new FeatureFlag[0]));
    public static final RegistrySupplier<Item> ENERGY_CELL = ItemRegistry.registerItem("energy_cell", properties -> new Item(properties.arch$tab(TabRegistry.ZAPINATORS_TAB)));
    public static final RegistrySupplier<Item> METEORITE_HELMET = ItemRegistry.registerItem("meteorite_helmet", properties -> new MeteoriteArmorItem(ModArmorMaterials.METEORITE_ARMOR, ArmorItem.Type.HELMET, properties.arch$tab(TabRegistry.ZAPINATORS_TAB).durability(ArmorItem.Type.HELMET.getDurability(15)), 25));
    public static final RegistrySupplier<Item> METEORITE_CHESTPLATE = ItemRegistry.registerItem("meteorite_chestplate", properties -> new MeteoriteArmorItem(ModArmorMaterials.METEORITE_ARMOR, ArmorItem.Type.CHESTPLATE, properties.arch$tab(TabRegistry.ZAPINATORS_TAB).durability(ArmorItem.Type.CHESTPLATE.getDurability(15)), 25));
    public static final RegistrySupplier<Item> METEORITE_LEGGINGS = ItemRegistry.registerItem("meteorite_leggings", properties -> new MeteoriteArmorItem(ModArmorMaterials.METEORITE_ARMOR, ArmorItem.Type.LEGGINGS, properties.arch$tab(TabRegistry.ZAPINATORS_TAB).durability(ArmorItem.Type.LEGGINGS.getDurability(15)), 25));
    public static final RegistrySupplier<Item> METEORITE_BOOTS = ItemRegistry.registerItem("meteorite_boots", properties -> new MeteoriteArmorItem(ModArmorMaterials.METEORITE_ARMOR, ArmorItem.Type.BOOTS, properties.arch$tab(TabRegistry.ZAPINATORS_TAB).durability(ArmorItem.Type.BOOTS.getDurability(15)), 25));

    public static void register() {
        ITEMS.register();
    }

    public static RegistrySupplier<Item> registerItem(String name) {
        return ItemRegistry.registerItem(name, Item::new);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String name, ItemFactory<T> factory) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)name));
        return ITEMS.register(name, () -> factory.create(new Item.Properties()));
    }

    @FunctionalInterface
    public static interface ItemFactory<T extends Item> {
        public T create(Item.Properties var1);
    }
}

