/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.utils;

import com.namefix.enums.ZapinatorType;
import com.namefix.item.MeteoriteArmorItem;
import com.namefix.registry.ItemRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class Utils {
    public static void rotateMotionXZ(Entity projectile, float degrees) {
        Vec3 motion = projectile.getDeltaMovement();
        float angle = (float)Math.toRadians(degrees);
        double x = motion.x * Math.cos(angle) - motion.z * Math.sin(angle);
        double z = motion.x * Math.sin(angle) + motion.z * Math.cos(angle);
        projectile.setDeltaMovement(x, motion.y, z);
    }

    public static void rotateMotionY(Entity ent, float degrees) {
        Vec3 motion = ent.getDeltaMovement();
        float angle = (float)Math.toRadians(degrees);
        double y = motion.y * Math.cos(angle) - motion.z * Math.sin(angle);
        double z = motion.y * Math.sin(angle) + motion.z * Math.cos(angle);
        ent.setDeltaMovement(motion.x, y, z);
    }

    public static void mirrorVertical(Entity ent) {
        Vec3 motion = ent.getDeltaMovement();
        ent.setDeltaMovement(motion.x, -motion.y, motion.z);
    }

    public static void mirrorHorizontal(Entity ent) {
        Vec3 motion = ent.getDeltaMovement();
        ent.setDeltaMovement(-motion.x, motion.y, -motion.z);
    }

    public static void slowdownEntity(Entity ent, float percentage) {
        float reduction = 1.0f - percentage / 100.0f;
        Vec3 motion = ent.getDeltaMovement();
        ent.setDeltaMovement(motion.x * (double)reduction, motion.y * (double)reduction, motion.z * (double)reduction);
    }

    public static void applyKnockback(LivingEntity target, Entity projectile, double knockbackPower) {
        Player pl;
        if (target instanceof Player && (pl = (Player)target).isCreative()) {
            return;
        }
        target.knockback(knockbackPower, projectile.getX() - target.getX(), projectile.getZ() - target.getZ());
        target.hurtMarked = true;
    }

    public static void removeOneItem(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack slotStack = player.getInventory().getItem(i);
            if (slotStack.isEmpty() || slotStack.getItem() != item) continue;
            slotStack.shrink(1);
            if (!slotStack.isEmpty()) break;
            player.getInventory().setItem(i, ItemStack.EMPTY);
            break;
        }
    }

    public static int getPlayerAmmoSaveChance(Player player) {
        AtomicInteger total = new AtomicInteger();
        Iterable playerArmor = player.getArmorSlots();
        playerArmor.forEach(piece -> {
            Item patt0$temp = piece.getItem();
            if (patt0$temp instanceof MeteoriteArmorItem) {
                MeteoriteArmorItem armor = (MeteoriteArmorItem)patt0$temp;
                total.addAndGet(armor.getSavePercent());
            }
        });
        return total.get();
    }

    public static Item getZapinatorFromEnum(ZapinatorType type) {
        return (Item)ItemRegistry.ITEMS.getRegistrar().get(ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)(type.toString().toLowerCase() + "_zapinator")));
    }

    public static Item getCoreFromEnum(ZapinatorType type) {
        return (Item)ItemRegistry.ITEMS.getRegistrar().get(ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)(type.toString().toLowerCase() + "_core")));
    }
}

