/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.namefix.config.ZapinatorsConfig;
import com.namefix.enums.ZapinatorType;
import com.namefix.mixin.EntityInvoker;
import com.namefix.utils.Utils;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.joml.Vector3f;

public class LaserProjectile
extends class_1668 {
    private static final class_2940<Integer> COLOR = class_2945.method_12791(LaserProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Vector3f> SIZE = class_2945.method_12791(LaserProjectile.class, (class_2941)class_2943.field_42237);
    private float baseDamage = 1.0f;
    private float baseKnockback = 0.5f;
    private boolean blockPiercing = false;
    private boolean entityPiercing = false;
    private int piercedEntities = 0;
    private int maxPiercing = 3;
    private ZapinatorType zapinatorType = ZapinatorType.NONE;
    private boolean zapinatorSlowedDown = false;

    public LaserProjectile(class_1299<? extends LaserProjectile> entityType, class_1937 level) {
        super(entityType, level);
    }

    public void method_5773() {
        this.field_5960 = true;
        if (Utils.shouldProjectileForceRemove((class_1676)this)) {
            this.method_31472();
            return;
        }
        if (this.method_5809()) {
            this.method_46395();
        }
        class_243 motion = this.method_18798();
        if (!this.blockPiercing && this.checkCustomBlockCollision(motion)) {
            this.method_31472();
            return;
        }
        this.updateCollisionStates(motion, ((EntityInvoker)((Object)this)).zapinators$invokeCollide(motion));
        this.method_5784(class_1313.field_6308, motion);
        if (!this.method_37908().field_9236) {
            List collidingEntities = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(0.2), e -> e != this && e != this.method_24921() && e.method_5805());
            for (class_1297 entity : collidingEntities) {
                class_1297 owner;
                class_1309 living;
                if (!(entity instanceof class_1309) || (living = (class_1309)entity).method_5679(this.method_48923().method_48812(living)) || (owner = this.method_24921()) != null && !Utils.canEntityDamageEntity(Objects.requireNonNull(this.method_24921()), entity)) continue;
                if (!this.zapinatorType.equals((Object)ZapinatorType.NONE) && entity.field_6008 == 0) {
                    this.handleZapinatorEntityCollision(entity);
                } else {
                    if (owner != null) {
                        entity.method_5643(this.method_48923().method_48802((class_1657)this.method_24921()), this.baseDamage);
                    } else {
                        entity.method_5643(this.method_48923().method_48831(), this.baseDamage);
                    }
                    entity.field_6008 = 0;
                }
                if (this.canPierceEntities()) {
                    ++this.piercedEntities;
                } else {
                    this.method_31472();
                }
                if (this.maxPiercing != -1 && this.piercedEntities >= this.maxPiercing) {
                    this.method_31472();
                }
                return;
            }
        }
    }

    private boolean checkCustomBlockCollision(class_243 motion) {
        class_243 up;
        if (motion.method_1027() < 0.001) {
            return false;
        }
        Vector3f size = this.getSize();
        class_243 start = this.method_19538();
        int samples = 2;
        class_243 forward = motion.method_1029();
        class_243 right = forward.method_1036(up = new class_243(0.0, 1.0, 0.0));
        if (right.method_1027() < 1.0E-6) {
            up = new class_243(1.0, 0.0, 0.0);
            right = forward.method_1036(up);
        }
        right = right.method_1029();
        up = right.method_1036(forward);
        float widthStep = size.x / (float)(samples + 1);
        float heightStep = size.y / (float)(samples + 1);
        float collisionLength = (float)Math.min((double)(size.z * 0.3f), motion.method_1033() + (double)0.1f);
        for (int i = 0; i < samples; ++i) {
            for (int j = 0; j < samples; ++j) {
                class_243 sampleStart;
                float widthOffset = ((float)i - (float)(samples - 1) * 0.5f) * widthStep;
                float heightOffset = ((float)j - (float)(samples - 1) * 0.5f) * heightStep;
                class_243 offset = right.method_1021((double)widthOffset).method_1019(up.method_1021((double)heightOffset));
                class_243 checkStart = sampleStart = start.method_1019(offset);
                class_243 checkEnd = sampleStart.method_1019(forward.method_1021((double)collisionLength));
                class_3959 clipContext = new class_3959(checkStart, checkEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this);
                class_3965 hitResult = this.method_37908().method_17742(clipContext);
                if (hitResult.method_17783() != class_239.class_240.field_1332) continue;
                this.method_33574(hitResult.method_17784());
                return true;
            }
        }
        return false;
    }

    protected void handleZapinatorEntityCollision(class_1297 target) {
        boolean customChance;
        boolean slowdown;
        if (this.method_37908().field_9236) {
            return;
        }
        class_5819 random = this.field_5974;
        float damage = this.baseDamage;
        boolean disableBlockUp = random.method_43057() < 0.05f;
        boolean disableBlockDown = random.method_43057() < 0.05f;
        boolean disableBlock = random.method_43057() < 0.5f;
        boolean backwards = random.method_43057() < 0.67f;
        boolean shiftRight = random.method_43057() < 0.145f;
        boolean shiftBottom = random.method_43057() < 0.145f;
        boolean multiplyKnockback = random.method_43057() < 0.05f;
        boolean multiplyDamage = random.method_43057() < 0.02f;
        boolean teleportUp = random.method_43057() < 0.145f;
        boolean teleportDown = random.method_43057() < 0.145f;
        boolean mirrorVertical = random.method_43057() < 0.07f;
        boolean mirrorHorizontal = random.method_43057() < 0.07f;
        boolean bl = slowdown = random.method_43057() < 0.1f;
        if (disableBlockUp) {
            this.blockPiercing = true;
            this.method_5784(null, new class_243(0.0, 8.0, 0.0));
        }
        if (disableBlockDown) {
            this.blockPiercing = true;
            this.method_5784(null, new class_243(0.0, -8.0, 0.0));
        }
        if (disableBlock) {
            this.blockPiercing = true;
        }
        if (backwards) {
            Utils.mirrorHorizontal((class_1297)this);
            Utils.mirrorVertical((class_1297)this);
            class_243 motion = this.method_18798();
            int moveAmount = random.method_43051(1, 20);
            this.method_5784(null, new class_243(motion.field_1352 * (double)moveAmount, motion.field_1351 * (double)moveAmount, motion.field_1350 * (double)moveAmount));
        }
        if (shiftRight) {
            Utils.rotateMotionXZ((class_1297)this, 30.0f);
        }
        if (shiftBottom) {
            Utils.rotateMotionY((class_1297)this, 30.0f);
        }
        if (teleportUp) {
            this.method_5784(null, new class_243(0.0, (double)random.method_43051(1, 5), 0.0));
        }
        if (teleportDown) {
            this.method_5784(null, new class_243(0.0, (double)(-random.method_43051(1, 5)), 0.0));
        }
        if (mirrorVertical) {
            Utils.mirrorVertical((class_1297)this);
        }
        if (mirrorHorizontal) {
            Utils.mirrorHorizontal((class_1297)this);
        }
        if (!this.zapinatorSlowedDown) {
            Utils.slowdownEntity((class_1297)this, 40.0f);
            this.baseDamage *= 0.9f;
            this.baseKnockback *= 0.9f;
            this.zapinatorSlowedDown = true;
        }
        if (multiplyKnockback) {
            this.baseKnockback *= 10.0f;
        }
        if (multiplyDamage) {
            damage *= 10.0f;
        }
        if (slowdown) {
            float slowAmount = random.method_43057() * 10.0f - 0.05f;
            Utils.slowdownEntity((class_1297)this, slowAmount);
        }
        boolean bl2 = customChance = random.method_43057() < 0.5f;
        if (customChance && target instanceof class_1309) {
            class_1309 livingTarget = (class_1309)target;
            switch (this.zapinatorType) {
                case RED: {
                    livingTarget.method_20803(livingTarget.method_20802() + random.method_43051(5, 201));
                    break;
                }
                case GREEN: {
                    livingTarget.method_6092(new class_1293(class_1294.field_5899, random.method_43051(20, 201), 1));
                    break;
                }
                case BLUE: {
                    livingTarget.method_6092(new class_1293(class_1294.field_5909, random.method_43051(20, 201), 1));
                    break;
                }
                case PURPLE: {
                    Utils.applyKnockback(livingTarget, (class_1297)this, this.baseKnockback * 10.0f);
                    break;
                }
                case YELLOW: {
                    Utils.spawnLightning(livingTarget.method_19538(), livingTarget.method_37908());
                    break;
                }
                case WHITE: {
                    livingTarget.method_6092(new class_1293(class_1294.field_5902, random.method_43051(20, 70)));
                }
            }
        }
        if (this.method_24921() != null) {
            target.method_5643(this.method_48923().method_48802((class_1657)this.method_24921()), damage * ZapinatorsConfig.Server.zapinatorDamageMultiplier);
        } else {
            target.method_5643(this.method_48923().method_48831(), damage * ZapinatorsConfig.Server.zapinatorDamageMultiplier);
        }
        if (target instanceof class_1309) {
            class_1309 livingTarget = (class_1309)target;
            Utils.applyKnockback(livingTarget, (class_1297)this, this.baseKnockback);
        }
    }

    protected void updateCollisionStates(class_243 vec3, class_243 vec32) {
        boolean horizontalDiffX = !class_3532.method_20390((double)vec3.field_1352, (double)vec32.field_1352);
        boolean horizontalDiffZ = !class_3532.method_20390((double)vec3.field_1350, (double)vec32.field_1350);
        boolean bl = this.field_5976 = horizontalDiffX || horizontalDiffZ;
        if (Math.abs(vec3.field_1351) > 0.0 || this.method_5787()) {
            this.field_5992 = vec3.field_1351 != vec32.field_1351;
            this.field_36331 = this.field_5992 && vec3.field_1351 < 0.0;
            this.method_60607(this.field_36331, vec32);
        }
    }

    public boolean method_31746() {
        return false;
    }

    public void method_5982() {
        if (Utils.shouldProjectileForceRemove((class_1676)this)) {
            this.method_31472();
            return;
        }
        super.method_5982();
    }

    protected boolean method_7468() {
        return false;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, (Object)0xFFFFFF);
        builder.method_56912(SIZE, (Object)new Vector3f(0.15f, 0.15f, 1.6f));
        builder.method_56911();
    }

    public void setColor(int color) {
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    public void setBaseDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public void setSize(Vector3f size) {
        this.field_6011.method_12778(SIZE, (Object)size);
    }

    public Vector3f getSize() {
        return (Vector3f)this.field_6011.method_12789(SIZE);
    }

    public void setBlockPiercing(boolean status) {
        this.blockPiercing = status;
        this.field_5960 = status;
    }

    public boolean canPierceBlocks() {
        return this.blockPiercing;
    }

    public void setEntityPiercing(boolean status) {
        this.entityPiercing = status;
    }

    public boolean canPierceEntities() {
        return this.entityPiercing;
    }

    public void setMaxPiercing(int maxPiercing) {
        this.maxPiercing = maxPiercing;
    }

    public int getMaxPiercing() {
        return this.maxPiercing;
    }

    public ZapinatorType getZapinatorType() {
        return this.zapinatorType;
    }

    public void setZapinatorType(ZapinatorType zapinatorType) {
        this.zapinatorType = zapinatorType;
    }
}

