/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.item;

import com.namefix.entity.Orb;
import com.namefix.item.AbstractManaItem;
import com.namefix.registry.EntityRegistry;
import com.namefix.registry.SoundRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractOrbShooterItem
extends AbstractManaItem {
    float baseDamage;
    int itemCooldown;
    int color;
    float orbSpeed = 0.5f;
    boolean gravity = false;
    int orbDespawnTick = 200;
    int piercingAmount = 0;
    boolean fireChance = false;
    class_3414 shootSound;

    public AbstractOrbShooterItem(class_1792.class_1793 properties, float manaCost, float baseDamage, int itemCooldown, int color) {
        super(properties);
        this.manaCost = manaCost;
        this.baseDamage = baseDamage;
        this.itemCooldown = itemCooldown;
        this.color = color;
        this.shootSound = this.getShootSound();
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        if (!this.canPlayerUseManaItem(level, player)) {
            return class_1271.method_22431((Object)player.method_5998(interactionHand));
        }
        if (!level.field_9236) {
            class_243 lookVec = player.method_5720();
            class_243 offsetVec = interactionHand == class_1268.field_5808 ? lookVec.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029() : lookVec.method_1036(new class_243(0.0, -1.0, 0.0)).method_1029();
            double offsetAmount = 0.2;
            Orb orb = new Orb((class_1299<? extends class_1668>)((class_1299)EntityRegistry.ORB.get()), level);
            orb.method_5814(player.method_23317() + offsetVec.field_1352 * offsetAmount, player.method_23320() - 0.1 + offsetVec.field_1351 * offsetAmount, player.method_23321() + offsetVec.field_1350 * offsetAmount);
            double trajectoryCorrection = 0.07;
            class_243 adjustedLookVec = lookVec.method_1019(offsetVec.method_1021(-trajectoryCorrection * offsetAmount));
            orb.method_18800(adjustedLookVec.field_1352 * (double)this.orbSpeed, adjustedLookVec.field_1351 * (double)this.orbSpeed, adjustedLookVec.field_1350 * (double)this.orbSpeed);
            orb.setOrbSpeed(this.orbSpeed);
            orb.setColor(this.color);
            orb.method_7432((class_1297)player);
            orb.method_36457(player.method_36455());
            orb.method_36456(player.method_36454());
            orb.setHasGravity(this.gravity);
            orb.setBaseDamage(this.baseDamage * this.getDamageModifier());
            orb.setDespawnTicks(this.orbDespawnTick);
            orb.setPiercingLeft(this.piercingAmount);
            orb.setFireChance(this.fireChance);
            level.method_8649((class_1297)orb);
        }
        this.useManaItem(level, player, this.meteoriteArmorSavesMana);
        player.method_7357().method_7906(player.method_5998(interactionHand).method_7909(), this.itemCooldown);
        if (this.shootSound != null) {
            player.method_37908().method_54762(null, player.method_23317(), player.method_23318(), player.method_23321(), this.shootSound, class_3419.field_15248);
        }
        player.method_6104(interactionHand);
        return class_1271.method_22430((Object)player.method_5998(interactionHand));
    }

    public float getDamageModifier() {
        return 1.0f;
    }

    protected class_3414 getShootSound() {
        return (class_3414)SoundRegistry.GEM_STAFF_SHOOT.getOrNull();
    }
}

