/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.server;

import com.namefix.config.ZapinatorsConfig;
import com.namefix.data.PlayerData;
import com.namefix.data.StateSaver;
import com.namefix.entity.AngryBee;
import com.namefix.entity.FallenStar;
import com.namefix.item.BeeArmorItem;
import com.namefix.item.BeeGunItem;
import com.namefix.network.payload.InitialSyncPayload;
import com.namefix.network.payload.ManaStatusPayload;
import com.namefix.registry.AttributeRegistry;
import com.namefix.registry.EntityRegistry;
import com.namefix.utils.Utils;
import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_8710;

public class ZapinatorsServer {
    static int baseFallingStarDropRate = 10000;

    public static void onPlayerRespawn(class_3222 player, boolean b, class_1297.class_5529 removalReason) {
        if (removalReason == class_1297.class_5529.field_26998) {
            float maxMana;
            PlayerData data = StateSaver.getPlayerState((class_1309)player);
            data.mana = maxMana = (float)player.method_45325(AttributeRegistry.getHolder(AttributeRegistry.MAX_MANA));
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new ManaStatusPayload(data.mana, data.manaRegenCooldown));
        }
    }

    public static void sendInitialSync(class_3222 player) {
        PlayerData data = StateSaver.getPlayerState((class_1309)player);
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new InitialSyncPayload(data.mana, data.manaRegenCooldown));
    }

    public static void tick(class_3218 serverLevel) {
        serverLevel.method_18456().forEach(player -> {
            if (player.method_29504()) {
                return;
            }
            PlayerData data = ZapinatorsServer.getPlayerData(player);
            float maxMana = (float)player.method_45325(AttributeRegistry.getHolder(AttributeRegistry.MAX_MANA));
            float manaRegen = (float)player.method_45325(AttributeRegistry.getHolder(AttributeRegistry.MANA_REGENERATION));
            if (data.manaRegenCooldown > 0) {
                --data.manaRegenCooldown;
            } else {
                data.mana = (float)class_3532.method_15350((double)(data.mana + manaRegen), (double)0.0, (double)maxMana);
            }
        });
        class_3218 overworld = serverLevel.method_8503().method_3847(class_3218.field_25179);
        if (overworld == null) {
            return;
        }
        float dropMultiplier = 1.0f / ZapinatorsConfig.Server.fallenStarDropRateMultiplier;
        int moonDropMultiplier = ZapinatorsConfig.Server.fallenStarMoonPhase ? (int)((double)baseFallingStarDropRate / Utils.getMoonMultiplier((class_1937)serverLevel)) : baseFallingStarDropRate;
        int dropRate = (int)((float)moonDropMultiplier * dropMultiplier);
        if (dropMultiplier > 0.0f && overworld.method_23886()) {
            for (class_3222 player2 : overworld.method_18456()) {
                if (overworld.field_9229.method_39332(0, dropRate) != 0) continue;
                ZapinatorsServer.spawnFallenStar((class_1657)player2);
            }
        }
    }

    public static void spawnFallenStar(class_1657 player) {
        boolean safe;
        class_5819 random = player.method_37908().field_9229;
        double maxDistance = 80.0;
        double offsetX = (random.method_43058() * 2.0 - 1.0) * maxDistance;
        double offsetZ = (random.method_43058() * 2.0 - 1.0) * maxDistance;
        double spawnX = player.method_23317() + offsetX;
        double spawnZ = player.method_23321() + offsetZ;
        boolean bl = safe = player.method_19538().field_1351 + 100.0 > (double)player.method_37908().method_8624(class_2902.class_2903.field_13197, (int)spawnX, (int)spawnZ);
        if (!safe) {
            return;
        }
        int spawnY = (int)player.method_19538().field_1351 + 100;
        FallenStar star = new FallenStar((class_1299<? extends FallenStar>)((class_1299)EntityRegistry.FALLEN_STAR.getOrNull()), player.method_37908());
        star.method_5814(spawnX, spawnY, spawnZ);
        double targetOffsetX = (random.method_43058() * 2.0 - 1.0) * 15.0;
        double targetOffsetZ = (random.method_43058() * 2.0 - 1.0) * 15.0;
        double targetX = player.method_23317() + targetOffsetX;
        double targetZ = player.method_23321() + targetOffsetZ;
        double targetY = player.method_23318();
        double dx = targetX - spawnX;
        double dy = targetY - (double)spawnY;
        double dz = targetZ - spawnZ;
        if (dy > 0.0) {
            dy = -Math.abs(dy);
        }
        double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double speed = 0.5;
        if (length != 0.0) {
            dx = dx / length * speed;
            dy = dy / length * speed;
            dz = dz / length * speed;
        }
        star.method_18800(dx, dy, dz);
        star.method_5702(class_2183.class_2184.field_9851, new class_243(targetX, targetY, targetZ));
        player.method_37908().method_8649((class_1297)star);
    }

    public static EventResult onPlayerDamage(class_1309 livingEntity, class_1282 damageSource, float v) {
        if (!(livingEntity instanceof class_3222)) {
            return EventResult.pass();
        }
        class_3222 player = (class_3222)livingEntity;
        if (v <= 0.0f || player.method_7337() || player.field_6008 > 0 || player.method_5679(damageSource)) {
            return EventResult.pass();
        }
        if (Utils.getPlayerArmorFullSet((class_1657)player, BeeArmorItem.class)) {
            class_1937 level = player.method_37908();
            int initialBeeAmount = level.method_8409().method_43051(1, 3);
            for (int i = 0; i < initialBeeAmount; ++i) {
                double speed = BeeGunItem.BEE_SPEED;
                double offsetX = (level.method_8409().method_43058() - 0.5) * 0.4;
                double offsetY = (level.method_8409().method_43058() - 0.5) * 0.4;
                double offsetZ = (level.method_8409().method_43058() - 0.5) * 0.4;
                AngryBee bee = new AngryBee((class_1299<? extends class_1668>)((class_1299)EntityRegistry.ANGRY_BEE.get()), level);
                bee.beeSpeed = speed;
                bee.beeSource = AngryBee.BeeSource.BEE_ARMOR;
                bee.baseDamage *= (1.0f + 0.05f * (float)Utils.countPlayerArmorSet((class_1657)player, BeeArmorItem.class)) * ZapinatorsConfig.Server.beeDamageMultiplier;
                bee.method_5814(player.method_23317() + offsetX, player.method_23320() - 0.2 + offsetY, player.method_23321() + offsetZ);
                double dx = (level.method_8409().method_43058() - 0.5) * 2.0 * speed;
                double dy = (level.method_8409().method_43058() - 0.5) * 2.0 * speed;
                double dz = (level.method_8409().method_43058() - 0.5) * 2.0 * speed;
                bee.method_18800(dx, dy, dz);
                bee.method_7432((class_1297)player);
                bee.method_36457(level.method_8409().method_43057() * 360.0f);
                bee.method_36456(level.method_8409().method_43057() * 360.0f);
                level.method_8649((class_1297)bee);
            }
        }
        return EventResult.pass();
    }

    public static PlayerData getPlayerData(class_3222 player) {
        return StateSaver.getPlayerState((class_1309)player);
    }

    public static void decreaseMana(class_3222 player, float amount, boolean cooldown) {
        PlayerData data = ZapinatorsServer.getPlayerData(player);
        float maxMana = (float)player.method_45325(AttributeRegistry.getHolder(AttributeRegistry.MAX_MANA));
        data.mana = class_3532.method_15363((float)(data.mana - amount), (float)0.0f, (float)maxMana);
        if (cooldown) {
            data.manaRegenCooldown = 60;
        }
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new ManaStatusPayload(data.mana, data.manaRegenCooldown));
    }
}

