/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.utils;

import com.namefix.compat.OpacCompat;
import com.namefix.enums.ZapinatorType;
import com.namefix.item.AbstractManaItem;
import com.namefix.registry.ItemRegistry;
import dev.architectury.platform.Platform;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class Utils {
    public static void rotateMotionXZ(class_1297 projectile, float degrees) {
        class_243 motion = projectile.method_18798();
        float angle = (float)Math.toRadians(degrees);
        double x = motion.field_1352 * Math.cos(angle) - motion.field_1350 * Math.sin(angle);
        double z = motion.field_1352 * Math.sin(angle) + motion.field_1350 * Math.cos(angle);
        projectile.method_18800(x, motion.field_1351, z);
    }

    public static void rotateMotionY(class_1297 ent, float degrees) {
        class_243 motion = ent.method_18798();
        float angle = (float)Math.toRadians(degrees);
        double y = motion.field_1351 * Math.cos(angle) - motion.field_1350 * Math.sin(angle);
        double z = motion.field_1351 * Math.sin(angle) + motion.field_1350 * Math.cos(angle);
        ent.method_18800(motion.field_1352, y, z);
    }

    public static void mirrorVertical(class_1297 ent) {
        class_243 motion = ent.method_18798();
        ent.method_18800(motion.field_1352, -motion.field_1351, motion.field_1350);
    }

    public static void mirrorHorizontal(class_1297 ent) {
        class_243 motion = ent.method_18798();
        ent.method_18800(-motion.field_1352, motion.field_1351, -motion.field_1350);
    }

    public static void slowdownEntity(class_1297 ent, float percentage) {
        float reduction = 1.0f - percentage / 100.0f;
        class_243 motion = ent.method_18798();
        ent.method_18800(motion.field_1352 * (double)reduction, motion.field_1351 * (double)reduction, motion.field_1350 * (double)reduction);
    }

    public static void applyKnockback(class_1309 target, class_1297 projectile, double knockbackPower) {
        class_1657 pl;
        if (target instanceof class_1657 && (pl = (class_1657)target).method_7337()) {
            return;
        }
        target.method_6005(knockbackPower, projectile.method_23317() - target.method_23317(), projectile.method_23321() - target.method_23321());
        target.field_6037 = true;
    }

    public static void removeOneItem(class_1657 player, class_1792 item) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 slotStack = player.method_31548().method_5438(i);
            if (slotStack.method_7960() || slotStack.method_7909() != item) continue;
            slotStack.method_7934(1);
            if (!slotStack.method_7960()) break;
            player.method_31548().method_5447(i, class_1799.field_8037);
            break;
        }
    }

    public static boolean getPlayerArmorFullSet(class_1657 player, Class<? extends class_1738> armorClass) {
        AtomicBoolean fullset = new AtomicBoolean(true);
        Iterable playerArmor = player.method_5661();
        playerArmor.forEach(piece -> {
            if (!armorClass.isInstance(piece.method_7909())) {
                fullset.set(false);
            }
        });
        return fullset.get();
    }

    public static int countPlayerArmorSet(class_1657 player, Class<? extends class_1738> armorClass) {
        AtomicInteger pieceCount = new AtomicInteger(0);
        Iterable playerArmor = player.method_5661();
        playerArmor.forEach(piece -> {
            if (armorClass.isInstance(piece.method_7909())) {
                pieceCount.incrementAndGet();
            }
        });
        return pieceCount.get();
    }

    public static boolean doesPlayerHoldManaWeapon(class_1657 player) {
        if (player.method_6047().method_7909() instanceof AbstractManaItem || player.method_6079().method_7909() instanceof AbstractManaItem) {
            return true;
        }
        return player.method_6047().method_7909().equals(ItemRegistry.MANA_CRYSTAL.get()) || player.method_6079().method_7909().equals(ItemRegistry.MANA_CRYSTAL.get());
    }

    public static class_1792 getZapinatorFromEnum(ZapinatorType type) {
        return (class_1792)ItemRegistry.ITEMS.getRegistrar().get(class_2960.method_60655((String)"zapinators", (String)(type.toString().toLowerCase() + "_zapinator")));
    }

    public static class_1792 getCoreFromEnum(ZapinatorType type) {
        return (class_1792)ItemRegistry.ITEMS.getRegistrar().get(class_2960.method_60655((String)"zapinators", (String)(type.toString().toLowerCase() + "_core")));
    }

    public static void spawnLightning(class_243 pos, class_1937 level) {
        class_1538 lightning = new class_1538(class_1299.field_6112, level);
        lightning.method_33574(pos);
        level.method_8649((class_1297)lightning);
    }

    public static boolean entityFallenDespawnStarCheck(class_1297 ent) {
        if (ent.method_37908().method_8530() && !ent.method_37908().field_9236 && ent.field_6012 > 100) {
            class_2338 blockPos = class_2338.method_49637((double)ent.method_23317(), (double)ent.method_23318(), (double)ent.method_23321());
            if (ent.method_37908().method_8311(blockPos)) {
                return true;
            }
        }
        return false;
    }

    public static int getMoonPhase(class_1937 world) {
        long dayTime = world.method_8532();
        return (int)(dayTime / 24000L % 8L);
    }

    public static double getMoonMultiplier(class_1937 world) {
        int phase = Utils.getMoonPhase(world);
        return switch (phase) {
            case 0 -> 2.0;
            case 1, 7 -> 1.5;
            case 2, 6 -> 1.0;
            case 3, 5 -> 0.5;
            default -> 0.2;
        };
    }

    public static int getRandomBrightColor(class_5819 random) {
        int red = 128 + random.method_43048(128);
        int green = 128 + random.method_43048(128);
        int blue = 128 + random.method_43048(128);
        return red << 16 | green << 8 | blue;
    }

    public static boolean shouldProjectileForceRemove(class_1676 entity) {
        if (entity.field_6012 > 200) {
            return true;
        }
        if (!entity.method_37908().method_8393(entity.method_31476().field_9181, entity.method_31476().field_9180)) {
            return true;
        }
        if (!entity.method_37908().field_9236) {
            class_1297 owner = entity.method_24921();
            if (owner != null && owner.method_5858((class_1297)entity) > 9216.0) {
                return true;
            }
            boolean nearPlayer = entity.method_37908().method_18456().stream().anyMatch(player -> player.method_5858((class_1297)entity) < 6400.0);
            if (!nearPlayer) {
                return true;
            }
            class_1937 class_19372 = entity.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                return !serverLevel.method_37118(entity.method_24515());
            }
        }
        return false;
    }

    public static boolean isEntityInLiquidCustom(class_1297 entity) {
        class_2338 pos = entity.method_24515();
        class_2680 blockState = entity.method_37908().method_8320(pos);
        return blockState.method_26204() instanceof class_2404 || !blockState.method_26227().method_15769() || blockState.method_27852(class_2246.field_10382) || blockState.method_27852(class_2246.field_10164);
    }

    public static boolean canEntityDamageEntity(class_1297 entity1, class_1297 entity2) {
        class_268 e1Team = entity1.method_5781();
        class_268 e2Team = entity2.method_5781();
        if (e1Team == null && e2Team == null) {
            return true;
        }
        if (e1Team != null && e1Team.equals(e2Team)) {
            return e1Team.method_1205();
        }
        if (Platform.isModLoaded((String)"openpartiesandclaims") && entity1 instanceof class_1657) {
            class_1657 p1 = (class_1657)entity1;
            if (entity2 instanceof class_1657) {
                class_1657 p2 = (class_1657)entity2;
                return !OpacCompat.isPlayerTeammate(p1, p2);
            }
        }
        return true;
    }
}

