/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.namefix.client.ZapinatorsClient;
import com.namefix.config.ZapinatorsConfig;
import com.namefix.registry.AttributeRegistry;
import com.namefix.utils.Utils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;

public class ManaRenderer {
    private static final ResourceLocation MANA_STAR_TOP = ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)"textures/gui/mana/mana_top.png");
    private static final ResourceLocation MANA_STAR_MIDDLE = ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)"textures/gui/mana/mana_mid.png");
    private static final ResourceLocation MANA_STAR_BOTTOM = ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)"textures/gui/mana/mana_bot.png");
    private static final ResourceLocation MANA_STAR_SINGLE = ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)"textures/gui/mana/mana_single.png");
    private static final ResourceLocation MANA_STAR_FULL = ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)"textures/gui/mana/mana_full.png");

    public static void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int i;
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player.isCreative() || mc.player.isSpectator() || ZapinatorsConfig.Client.manaHudStyle.equals((Object)ZapinatorsConfig.ManaHudStyle.DISABLED)) {
            return;
        }
        double maxMana = mc.player.getAttributeValue(AttributeRegistry.getHolder(AttributeRegistry.MAX_MANA));
        if (maxMana == 0.0) {
            return;
        }
        if (ZapinatorsConfig.Client.manaHudHideAuto && !Utils.doesPlayerHoldManaWeapon((Player)mc.player) && (double)ZapinatorsClient.mana == maxMana) {
            return;
        }
        boolean isCustom = ZapinatorsConfig.Client.manaHudStyle.equals((Object)ZapinatorsConfig.ManaHudStyle.CUSTOM);
        int baseManaX = guiGraphics.guiWidth() - 24;
        int baseManaY = 10;
        float manaSize = 0.5f;
        if (isCustom) {
            baseManaX = ZapinatorsConfig.Client.manaHudX;
            baseManaY = ZapinatorsConfig.Client.manaHudY;
            manaSize = ZapinatorsConfig.Client.manaHudScale;
        } else if (mc.player.getActiveEffects().stream().anyMatch(MobEffectInstance::showIcon)) {
            baseManaY += 48;
        }
        int manaX = Math.round((float)baseManaX / manaSize);
        int manaY = Math.round((float)baseManaY / manaSize);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(manaSize, manaSize, manaSize);
        if (maxMana <= 20.0) {
            guiGraphics.blit(RenderType::guiTextured, MANA_STAR_SINGLE, manaX, manaY, 0.0f, 0.0f, 30, 32, 30, 32, 30, 32, -1);
        } else {
            int starAmount = Mth.ceil((double)(maxMana / 20.0));
            int midStarAmount = Math.max(starAmount - 2, 0);
            guiGraphics.blit(RenderType::guiTextured, MANA_STAR_TOP, manaX, manaY, 0.0f, 0.0f, 30, 26, 30, 26, 30, 26, -1);
            for (i = 0; i < midStarAmount; ++i) {
                guiGraphics.blit(RenderType::guiTextured, MANA_STAR_MIDDLE, manaX, manaY + 26 + i * 22, 0.0f, 0.0f, 30, 22, 30, 22, 30, 22, -1);
            }
            guiGraphics.blit(RenderType::guiTextured, MANA_STAR_BOTTOM, manaX, manaY + 26 + midStarAmount * 22, 0.0f, 0.0f, 30, 28, 30, 28, 30, 28, -1);
        }
        if (ZapinatorsClient.mana > 0.0f) {
            int fullStars = Mth.floor((float)(ZapinatorsClient.mana / 20.0f));
            int manaRemainder = (int)(ZapinatorsClient.mana % 20.0f);
            for (i = 0; i < fullStars; ++i) {
                guiGraphics.blit(RenderType::guiTextured, MANA_STAR_FULL, manaX + 4, manaY + 4 + i * 22, 0.0f, 0.0f, 22, 24, 22, 24, 22, 24, -1);
            }
            if (manaRemainder > 0) {
                float fillFraction = (float)manaRemainder / 20.0f;
                int fullStarWidth = 22;
                int fullStarHeight = 24;
                float scaleTime = 1.0f;
                if (ZapinatorsClient.manaRegenCooldown > 0) {
                    float time = (float)(System.currentTimeMillis() % 1000L) / 1000.0f;
                    scaleTime = 1.0f + 0.1f * Mth.sin((float)(time * 2.0f * (float)Math.PI));
                }
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(manaX + 4) + (float)fullStarWidth / 2.0f, (float)(manaY + 4 + fullStars * 22) + (float)fullStarHeight / 2.0f, 0.0f);
                guiGraphics.pose().scale(fillFraction * scaleTime, fillFraction * scaleTime, 1.0f);
                guiGraphics.blit(RenderType::guiTextured, MANA_STAR_FULL, -fullStarWidth / 2, -fullStarHeight / 2, 0.0f, 0.0f, fullStarWidth, fullStarHeight, fullStarWidth, fullStarHeight, fullStarWidth, fullStarHeight, -1);
                guiGraphics.pose().popPose();
            }
        }
        guiGraphics.pose().popPose();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }
}

