/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.client;

import com.namefix.config.ZapinatorsConfig;
import com.namefix.network.payload.InitialSyncPayload;
import com.namefix.network.payload.ManaStatusPayload;
import com.namefix.registry.AttributeRegistry;
import com.namefix.registry.SoundRegistry;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class ZapinatorsClient {
    public static float mana = 0.0f;
    public static int manaRegenCooldown = 0;
    public static boolean manaFull = false;

    public static void handleInitialSync(InitialSyncPayload payload, NetworkManager.PacketContext context) {
        mana = payload.mana();
        manaRegenCooldown = payload.manaRegenCooldown();
    }

    public static void handleManaStatus(ManaStatusPayload payload, NetworkManager.PacketContext context) {
        mana = payload.mana();
        manaRegenCooldown = payload.manaRegenCooldown();
    }

    public static void tick(ClientLevel clientLevel) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.player.isDeadOrDying()) {
            return;
        }
        float maxMana = (float)mc.player.getAttributeValue(AttributeRegistry.getHolder(AttributeRegistry.MAX_MANA));
        float manaRegen = (float)mc.player.getAttributeValue(AttributeRegistry.getHolder(AttributeRegistry.MANA_REGENERATION));
        if (manaRegenCooldown > 0) {
            --manaRegenCooldown;
        } else {
            if ((mana = (float)Mth.clamp((double)(mana + manaRegen), (double)0.0, (double)maxMana)) == maxMana && !manaFull && ZapinatorsConfig.Client.manaRefillSound) {
                mc.player.playSound((SoundEvent)SoundRegistry.MANA_FILL.get());
            }
            manaFull = mana == maxMana;
        }
    }

    public static void decreaseMana(float amount, boolean cooldown) {
        Minecraft mc = Minecraft.getInstance();
        float maxMana = (float)mc.player.getAttributeValue(AttributeRegistry.getHolder(AttributeRegistry.MAX_MANA));
        mana = Mth.clamp((float)(mana - amount), (float)0.0f, (float)maxMana);
        if (cooldown) {
            manaRegenCooldown = 60;
        }
    }
}

