/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.data;

import com.namefix.data.PlayerData;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class StateSaver
extends SavedData {
    public HashMap<UUID, PlayerData> players = new HashMap();
    private static final SavedData.Factory<StateSaver> type = new SavedData.Factory(StateSaver::createNew, StateSaver::createFromNbt, null);

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag playersTag = new CompoundTag();
        this.players.forEach((uuid, playerData) -> {
            CompoundTag playerTag = new CompoundTag();
            playerTag.putFloat("mana", playerData.mana);
            playerTag.putInt("manaRegenCooldown", playerData.manaRegenCooldown);
            playersTag.put(uuid.toString(), (Tag)playerTag);
        });
        compoundTag.put("players", (Tag)playersTag);
        return compoundTag;
    }

    public static StateSaver createFromNbt(CompoundTag compoundTag, HolderLookup.Provider provider) {
        StateSaver state = new StateSaver();
        CompoundTag playersTag = compoundTag.getCompound("players");
        playersTag.getAllKeys().forEach(key -> {
            CompoundTag playerTag = playersTag.getCompound(key);
            PlayerData playerData = new PlayerData();
            playerData.mana = playerTag.getFloat("mana");
            playerData.manaRegenCooldown = playerTag.getInt("manaRegenCooldown");
            UUID uuid = UUID.fromString(key);
            state.players.put(uuid, playerData);
        });
        return state;
    }

    public static StateSaver createNew() {
        StateSaver state = new StateSaver();
        return state;
    }

    public static StateSaver getServerState(MinecraftServer server) {
        ServerLevel world = server.getLevel(Level.OVERWORLD);
        assert (world != null);
        StateSaver state = (StateSaver)world.getDataStorage().computeIfAbsent(type, "zapinators");
        state.setDirty();
        return state;
    }

    public static PlayerData getPlayerState(LivingEntity player) {
        StateSaver serverState = StateSaver.getServerState(player.level().getServer());
        PlayerData playerState = serverState.players.computeIfAbsent(player.getUUID(), uuid -> new PlayerData());
        return playerState;
    }
}

