/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.namefix.config.ZapinatorsConfig;
import com.namefix.item.BeeGunItem;
import com.namefix.utils.Utils;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AngryBee
extends AbstractHurtingProjectile {
    public double beeSpeed = BeeGunItem.BEE_SPEED;
    public BeeSource beeSource = BeeSource.BEE_GUN;
    int blockBounces = 3;
    int enemyHits = 2;
    public float baseDamage = 1.0f;
    double homingRadius = 8.0;

    public AngryBee(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        if (!this.level().isClientSide && (this.tickCount > 200 || Utils.isEntityInLiquidCustom((Entity)this))) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new DustParticleOptions(0xBFBFBF, 1.0f), this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.discard();
            return;
        }
        double nearestDistance = Double.MAX_VALUE;
        Entity nearestEntity = null;
        if (this.beeSource.equals((Object)BeeSource.BEE_ARMOR) || this.tickCount > 5) {
            for (Entity entity2 : this.level().getEntities((Entity)this, this.getBoundingBox().inflate(this.homingRadius), e -> {
                Mob mob;
                return e.isAlive() && !(e instanceof AngryBee) && e != this.getOwner() && e instanceof Mob && ((mob = (Mob)e).isAggressive() || e instanceof Monster);
            })) {
                double dist;
                if (this.getOwner() != null && !Utils.canEntityDamageEntity(Objects.requireNonNull(this.getOwner()), entity2) || !((dist = this.distanceToSqr(entity2)) < nearestDistance)) continue;
                nearestDistance = dist;
                nearestEntity = entity2;
            }
            if (nearestEntity != null) {
                double targetCenterY = nearestEntity.getY() + (double)nearestEntity.getBbHeight() * 0.5;
                Vec3 targetCenter = new Vec3(nearestEntity.getX(), targetCenterY, nearestEntity.getZ());
                Vec3 toTarget = targetCenter.subtract(this.position()).normalize();
                Vec3 currentVelocity = this.getDeltaMovement();
                double speed = currentVelocity.length();
                if (speed > 1.0E-4) {
                    double turnRate = 0.4;
                    Vec3 wantedVelocity = toTarget.scale(speed);
                    Vec3 newVelocity = currentVelocity.scale(1.0 - turnRate).add(wantedVelocity.scale(turnRate));
                    this.setDeltaMovement(newVelocity.normalize().scale(this.beeSpeed));
                }
            }
        }
        if (!this.level().isClientSide) {
            EntityHitResult entityHitResult;
            BlockHitResult blockHitResult = this.level().clip(new ClipContext(this.position(), this.position().add(this.getDeltaMovement()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (blockHitResult.getType() == HitResult.Type.BLOCK) {
                this.onHitBlock(blockHitResult);
            }
            if ((entityHitResult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)this.position(), (Vec3)this.position().add(this.getDeltaMovement()), (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(0.2), entity -> !entity.isSpectator() && entity.isAlive() && !(entity instanceof AngryBee))) != null) {
                this.onHitEntity(entityHitResult);
            } else {
                Iterator iterator = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.1), e -> {
                    Mob mob;
                    return !e.isSpectator() && e.isAlive() && !(e instanceof AngryBee) && e != this.getOwner() && (e instanceof Mob && (mob = (Mob)e).isAggressive() || e instanceof Monster);
                }).iterator();
                if (iterator.hasNext()) {
                    Entity entity3 = (Entity)iterator.next();
                    this.onHitEntity(new EntityHitResult(entity3));
                }
            }
        }
        Vec3 motion = this.getDeltaMovement();
        this.move(MoverType.SELF, motion);
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        if (!this.level().isClientSide && this.blockBounces <= 0) {
            this.discard();
            return;
        }
        Direction dir = blockHitResult.getDirection();
        Vec3 normal = new Vec3((double)dir.getStepX(), (double)dir.getStepY(), (double)dir.getStepZ());
        Vec3 velocity = this.getDeltaMovement();
        Vec3 reflected = velocity.subtract(normal.scale(2.0 * velocity.dot(normal)));
        Vec3 newVelocity = reflected.normalize().scale(this.beeSpeed);
        this.setDeltaMovement(newVelocity);
        --this.blockBounces;
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        if (this.level().isClientSide) {
            return;
        }
        Entity target = entityHitResult.getEntity();
        if (!target.isOnFire() && target.invulnerableTime > 0) {
            return;
        }
        boolean knockback = ZapinatorsConfig.Server.beesApplyKnockback;
        Vec3 originalVelocity = target.getDeltaMovement();
        if (this.getOwner() != null) {
            if (target.getUUID().equals(this.getOwner().getUUID()) || !Utils.canEntityDamageEntity(Objects.requireNonNull(this.getOwner()), target)) {
                return;
            }
            target.hurtServer((ServerLevel)target.level(), this.damageSources().playerAttack((Player)this.getOwner()), this.baseDamage);
        } else if (target instanceof LivingEntity) {
            target.hurtServer((ServerLevel)target.level(), this.damageSources().sting((LivingEntity)target), this.baseDamage);
        } else {
            target.hurtServer((ServerLevel)target.level(), this.damageSources().generic(), this.baseDamage);
        }
        if (!knockback) {
            target.setDeltaMovement(originalVelocity);
        }
        target.invulnerableTime = 4;
        --this.enemyHits;
        if (this.enemyHits <= 0) {
            this.discard();
        }
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected boolean shouldBurn() {
        return false;
    }

    public static enum BeeSource {
        BEE_GUN,
        BEE_ARMOR;

    }
}

