/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.namefix.entity.AngryBee;
import com.namefix.entity.AngryBeeRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class AngryBeeRenderer<T extends AngryBee, S extends AngryBeeRenderState>
extends EntityRenderer<T, S> {
    private static final ResourceLocation ANGRY_BEE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)"textures/entity/angry_bee.png");
    private static final int FRAME_COUNT = 4;
    private static final float FRAME_HEIGHT = 0.25f;

    public AngryBeeRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(S entityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        int frame = (int)(((AngryBeeRenderState)((Object)entityRenderState)).ageInTicks % 4.0f);
        float v0 = (float)frame * 0.25f;
        float v1 = v0 + 0.25f;
        poseStack.pushPose();
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.scale(0.25f, 0.25f, 0.25f);
        poseStack.translate(0.0f, 1.0f, 0.0f);
        VertexConsumer vc = multiBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)ANGRY_BEE_TEXTURE));
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        int overlay = OverlayTexture.NO_OVERLAY;
        float nx = 0.0f;
        float ny = 0.0f;
        float nz = 1.0f;
        int blockLight = i & 0xFFFF;
        int skyLight = i >> 16 & 0xFFFF;
        vc.addVertex(poseStack.last().pose(), -0.5f, -0.5f, 0.0f).setColor(r, g, b, a).setUv(0.0f, v1).setUv2(blockLight, skyLight).setOverlay(overlay).setNormal(nx, ny, nz);
        vc.addVertex(poseStack.last().pose(), 0.5f, -0.5f, 0.0f).setColor(r, g, b, a).setUv(1.0f, v1).setUv2(blockLight, skyLight).setOverlay(overlay).setNormal(nx, ny, nz);
        vc.addVertex(poseStack.last().pose(), 0.5f, 0.5f, 0.0f).setColor(r, g, b, a).setUv(1.0f, v0).setUv2(blockLight, skyLight).setOverlay(overlay).setNormal(nx, ny, nz);
        vc.addVertex(poseStack.last().pose(), -0.5f, 0.5f, 0.0f).setColor(r, g, b, a).setUv(0.0f, v0).setUv2(blockLight, skyLight).setOverlay(overlay).setNormal(nx, ny, nz);
        poseStack.popPose();
        super.render(entityRenderState, poseStack, multiBufferSource, i);
    }

    @NotNull
    public S createRenderState() {
        return (S)((Object)new AngryBeeRenderState());
    }
}

