/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.namefix.config.ZapinatorsConfig;
import com.namefix.registry.ItemRegistry;
import com.namefix.registry.SoundRegistry;
import com.namefix.utils.Utils;
import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FallenStar
extends Entity {
    public FallenStar(EntityType<? extends FallenStar> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isNight()) {
            this.discard();
            return;
        }
        if (this.tickCount > 500) {
            this.drop();
            return;
        }
        if (this.tickCount % 20 == 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundRegistry.FALLEN_STAR_FALL.get(), SoundSource.WEATHER);
        }
        Vec3 motion = this.getDeltaMovement();
        this.move(MoverType.SELF, motion);
        if (ZapinatorsConfig.Server.fallenStarEntityDamage > 0.0f && !this.level().isClientSide()) {
            List collidingEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.1));
            for (Entity entity : collidingEntities) {
                if (entity == this || entity instanceof Player) continue;
                entity.hurtServer((ServerLevel)this.level(), this.damageSources().magic(), ZapinatorsConfig.Server.fallenStarEntityDamage);
                this.drop();
                return;
            }
        }
        if (this.onGround() || this.horizontalCollision || this.verticalCollision) {
            this.drop();
        }
        this.level().addParticle((ParticleOptions)new DustParticleOptions(Utils.getRandomBrightColor(this.random), 1.069f), this.getX(), this.getY() + 0.2, this.getZ(), 0.0, 0.0, 0.0);
    }

    public void drop() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundRegistry.FALLEN_STAR_HIT.get(), SoundSource.BLOCKS);
        ItemStack dropStack = new ItemStack((ItemLike)ItemRegistry.FALLEN_STAR.get());
        ItemEntity drop = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), dropStack);
        this.level().addFreshEntity((Entity)drop);
        if (!this.level().isClientSide()) {
            int particleCount = 20;
            for (int i = 0; i < particleCount; ++i) {
                double theta = this.random.nextDouble() * 2.0 * Math.PI;
                double phi = this.random.nextDouble() * 1.5707963267948966;
                double speed = 0.3 + this.random.nextDouble() * 0.2;
                double dx = speed * Math.cos(theta) * Math.sin(phi);
                double dy = speed * Math.cos(phi);
                double dz = speed * Math.sin(theta) * Math.sin(phi);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)new DustParticleOptions(15656731, 1.069f), this.getX(), this.getY(), this.getZ(), 1, dx, dy, dz, 0.0);
            }
        }
        this.discard();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float f) {
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }
}

