/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.namefix.entity.FallenStarRenderState;
import com.namefix.registry.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FallenStarRenderer<T extends Entity, S extends FallenStarRenderState>
extends EntityRenderer<T, S> {
    private final ItemStack starStack = new ItemStack((ItemLike)ItemRegistry.FALLEN_STAR.get());
    private long lastRenderTime = 0L;

    public FallenStarRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(S entityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            if (this.lastRenderTime == 0L) {
                this.lastRenderTime = System.currentTimeMillis();
            }
        } else {
            this.lastRenderTime = 0L;
        }
        long ms = this.lastRenderTime == 0L ? System.currentTimeMillis() : this.lastRenderTime;
        float rotation = (float)(ms % 1000L) / 1000.0f * 360.0f;
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.translate(0.0f, 0.1f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(((FallenStarRenderState)((Object)entityRenderState)).entityXRot));
        poseStack.mulPose(Axis.YP.rotationDegrees(-((FallenStarRenderState)((Object)entityRenderState)).entityYRot));
        poseStack.translate(0.0f, 0.1f, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-rotation));
        poseStack.translate(0.0f, -0.1f, 0.0f);
        mc.getItemRenderer().renderStatic(this.starStack, ItemDisplayContext.GROUND, 0xF000F0, OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, (Level)mc.level, 0);
        poseStack.popPose();
    }

    @NotNull
    public S createRenderState() {
        return (S)((Object)new FallenStarRenderState());
    }

    public void extractRenderState(T entity, S entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        ((FallenStarRenderState)((Object)entityRenderState)).entityXRot = entity.getXRot();
        ((FallenStarRenderState)((Object)entityRenderState)).entityYRot = entity.getYRot();
    }
}

