/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.namefix.config.ZapinatorsConfig;
import com.namefix.enums.ZapinatorType;
import com.namefix.mixin.EntityInvoker;
import com.namefix.utils.Utils;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class LaserProjectile
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(LaserProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Vector3f> SIZE = SynchedEntityData.defineId(LaserProjectile.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    private float baseDamage = 1.0f;
    private float baseKnockback = 0.5f;
    private boolean blockPiercing = false;
    private boolean entityPiercing = false;
    private int piercedEntities = 0;
    private int maxPiercing = 3;
    private ZapinatorType zapinatorType = ZapinatorType.NONE;
    private boolean zapinatorSlowedDown = false;

    public LaserProjectile(EntityType<? extends LaserProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        this.noPhysics = true;
        if (Utils.shouldProjectileForceRemove((Projectile)this)) {
            this.discard();
            return;
        }
        if (this.isOnFire()) {
            this.extinguishFire();
        }
        Vec3 motion = this.getDeltaMovement();
        if (!this.blockPiercing && this.checkCustomBlockCollision(motion)) {
            this.discard();
            return;
        }
        this.updateCollisionStates(motion, ((EntityInvoker)((Object)this)).zapinators$invokeCollide(motion));
        this.move(MoverType.SELF, motion);
        if (!this.level().isClientSide) {
            List collidingEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.2), e -> e != this && e != this.getOwner() && e.isAlive());
            for (Entity entity : collidingEntities) {
                Entity owner;
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).isInvulnerableTo((ServerLevel)this.level(), this.damageSources().mobAttack(living)) || (owner = this.getOwner()) != null && !Utils.canEntityDamageEntity(Objects.requireNonNull(this.getOwner()), entity)) continue;
                if (!this.zapinatorType.equals((Object)ZapinatorType.NONE) && entity.invulnerableTime == 0) {
                    this.handleZapinatorEntityCollision(entity);
                } else {
                    if (owner != null) {
                        entity.hurtServer((ServerLevel)entity.level(), this.damageSources().playerAttack((Player)this.getOwner()), this.baseDamage);
                    } else {
                        entity.hurtServer((ServerLevel)entity.level(), this.damageSources().magic(), this.baseDamage);
                    }
                    entity.invulnerableTime = 0;
                }
                if (this.canPierceEntities()) {
                    ++this.piercedEntities;
                } else {
                    this.discard();
                }
                if (this.maxPiercing != -1 && this.piercedEntities >= this.maxPiercing) {
                    this.discard();
                }
                return;
            }
        }
    }

    private boolean checkCustomBlockCollision(Vec3 motion) {
        Vec3 up;
        if (motion.lengthSqr() < 0.001) {
            return false;
        }
        Vector3f size = this.getSize();
        Vec3 start = this.position();
        int samples = 2;
        Vec3 forward = motion.normalize();
        Vec3 right = forward.cross(up = new Vec3(0.0, 1.0, 0.0));
        if (right.lengthSqr() < 1.0E-6) {
            up = new Vec3(1.0, 0.0, 0.0);
            right = forward.cross(up);
        }
        right = right.normalize();
        up = right.cross(forward);
        float widthStep = size.x / (float)(samples + 1);
        float heightStep = size.y / (float)(samples + 1);
        float collisionLength = (float)Math.min((double)(size.z * 0.3f), motion.length() + (double)0.1f);
        for (int i = 0; i < samples; ++i) {
            for (int j = 0; j < samples; ++j) {
                Vec3 sampleStart;
                float widthOffset = ((float)i - (float)(samples - 1) * 0.5f) * widthStep;
                float heightOffset = ((float)j - (float)(samples - 1) * 0.5f) * heightStep;
                Vec3 offset = right.scale((double)widthOffset).add(up.scale((double)heightOffset));
                Vec3 checkStart = sampleStart = start.add(offset);
                Vec3 checkEnd = sampleStart.add(forward.scale((double)collisionLength));
                ClipContext clipContext = new ClipContext(checkStart, checkEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
                BlockHitResult hitResult = this.level().clip(clipContext);
                if (hitResult.getType() != HitResult.Type.BLOCK) continue;
                this.setPos(hitResult.getLocation());
                return true;
            }
        }
        return false;
    }

    protected void handleZapinatorEntityCollision(Entity target) {
        boolean customChance;
        boolean slowdown;
        if (this.level().isClientSide) {
            return;
        }
        RandomSource random = this.random;
        float damage = this.baseDamage;
        boolean disableBlockUp = random.nextFloat() < 0.05f;
        boolean disableBlockDown = random.nextFloat() < 0.05f;
        boolean disableBlock = random.nextFloat() < 0.5f;
        boolean backwards = random.nextFloat() < 0.67f;
        boolean shiftRight = random.nextFloat() < 0.145f;
        boolean shiftBottom = random.nextFloat() < 0.145f;
        boolean multiplyKnockback = random.nextFloat() < 0.05f;
        boolean multiplyDamage = random.nextFloat() < 0.02f;
        boolean teleportUp = random.nextFloat() < 0.145f;
        boolean teleportDown = random.nextFloat() < 0.145f;
        boolean mirrorVertical = random.nextFloat() < 0.07f;
        boolean mirrorHorizontal = random.nextFloat() < 0.07f;
        boolean bl = slowdown = random.nextFloat() < 0.1f;
        if (disableBlockUp) {
            this.blockPiercing = true;
            this.move(null, new Vec3(0.0, 8.0, 0.0));
        }
        if (disableBlockDown) {
            this.blockPiercing = true;
            this.move(null, new Vec3(0.0, -8.0, 0.0));
        }
        if (disableBlock) {
            this.blockPiercing = true;
        }
        if (backwards) {
            Utils.mirrorHorizontal((Entity)this);
            Utils.mirrorVertical((Entity)this);
            Vec3 motion = this.getDeltaMovement();
            int moveAmount = random.nextInt(1, 20);
            this.move(null, new Vec3(motion.x * (double)moveAmount, motion.y * (double)moveAmount, motion.z * (double)moveAmount));
        }
        if (shiftRight) {
            Utils.rotateMotionXZ((Entity)this, 30.0f);
        }
        if (shiftBottom) {
            Utils.rotateMotionY((Entity)this, 30.0f);
        }
        if (teleportUp) {
            this.move(null, new Vec3(0.0, (double)random.nextInt(1, 5), 0.0));
        }
        if (teleportDown) {
            this.move(null, new Vec3(0.0, (double)(-random.nextInt(1, 5)), 0.0));
        }
        if (mirrorVertical) {
            Utils.mirrorVertical((Entity)this);
        }
        if (mirrorHorizontal) {
            Utils.mirrorHorizontal((Entity)this);
        }
        if (!this.zapinatorSlowedDown) {
            Utils.slowdownEntity((Entity)this, 40.0f);
            this.baseDamage *= 0.9f;
            this.baseKnockback *= 0.9f;
            this.zapinatorSlowedDown = true;
        }
        if (multiplyKnockback) {
            this.baseKnockback *= 10.0f;
        }
        if (multiplyDamage) {
            damage *= 10.0f;
        }
        if (slowdown) {
            float slowAmount = random.nextFloat() * 10.0f - 0.05f;
            Utils.slowdownEntity((Entity)this, slowAmount);
        }
        boolean bl2 = customChance = random.nextFloat() < 0.5f;
        if (customChance && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            switch (this.zapinatorType) {
                case RED: {
                    livingTarget.setRemainingFireTicks(livingTarget.getRemainingFireTicks() + random.nextInt(5, 201));
                    break;
                }
                case GREEN: {
                    livingTarget.addEffect(new MobEffectInstance(MobEffects.POISON, random.nextInt(20, 201), 1));
                    break;
                }
                case BLUE: {
                    livingTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, random.nextInt(20, 201), 1));
                    break;
                }
                case PURPLE: {
                    Utils.applyKnockback(livingTarget, (Entity)this, this.baseKnockback * 10.0f);
                    break;
                }
                case YELLOW: {
                    Utils.spawnLightning(livingTarget.position(), livingTarget.level());
                    break;
                }
                case WHITE: {
                    livingTarget.addEffect(new MobEffectInstance(MobEffects.LEVITATION, random.nextInt(20, 70)));
                }
            }
        }
        if (this.getOwner() != null) {
            target.hurtServer((ServerLevel)target.level(), this.damageSources().playerAttack((Player)this.getOwner()), damage * ZapinatorsConfig.Server.zapinatorDamageMultiplier);
        } else {
            target.hurtServer((ServerLevel)target.level(), this.damageSources().magic(), damage * ZapinatorsConfig.Server.zapinatorDamageMultiplier);
        }
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            Utils.applyKnockback(livingTarget, (Entity)this, this.baseKnockback);
        }
    }

    protected void updateCollisionStates(Vec3 vec3, Vec3 vec32) {
        boolean horizontalDiffX = !Mth.equal((double)vec3.x, (double)vec32.x);
        boolean horizontalDiffZ = !Mth.equal((double)vec3.z, (double)vec32.z);
        boolean bl = this.horizontalCollision = horizontalDiffX || horizontalDiffZ;
        if (Math.abs(vec3.y) > 0.0 || this.isControlledByOrIsLocalPlayer()) {
            this.verticalCollision = vec3.y != vec32.y;
            this.verticalCollisionBelow = this.verticalCollision && vec3.y < 0.0;
            this.setOnGroundWithMovement(this.verticalCollisionBelow, this.horizontalCollision, vec32);
        }
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public void checkDespawn() {
        if (Utils.shouldProjectileForceRemove((Projectile)this)) {
            this.discard();
            return;
        }
        super.checkDespawn();
    }

    protected boolean shouldBurn() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)0xFFFFFF);
        builder.define(SIZE, (Object)new Vector3f(0.15f, 0.15f, 1.6f));
        builder.build();
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void setBaseDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public void setSize(Vector3f size) {
        this.entityData.set(SIZE, (Object)size);
    }

    public Vector3f getSize() {
        return (Vector3f)this.entityData.get(SIZE);
    }

    public void setBlockPiercing(boolean status) {
        this.blockPiercing = status;
        this.noPhysics = status;
    }

    public boolean canPierceBlocks() {
        return this.blockPiercing;
    }

    public void setEntityPiercing(boolean status) {
        this.entityPiercing = status;
    }

    public boolean canPierceEntities() {
        return this.entityPiercing;
    }

    public void setMaxPiercing(int maxPiercing) {
        this.maxPiercing = maxPiercing;
    }

    public int getMaxPiercing() {
        return this.maxPiercing;
    }

    public ZapinatorType getZapinatorType() {
        return this.zapinatorType;
    }

    public void setZapinatorType(ZapinatorType zapinatorType) {
        this.zapinatorType = zapinatorType;
    }
}

