/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.namefix.config.ZapinatorsConfig;
import com.namefix.entity.LaserProjectile;
import com.namefix.entity.LaserProjectileRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class LaserProjectileRenderer<T extends LaserProjectile, S extends LaserProjectileRenderState>
extends EntityRenderer<T, S> {
    public LaserProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(S entityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        int color = ((LaserProjectileRenderState)((Object)entityRenderState)).color;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        poseStack.pushPose();
        Vec3 vel = ((LaserProjectileRenderState)((Object)entityRenderState)).velocity;
        if (vel.lengthSqr() > 0.0) {
            float yaw = (float)(Math.toDegrees(Math.atan2(vel.z, vel.x)) - 90.0);
            float pitch = (float)Math.toDegrees(Math.atan2(vel.y, Math.sqrt(vel.x * vel.x + vel.z * vel.z)));
            poseStack.translate(-((LaserProjectileRenderState)((Object)entityRenderState)).size.x / 2.0f, ((LaserProjectileRenderState)((Object)entityRenderState)).size.y / 2.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-yaw));
            poseStack.mulPose(Axis.XP.rotationDegrees(-pitch));
        }
        this.renderLaser(entityRenderState, poseStack, multiBufferSource, r, g, b, 0.5f);
        poseStack.popPose();
        super.render(entityRenderState, poseStack, multiBufferSource, i);
    }

    private void renderLaser(S state, PoseStack poseStack, MultiBufferSource bufferSource, float r, float g, float b, float alpha) {
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)"textures/entity/laser_projectile.png")));
        float width = ((LaserProjectileRenderState)((Object)state)).size.x;
        float height = ((LaserProjectileRenderState)((Object)state)).size.y;
        float length = ((LaserProjectileRenderState)((Object)state)).size.z;
        int light = 0xF000F0;
        int blockLight = light & 0xFFFF;
        int skyLight = light >> 16 & 0xFFFF;
        poseStack.pushPose();
        poseStack.translate(-width / 2.0f, -height / 2.0f, -length / 2.0f);
        PoseStack.Pose entry = poseStack.last();
        Matrix4f matrix = poseStack.last().pose();
        poseStack.translate(0.0, 0.18, 0.0);
        if (ZapinatorsConfig.Client.laserRenderStyle.equals((Object)ZapinatorsConfig.LaserRenderStyle.FANCY)) {
            float coreThickness = 0.04f;
            this.renderQuad(vertexConsumer, matrix, entry, coreThickness, coreThickness, length / 4.0f, width - coreThickness, coreThickness, length / 4.0f, width - coreThickness, height - coreThickness, length / 4.0f, coreThickness, height - coreThickness, length / 4.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, r, g, b, 1.0f, blockLight, skyLight, 0.0f, 0.0f, -1.0f);
            this.renderQuad(vertexConsumer, matrix, entry, width - coreThickness, coreThickness, length - length / 4.0f, coreThickness, coreThickness, length - length / 4.0f, coreThickness, height - coreThickness, length - length / 4.0f, width - coreThickness, height - coreThickness, length - length / 4.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, r, g, b, 1.0f, blockLight, skyLight, 0.0f, 0.0f, 1.0f);
            this.renderQuad(vertexConsumer, matrix, entry, coreThickness, height - coreThickness, length / 4.0f, width - coreThickness, height - coreThickness, length / 4.0f, width - coreThickness, height - coreThickness, length - length / 4.0f, coreThickness, height - coreThickness, length - length / 4.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, r, g, b, 1.0f, blockLight, skyLight, 0.0f, 1.0f, 0.0f);
            this.renderQuad(vertexConsumer, matrix, entry, coreThickness, coreThickness, length / 4.0f, width - coreThickness, coreThickness, length / 4.0f, width - coreThickness, coreThickness, length - length / 4.0f, coreThickness, coreThickness, length - length / 4.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, r, g, b, 1.0f, blockLight, skyLight, 0.0f, -1.0f, 0.0f);
            this.renderQuad(vertexConsumer, matrix, entry, coreThickness, coreThickness, length / 4.0f, coreThickness, coreThickness, length - length / 4.0f, coreThickness, height - coreThickness, length - length / 4.0f, coreThickness, height - coreThickness, length / 4.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, r, g, b, alpha, blockLight, skyLight, -1.0f, 0.0f, 0.0f);
            this.renderQuad(vertexConsumer, matrix, entry, width - coreThickness, coreThickness, length - length / 4.0f, width - coreThickness, coreThickness, length / 4.0f, width - coreThickness, height - coreThickness, length / 4.0f, width - coreThickness, height - coreThickness, length - length / 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, r, g, b, 1.0f, blockLight, skyLight, 1.0f, 0.0f, 0.0f);
        }
        this.renderQuad(vertexConsumer, matrix, entry, 0.0f, 0.0f, 0.0f, width, 0.0f, 0.0f, width, height, 0.0f, 0.0f, height, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, r, g, b, alpha, blockLight, skyLight, 0.0f, 0.0f, -1.0f);
        this.renderQuad(vertexConsumer, matrix, entry, width, 0.0f, length, 0.0f, 0.0f, length, 0.0f, height, length, width, height, length, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, r, g, b, alpha, blockLight, skyLight, 0.0f, 0.0f, 1.0f);
        this.renderQuad(vertexConsumer, matrix, entry, 0.0f, height, 0.0f, width, height, 0.0f, width, height, length, 0.0f, height, length, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, r, g, b, alpha, blockLight, skyLight, 0.0f, 1.0f, 0.0f);
        this.renderQuad(vertexConsumer, matrix, entry, 0.0f, 0.0f, 0.0f, width, 0.0f, 0.0f, width, 0.0f, length, 0.0f, 0.0f, length, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, r, g, b, alpha, blockLight, skyLight, 0.0f, -1.0f, 0.0f);
        this.renderQuad(vertexConsumer, matrix, entry, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, length, 0.0f, height, length, 0.0f, height, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, r, g, b, alpha, blockLight, skyLight, -1.0f, 0.0f, 0.0f);
        this.renderQuad(vertexConsumer, matrix, entry, width, 0.0f, length, width, 0.0f, 0.0f, width, height, 0.0f, width, height, length, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, r, g, b, alpha, blockLight, skyLight, 1.0f, 0.0f, 0.0f);
        poseStack.popPose();
    }

    private void renderQuad(VertexConsumer vertexConsumer, Matrix4f matrix, PoseStack.Pose entry, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, float u3, float v3, float u4, float v4, float r, float g, float b, float alpha, int blockLight, int skyLight, float nx, float ny, float nz) {
        vertexConsumer.addVertex(matrix, x1, y1, z1).setColor(r, g, b, alpha).setUv(u1, v1).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(blockLight, skyLight).setNormal(entry, nx, ny, nz);
        vertexConsumer.addVertex(matrix, x2, y2, z2).setColor(r, g, b, alpha).setUv(u2, v2).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(blockLight, skyLight).setNormal(entry, nx, ny, nz);
        vertexConsumer.addVertex(matrix, x3, y3, z3).setColor(r, g, b, alpha).setUv(u3, v3).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(blockLight, skyLight).setNormal(entry, nx, ny, nz);
        vertexConsumer.addVertex(matrix, x4, y4, z4).setColor(r, g, b, alpha).setUv(u4, v4).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(blockLight, skyLight).setNormal(entry, nx, ny, nz);
    }

    @NotNull
    public S createRenderState() {
        return (S)((Object)new LaserProjectileRenderState());
    }

    public void extractRenderState(T entity, S entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        ((LaserProjectileRenderState)((Object)entityRenderState)).color = ((LaserProjectile)((Object)entity)).getColor();
        ((LaserProjectileRenderState)((Object)entityRenderState)).velocity = entity.getDeltaMovement();
        ((LaserProjectileRenderState)((Object)entityRenderState)).size = ((LaserProjectile)((Object)entity)).getSize();
    }
}

