/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.namefix.utils.Utils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Orb
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(Orb.class, (EntityDataSerializer)EntityDataSerializers.INT);
    float orbSpeed;
    float baseDamage;
    int despawnTicks = 200;
    boolean hasGravity = false;
    int piercingLeft = 0;
    boolean fireChance = false;

    public Orb(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        if (Utils.shouldProjectileForceRemove((Projectile)this) || this.despawnTicks <= 0 || this.horizontalCollision || this.verticalCollision || this.fireChance && Utils.isEntityInLiquidCustom((Entity)this)) {
            this.discard();
            return;
        }
        Vec3 particlePos = this.position().add(this.getDeltaMovement());
        this.level().addParticle((ParticleOptions)new DustParticleOptions(((Integer)this.entityData.get(COLOR)).intValue(), 1.51337f), particlePos.x, particlePos.y + (double)(this.getBbHeight() / 2.0f), particlePos.z, 1.0, 1.0, 1.0);
        Vec3 motion = this.getDeltaMovement();
        if (this.hasGravity) {
            motion = motion.add(0.0, -0.009, 0.0);
            this.setDeltaMovement(motion);
        }
        this.move(MoverType.SELF, motion);
        if (!this.level().isClientSide) {
            List collidingEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.1), e -> e != this && e != this.getOwner() && e.isAlive());
            for (Entity entity : collidingEntities) {
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).isInvulnerableTo((ServerLevel)this.level(), this.damageSources().mobAttack(living)) || entity.invulnerableTime > 0) continue;
                if (this.getOwner() != null) {
                    if (!Utils.canEntityDamageEntity(Objects.requireNonNull(this.getOwner()), entity)) continue;
                    entity.hurtServer((ServerLevel)this.level(), this.damageSources().mobAttack((LivingEntity)this.getOwner()), this.baseDamage);
                } else {
                    entity.hurtServer((ServerLevel)this.level(), this.damageSources().magic(), this.baseDamage);
                }
                entity.invulnerableTime = 2;
                if (this.fireChance) {
                    RandomSource rand = this.level().random;
                    int roll1 = (double)rand.nextFloat() < 0.83 ? rand.nextInt(1, 3) : 0;
                    int roll2 = (double)rand.nextFloat() < 0.17 ? rand.nextInt(1, 3) : 0;
                    entity.setRemainingFireTicks((roll1 + roll2) * 20);
                }
                if (this.piercingLeft <= 0) {
                    this.discard();
                }
                --this.piercingLeft;
                return;
            }
        }
        --this.despawnTicks;
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public void checkDespawn() {
        if (Utils.shouldProjectileForceRemove((Projectile)this)) {
            this.discard();
            return;
        }
        super.checkDespawn();
    }

    protected boolean shouldBurn() {
        return false;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)0xFFFFFF);
        builder.build();
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void setOrbSpeed(float orbSpeed) {
        this.orbSpeed = orbSpeed;
    }

    public float getOrbSpeed() {
        return this.orbSpeed;
    }

    public void setBaseDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public void setHasGravity(boolean hasGravity) {
        this.hasGravity = hasGravity;
    }

    public boolean getHasGravity() {
        return this.hasGravity;
    }

    public void setDespawnTicks(int despawnTicks) {
        this.despawnTicks = despawnTicks;
    }

    public void setPiercingLeft(int piercingLeft) {
        this.piercingLeft = piercingLeft;
    }

    public void setFireChance(boolean fireChance) {
        this.fireChance = fireChance;
    }
}

