/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.namefix.entity.Orb;
import com.namefix.entity.OrbRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import org.jetbrains.annotations.NotNull;

public class OrbRenderer<T extends Orb, S extends OrbRenderState>
extends EntityRenderer<T, S> {
    private static final int SEGMENTS = 8;

    public OrbRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(S entityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        poseStack.pushPose();
        poseStack.scale(0.1f, 0.1f, 0.1f);
        poseStack.translate(0.0, 1.55, 0.0);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.debugQuads());
        int color = ((OrbRenderState)((Object)entityRenderState)).color;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        int light = 0xF000F0;
        int blockLight = light & 0xFFFF;
        int skyLight = light >> 16 & 0xFFFF;
        for (int il = 0; il < 8; ++il) {
            float lat0 = (float)(Math.PI * (-0.5 + (double)il / 8.0));
            float lat1 = (float)(Math.PI * (-0.5 + (double)(il + 1) / 8.0));
            for (int j = 0; j < 8; ++j) {
                float lon0 = (float)(Math.PI * 2 * (double)j / 8.0);
                float lon1 = (float)(Math.PI * 2 * (double)(j + 1) / 8.0);
                float x1 = (float)(Math.cos(lat0) * Math.cos(lon0));
                float y1 = (float)Math.sin(lat0);
                float z1 = (float)(Math.cos(lat0) * Math.sin(lon0));
                float x2 = (float)(Math.cos(lat0) * Math.cos(lon1));
                float y2 = (float)Math.sin(lat0);
                float z2 = (float)(Math.cos(lat0) * Math.sin(lon1));
                float x3 = (float)(Math.cos(lat1) * Math.cos(lon0));
                float y3 = (float)Math.sin(lat1);
                float z3 = (float)(Math.cos(lat1) * Math.sin(lon0));
                float x4 = (float)(Math.cos(lat1) * Math.cos(lon1));
                float y4 = (float)Math.sin(lat1);
                float z4 = (float)(Math.cos(lat1) * Math.sin(lon1));
                vertexConsumer.addVertex(poseStack.last().pose(), x1, y1, z1).setColor(r, g, b, 1.0f).setUv(0.0f, 0.0f).setOverlay(0).setUv2(blockLight, skyLight).setNormal(x1, y1, z1);
                vertexConsumer.addVertex(poseStack.last().pose(), x2, y2, z2).setColor(r, g, b, 1.0f).setUv(0.0f, 0.0f).setOverlay(0).setUv2(blockLight, skyLight).setNormal(x2, y2, z2);
                vertexConsumer.addVertex(poseStack.last().pose(), x3, y3, z3).setColor(r, g, b, 1.0f).setUv(0.0f, 0.0f).setOverlay(0).setUv2(blockLight, skyLight).setNormal(x3, y3, z3);
                vertexConsumer.addVertex(poseStack.last().pose(), x2, y2, z2).setColor(r, g, b, 1.0f).setUv(0.0f, 0.0f).setOverlay(0).setUv2(blockLight, skyLight).setNormal(x2, y2, z2);
                vertexConsumer.addVertex(poseStack.last().pose(), x4, y4, z4).setColor(r, g, b, 1.0f).setUv(0.0f, 0.0f).setOverlay(0).setUv2(blockLight, skyLight).setNormal(x4, y4, z4);
                vertexConsumer.addVertex(poseStack.last().pose(), x3, y3, z3).setColor(r, g, b, 1.0f).setUv(0.0f, 0.0f).setOverlay(0).setUv2(blockLight, skyLight).setNormal(x3, y3, z3);
            }
        }
        poseStack.popPose();
    }

    @NotNull
    public S createRenderState() {
        return (S)((Object)new OrbRenderState());
    }

    public void extractRenderState(T entity, S entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        ((OrbRenderState)((Object)entityRenderState)).color = ((Orb)((Object)entity)).getColor();
    }
}

