/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.entity;

import com.namefix.registry.ItemRegistry;
import com.namefix.registry.SoundRegistry;
import com.namefix.utils.Utils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StarProjectile
extends AbstractHurtingProjectile {
    private float baseDamage = 15.0f;
    private boolean hitEntity = false;
    public boolean shotFromCreative = false;

    public StarProjectile(EntityType<? extends StarProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        if (Utils.shouldProjectileForceRemove((Projectile)this)) {
            this.discard();
            return;
        }
        if (this.horizontalCollision || this.verticalCollision) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundRegistry.FALLEN_STAR_HIT.get(), SoundSource.BLOCKS);
            if (!(this.hitEntity || this.shotFromCreative || this.level().isClientSide)) {
                ItemStack dropStack = new ItemStack((ItemLike)ItemRegistry.FALLEN_STAR.get());
                ItemEntity drop = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), dropStack);
                this.level().addFreshEntity((Entity)drop);
            }
            this.discard();
            return;
        }
        this.level().addParticle((ParticleOptions)new DustParticleOptions(Utils.getRandomBrightColor(this.random), 1.069f), this.getX(), this.getY() + 0.2, this.getZ(), 0.0, 0.0, 0.0);
        Vec3 motion = this.getDeltaMovement();
        this.move(MoverType.SELF, motion);
        if (!this.level().isClientSide) {
            List collidingEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.1), e -> e != this && e != this.getOwner() && e.isAlive());
            for (Entity entity : collidingEntities) {
                float damage;
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).isInvulnerableTo((ServerLevel)this.level(), this.damageSources().mobAttack(living))) continue;
                if (!entity.isOnFire() && entity.invulnerableTime > 0) {
                    return;
                }
                float f = damage = entity instanceof Player ? this.baseDamage / 4.0f : this.baseDamage;
                if (this.getOwner() != null) {
                    if (!Utils.canEntityDamageEntity(Objects.requireNonNull(this.getOwner()), entity)) continue;
                    entity.hurtServer((ServerLevel)this.level(), this.damageSources().mobAttack((LivingEntity)this.getOwner()), damage);
                } else {
                    entity.hurtServer((ServerLevel)this.level(), this.damageSources().magic(), damage);
                }
                entity.invulnerableTime = 2;
                this.hitEntity = true;
            }
        }
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public void checkDespawn() {
        if (Utils.shouldProjectileForceRemove((Projectile)this)) {
            this.discard();
            return;
        }
        super.checkDespawn();
    }

    protected boolean shouldBurn() {
        return false;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }
}

