/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.item;

import com.namefix.entity.LaserProjectile;
import com.namefix.enums.ZapinatorType;
import com.namefix.item.AbstractManaItem;
import com.namefix.registry.EntityRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public abstract class AbstractLaserGunItem
extends AbstractManaItem {
    protected int color = 0xFFFFFF;
    protected float baseDamage = 1.0f;
    protected float projectileSpeed = 1.2f;
    protected int itemCooldown = 20;
    protected float laserLength = 1.6f;
    protected float laserWidth = 0.15f;
    protected float laserHeight = 0.15f;
    protected boolean blockPiercing = false;
    protected boolean entityPiercing = true;
    protected int maxPiercing = 3;
    protected ZapinatorType zapinatorType = ZapinatorType.NONE;
    protected SoundEvent shootSound;

    public AbstractLaserGunItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        if (!this.canPlayerUseManaItem(level, player)) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide) {
            LaserProjectile projectile = new LaserProjectile((EntityType<? extends LaserProjectile>)((EntityType)EntityRegistry.LASER_PROJECTILE.get()), level);
            Vec3 lookVec = player.getLookAngle();
            Vec3 offsetVec = interactionHand == InteractionHand.MAIN_HAND ? lookVec.cross(new Vec3(0.0, 1.0, 0.0)).normalize() : lookVec.cross(new Vec3(0.0, -1.0, 0.0)).normalize();
            double offsetAmount = 0.2;
            projectile.setPos(player.getX() + offsetVec.x * offsetAmount, player.getEyeY() - 0.1 + offsetVec.y * offsetAmount, player.getZ() + offsetVec.z * offsetAmount);
            double trajectoryCorrection = 0.07;
            Vec3 adjustedLookVec = lookVec.add(offsetVec.scale(-trajectoryCorrection * offsetAmount));
            projectile.setDeltaMovement(adjustedLookVec.x * (double)this.projectileSpeed, adjustedLookVec.y * (double)this.projectileSpeed, adjustedLookVec.z * (double)this.projectileSpeed);
            projectile.setOwner((Entity)player);
            projectile.setXRot(player.getXRot());
            projectile.setYRot(player.getYRot());
            projectile.setColor(this.color);
            projectile.setBaseDamage(this.baseDamage * this.getDamageModifier());
            projectile.setSize(new Vector3f(this.laserWidth, this.laserHeight, this.laserLength));
            projectile.setBlockPiercing(this.blockPiercing);
            projectile.setEntityPiercing(this.entityPiercing);
            projectile.setMaxPiercing(this.maxPiercing);
            projectile.setZapinatorType(this.zapinatorType);
            level.addFreshEntity((Entity)projectile);
        }
        this.useManaItem(level, player, this.meteoriteArmorSavesMana);
        player.getCooldowns().addCooldown(this.arch$registryName(), this.itemCooldown);
        if (this.shootSound != null) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), this.shootSound, SoundSource.PLAYERS);
        }
        return InteractionResult.CONSUME;
    }

    public float getDamageModifier() {
        return 1.0f;
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.NONE;
    }
}

