/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.item;

import com.namefix.client.ZapinatorsClient;
import com.namefix.data.PlayerData;
import com.namefix.item.MeteoriteArmorItem;
import com.namefix.server.ZapinatorsServer;
import com.namefix.utils.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class AbstractManaItem
extends Item {
    boolean meteoriteArmorSavesMana = false;
    float manaCost = 1.0f;

    public AbstractManaItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canPlayerUseManaItem(Level level, Player player) {
        boolean meteoriteSetBonus = Utils.getPlayerArmorFullSet(player, MeteoriteArmorItem.class);
        if (!this.meteoriteArmorSavesMana) {
            meteoriteSetBonus = false;
        }
        if (!player.isCreative() && !meteoriteSetBonus && this.manaCost > 0.0f) {
            if (level.isClientSide()) {
                return !(ZapinatorsClient.mana < this.manaCost);
            }
            PlayerData data = ZapinatorsServer.getPlayerData((ServerPlayer)player);
            return !(data.mana < this.manaCost);
        }
        return true;
    }

    public void useManaItem(Level level, Player player, boolean meteoriteArmorSavesMana) {
        boolean meteoriteSetBonus = Utils.getPlayerArmorFullSet(player, MeteoriteArmorItem.class);
        if (!(player.isCreative() || !(this.manaCost > 0.0f) || meteoriteSetBonus && meteoriteArmorSavesMana)) {
            if (level.isClientSide()) {
                ZapinatorsClient.decreaseMana(this.manaCost, true);
            } else {
                ZapinatorsServer.decreaseMana((ServerPlayer)player, this.manaCost, true);
            }
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        if (this.manaCost > 0.0f) {
            String manaFormatted = this.manaCost == (float)((int)this.manaCost) ? String.valueOf((int)this.manaCost) : String.format("%.1f", Float.valueOf(this.manaCost));
            list.add((Component)Component.translatable((String)"item.zapinators.description.mana_usage", (Object[])new Object[]{manaFormatted}).withStyle(ChatFormatting.BLUE));
        }
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }
}

