/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.item;

import com.namefix.entity.Orb;
import com.namefix.item.AbstractManaItem;
import com.namefix.registry.EntityRegistry;
import com.namefix.registry.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractOrbShooterItem
extends AbstractManaItem {
    float baseDamage;
    int itemCooldown;
    int color;
    float orbSpeed = 0.5f;
    boolean gravity = false;
    int orbDespawnTick = 200;
    int piercingAmount = 0;
    boolean fireChance = false;
    SoundEvent shootSound;

    public AbstractOrbShooterItem(Item.Properties properties, float manaCost, float baseDamage, int itemCooldown, int color) {
        super(properties);
        this.manaCost = manaCost;
        this.baseDamage = baseDamage;
        this.itemCooldown = itemCooldown;
        this.color = color;
        this.shootSound = this.getShootSound();
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        if (!this.canPlayerUseManaItem(level, player)) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide) {
            Vec3 lookVec = player.getLookAngle();
            Vec3 offsetVec = interactionHand == InteractionHand.MAIN_HAND ? lookVec.cross(new Vec3(0.0, 1.0, 0.0)).normalize() : lookVec.cross(new Vec3(0.0, -1.0, 0.0)).normalize();
            double offsetAmount = 0.2;
            Orb orb = new Orb((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityRegistry.ORB.get()), level);
            orb.setPos(player.getX() + offsetVec.x * offsetAmount, player.getEyeY() - 0.1 + offsetVec.y * offsetAmount, player.getZ() + offsetVec.z * offsetAmount);
            double trajectoryCorrection = 0.07;
            Vec3 adjustedLookVec = lookVec.add(offsetVec.scale(-trajectoryCorrection * offsetAmount));
            orb.setDeltaMovement(adjustedLookVec.x * (double)this.orbSpeed, adjustedLookVec.y * (double)this.orbSpeed, adjustedLookVec.z * (double)this.orbSpeed);
            orb.setOrbSpeed(this.orbSpeed);
            orb.setColor(this.color);
            orb.setOwner((Entity)player);
            orb.setXRot(player.getXRot());
            orb.setYRot(player.getYRot());
            orb.setHasGravity(this.gravity);
            orb.setBaseDamage(this.baseDamage * this.getDamageModifier());
            orb.setDespawnTicks(this.orbDespawnTick);
            orb.setPiercingLeft(this.piercingAmount);
            orb.setFireChance(this.fireChance);
            level.addFreshEntity((Entity)orb);
        }
        this.useManaItem(level, player, this.meteoriteArmorSavesMana);
        player.getCooldowns().addCooldown(player.getItemInHand(interactionHand), this.itemCooldown);
        if (this.shootSound != null) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), this.shootSound, SoundSource.PLAYERS);
        }
        return InteractionResult.SUCCESS;
    }

    public float getDamageModifier() {
        return 1.0f;
    }

    protected SoundEvent getShootSound() {
        return (SoundEvent)SoundRegistry.GEM_STAFF_SHOOT.getOrNull();
    }
}

