/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.item;

import com.namefix.config.ZapinatorsConfig;
import com.namefix.entity.AngryBee;
import com.namefix.item.AbstractManaItem;
import com.namefix.item.BeeArmorItem;
import com.namefix.registry.EntityRegistry;
import com.namefix.registry.SoundRegistry;
import com.namefix.utils.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BeeGunItem
extends AbstractManaItem {
    public static float BEE_SPEED = 0.3f;
    protected int itemCooldown = 5;
    protected SoundEvent shootSound = (SoundEvent)SoundRegistry.BEE_GUN_SHOOT.getOrNull();

    public BeeGunItem(Item.Properties properties) {
        super(properties);
        this.manaCost = 8.0f;
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        if (!this.canPlayerUseManaItem(level, player)) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide) {
            int initialBeeAmount = level.getRandom().nextInt(1, 3);
            if (level.getRandom().nextFloat() < 0.16f) {
                ++initialBeeAmount;
            }
            for (int i = 0; i < initialBeeAmount; ++i) {
                double offsetX = (level.getRandom().nextDouble() - 0.5) * 0.4;
                double offsetY = (level.getRandom().nextDouble() - 0.5) * 0.4;
                double offsetZ = (level.getRandom().nextDouble() - 0.5) * 0.4;
                AngryBee bee = new AngryBee((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityRegistry.ANGRY_BEE.get()), level);
                bee.beeSpeed = BEE_SPEED;
                bee.beeSource = AngryBee.BeeSource.BEE_GUN;
                bee.baseDamage *= (1.0f + 0.05f * (float)Utils.countPlayerArmorSet(player, BeeArmorItem.class)) * ZapinatorsConfig.Server.beeDamageMultiplier;
                bee.setPos(player.getX() + offsetX, player.getEyeY() - 0.1 + offsetY, player.getZ() + offsetZ);
                bee.setDeltaMovement(player.getLookAngle().scale((double)BEE_SPEED));
                bee.setOwner((Entity)player);
                bee.setXRot(player.getXRot());
                bee.setYRot(player.getYRot());
                level.addFreshEntity((Entity)bee);
            }
        }
        this.useManaItem(level, player, this.meteoriteArmorSavesMana);
        player.getCooldowns().addCooldown(this.arch$registryName(), this.itemCooldown);
        if (this.shootSound != null) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), this.shootSound, SoundSource.PLAYERS);
        }
        return InteractionResult.CONSUME;
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.NONE;
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"item.zapinators.bee_gun.description").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }
}

