/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.item;

import com.namefix.registry.AttributeRegistry;
import com.namefix.registry.SoundRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ManaCrystalItem
extends Item {
    public ManaCrystalItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        AttributeInstance maxMana = player.getAttribute(AttributeRegistry.getHolder(AttributeRegistry.MAX_MANA));
        player.playSound((SoundEvent)SoundRegistry.MANA_CRYSTAL_USE.get());
        player.getCooldowns().addCooldown(player.getItemInHand(interactionHand), 20);
        if (maxMana == null || maxMana.getValue() >= 200.0) {
            return InteractionResult.FAIL;
        }
        maxMana.setBaseValue(maxMana.getValue() + 20.0);
        if (!player.isCreative()) {
            ItemStack heldStack = player.getItemInHand(interactionHand);
            heldStack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"item.zapinators.mana_crystal_description").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }
}

