/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.item;

import com.namefix.config.ZapinatorsConfig;
import com.namefix.entity.StarProjectile;
import com.namefix.registry.EntityRegistry;
import com.namefix.registry.ItemRegistry;
import com.namefix.registry.SoundRegistry;
import com.namefix.utils.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class StarCannonItem
extends Item {
    private float starSpeed = 1.5f;

    public StarCannonItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        if (!player.isCreative() && !player.getInventory().contains(((Item)ItemRegistry.FALLEN_STAR.get()).getDefaultInstance())) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide) {
            Vec3 lookVec = player.getLookAngle();
            Vec3 offsetVec = interactionHand == InteractionHand.MAIN_HAND ? lookVec.cross(new Vec3(0.0, 1.0, 0.0)).normalize() : lookVec.cross(new Vec3(0.0, -1.0, 0.0)).normalize();
            double offsetAmount = 0.2;
            StarProjectile star = new StarProjectile((EntityType<? extends StarProjectile>)((EntityType)EntityRegistry.STAR_PROJECTILE.get()), level);
            star.setPos(player.getX() + offsetVec.x * offsetAmount, player.getEyeY() - 0.1 + offsetVec.y * offsetAmount, player.getZ() + offsetVec.z * offsetAmount);
            double trajectoryCorrection = 0.07;
            Vec3 adjustedLookVec = lookVec.add(offsetVec.scale(-trajectoryCorrection * offsetAmount));
            star.setDeltaMovement(adjustedLookVec.x * (double)this.starSpeed, adjustedLookVec.y * (double)this.starSpeed, adjustedLookVec.z * (double)this.starSpeed);
            star.setOwner((Entity)player);
            star.setBaseDamage(star.getBaseDamage() * this.getDamageModifier());
            star.shotFromCreative = player.isCreative();
            star.setXRot(player.getXRot());
            star.setYRot(player.getYRot());
            level.addFreshEntity((Entity)star);
            if (!player.isCreative()) {
                Utils.removeOneItem(player, (Item)ItemRegistry.FALLEN_STAR.get());
            }
        }
        player.getCooldowns().addCooldown(this.arch$registryName(), 5);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.STAR_CANNON_SHOOT.getOrNull(), SoundSource.PLAYERS);
        return InteractionResult.CONSUME;
    }

    public float getDamageModifier() {
        return ZapinatorsConfig.Server.starCannonDamageMultiplier;
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.NONE;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"item.zapinators.star_cannon.description").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }
}

