/*
 * Decompiled with CFR 0.152.
 */
package com.namefix.registry;

import com.namefix.enums.GemStaffType;
import com.namefix.enums.ZapinatorType;
import com.namefix.item.BeeArmorItem;
import com.namefix.item.BeeGunItem;
import com.namefix.item.ColorZapinatorItem;
import com.namefix.item.CoreItem;
import com.namefix.item.DescriptionItem;
import com.namefix.item.FallenStarItem;
import com.namefix.item.GemStaffItem;
import com.namefix.item.LaserRifleItem;
import com.namefix.item.ManaCrystalItem;
import com.namefix.item.MeteoriteArmorItem;
import com.namefix.item.ModArmorMaterials;
import com.namefix.item.RuneItem;
import com.namefix.item.SpaceGunItem;
import com.namefix.item.StarCannonItem;
import com.namefix.item.WandOfSparkingItem;
import com.namefix.item.ZapinatorItem;
import com.namefix.registry.TabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.equipment.ArmorType;

public class ItemRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"zapinators", (ResourceKey)Registries.ITEM);
    public static final RegistrySupplier<Item> SPACE_GUN = ItemRegistry.registerItem("space_gun", properties -> new SpaceGunItem(properties.stacksTo(1)));
    public static final RegistrySupplier<Item> LASER_RIFLE = ItemRegistry.registerItem("laser_rifle", properties -> new LaserRifleItem(properties.stacksTo(1)));
    public static final RegistrySupplier<Item> ZAPINATOR = ItemRegistry.registerItem("zapinator", properties -> new ZapinatorItem(properties.stacksTo(1)));
    public static final RegistrySupplier<Item> GRAY_ZAPINATOR = ItemRegistry.registerItem("gray_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1), ZapinatorType.GRAY, 2.5f, 5.0f, true));
    public static final RegistrySupplier<Item> ORANGE_ZAPINATOR = ItemRegistry.registerItem("orange_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1), ZapinatorType.ORANGE, 5.0f, 5.0f, true));
    public static final RegistrySupplier<Item> RED_ZAPINATOR = ItemRegistry.registerItem("red_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1), ZapinatorType.RED, 3.0f, 6.0f, false));
    public static final RegistrySupplier<Item> GREEN_ZAPINATOR = ItemRegistry.registerItem("green_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1), ZapinatorType.GREEN, 3.5f, 6.0f, false));
    public static final RegistrySupplier<Item> BLUE_ZAPINATOR = ItemRegistry.registerItem("blue_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1), ZapinatorType.BLUE, 4.0f, 5.0f, false));
    public static final RegistrySupplier<Item> PURPLE_ZAPINATOR = ItemRegistry.registerItem("purple_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1), ZapinatorType.PURPLE, 4.5f, 5.0f, false));
    public static final RegistrySupplier<Item> BLACK_ZAPINATOR = ItemRegistry.registerItem("black_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1).rarity(Rarity.EPIC), ZapinatorType.BLACK, 69420.0f, 0.0f, false));
    public static final RegistrySupplier<Item> YELLOW_ZAPINATOR = ItemRegistry.registerItem("yellow_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1), ZapinatorType.YELLOW, 3.0f, 6.0f, false));
    public static final RegistrySupplier<Item> WHITE_ZAPINATOR = ItemRegistry.registerItem("white_zapinator", properties -> new ColorZapinatorItem(properties.stacksTo(1), ZapinatorType.WHITE, 3.5f, 4.0f, false));
    public static final RegistrySupplier<Item> GRAY_CORE = ItemRegistry.registerItem("gray_core", properties -> new CoreItem(properties));
    public static final RegistrySupplier<Item> ORANGE_CORE = ItemRegistry.registerItem("orange_core", properties -> new CoreItem(properties));
    public static final RegistrySupplier<Item> RED_CORE = ItemRegistry.registerItem("red_core", properties -> new CoreItem(properties));
    public static final RegistrySupplier<Item> GREEN_CORE = ItemRegistry.registerItem("green_core", properties -> new CoreItem(properties));
    public static final RegistrySupplier<Item> BLUE_CORE = ItemRegistry.registerItem("blue_core", properties -> new CoreItem(properties));
    public static final RegistrySupplier<Item> PURPLE_CORE = ItemRegistry.registerItem("purple_core", properties -> new CoreItem(properties));
    public static final RegistrySupplier<Item> BLACK_CORE = ItemRegistry.registerItem("black_core", properties -> new CoreItem(properties));
    public static final RegistrySupplier<Item> YELLOW_CORE = ItemRegistry.registerItem("yellow_core", properties -> new CoreItem(properties));
    public static final RegistrySupplier<Item> WHITE_CORE = ItemRegistry.registerItem("white_core", properties -> new CoreItem(properties));
    public static final RegistrySupplier<Item> BEE_GUN = ItemRegistry.registerItem("bee_gun", properties -> new BeeGunItem(properties.stacksTo(1)));
    public static final RegistrySupplier<Item> WAND_OF_SPARKING = ItemRegistry.registerItem("wand_of_sparking", properties -> new WandOfSparkingItem(properties.stacksTo(1), 4.0f, 2.0f, 12, 16734492));
    public static final RegistrySupplier<Item> STAR_CANNON = ItemRegistry.registerItem("star_cannon", properties -> new StarCannonItem(properties.stacksTo(1)));
    public static final RegistrySupplier<Item> ECHO_STAFF = ItemRegistry.registerItem("echo_staff", properties -> new GemStaffItem(properties.stacksTo(1).rarity(Rarity.RARE), 10.0f, 10.0f, 5, 737397, GemStaffType.ECHO));
    public static final RegistrySupplier<Item> DIAMOND_STAFF = ItemRegistry.registerItem("diamond_staff", properties -> new GemStaffItem(properties.stacksTo(1).rarity(Rarity.UNCOMMON), 6.0f, 6.0f, 5, 13755391, GemStaffType.DIAMOND));
    public static final RegistrySupplier<Item> EMERALD_STAFF = ItemRegistry.registerItem("emerald_staff", properties -> new GemStaffItem(properties.stacksTo(1).rarity(Rarity.UNCOMMON), 6.0f, 5.0f, 7, 0x94FF99, GemStaffType.EMERALD));
    public static final RegistrySupplier<Item> AMETHYST_STAFF = ItemRegistry.registerItem("amethyst_staff", properties -> new GemStaffItem(properties.stacksTo(1).rarity(Rarity.UNCOMMON), 6.0f, 4.0f, 7, 16152831, GemStaffType.AMETHYST));
    public static final RegistrySupplier<Item> LAPIS_STAFF = ItemRegistry.registerItem("lapis_staff", properties -> new GemStaffItem(properties.stacksTo(1).rarity(Rarity.UNCOMMON), 5.0f, 3.0f, 10, 5870591, GemStaffType.LAPIS));
    public static final RegistrySupplier<Item> REDSTONE_STAFF = ItemRegistry.registerItem("redstone_staff", properties -> new GemStaffItem(properties.stacksTo(1).rarity(Rarity.UNCOMMON), 4.0f, 1.0f, 10, 16736606, GemStaffType.REDSTONE));
    public static final RegistrySupplier<Item> RUNE = ItemRegistry.registerItem("rune", properties -> new RuneItem(properties.rarity(Rarity.UNCOMMON), null));
    public static final RegistrySupplier<Item> ECHO_RUNE = ItemRegistry.registerItem("echo_rune", properties -> new RuneItem(properties.rarity(Rarity.RARE), GemStaffType.ECHO));
    public static final RegistrySupplier<Item> DIAMOND_RUNE = ItemRegistry.registerItem("diamond_rune", properties -> new RuneItem(properties.rarity(Rarity.UNCOMMON), GemStaffType.DIAMOND));
    public static final RegistrySupplier<Item> EMERALD_RUNE = ItemRegistry.registerItem("emerald_rune", properties -> new RuneItem(properties.rarity(Rarity.UNCOMMON), GemStaffType.EMERALD));
    public static final RegistrySupplier<Item> AMETHYST_RUNE = ItemRegistry.registerItem("amethyst_rune", properties -> new RuneItem(properties.rarity(Rarity.UNCOMMON), GemStaffType.AMETHYST));
    public static final RegistrySupplier<Item> LAPIS_RUNE = ItemRegistry.registerItem("lapis_rune", properties -> new RuneItem(properties.rarity(Rarity.UNCOMMON), GemStaffType.LAPIS));
    public static final RegistrySupplier<Item> REDSTONE_RUNE = ItemRegistry.registerItem("redstone_rune", properties -> new RuneItem(properties.rarity(Rarity.UNCOMMON), GemStaffType.REDSTONE));
    public static final RegistrySupplier<Item> ENERGY_CELL = ItemRegistry.registerItem("energy_cell", properties -> new Item(properties));
    public static final RegistrySupplier<Item> FALLEN_STAR = ItemRegistry.registerItem("fallen_star", properties -> new FallenStarItem(properties));
    public static final RegistrySupplier<Item> MANA_CRYSTAL = ItemRegistry.registerItem("mana_crystal", properties -> new ManaCrystalItem(properties));
    public static final RegistrySupplier<Item> RAW_METEORITE = ItemRegistry.registerItem("raw_meteorite", properties -> new Item(properties));
    public static final RegistrySupplier<Item> METEORITE_INGOT = ItemRegistry.registerItem("meteorite_ingot", properties -> new Item(properties));
    public static final RegistrySupplier<Item> METEORITE_NUGGET = ItemRegistry.registerItem("meteorite_nugget", properties -> new Item(properties));
    public static final RegistrySupplier<Item> ZAPINATOR_RESET_SMITHING_TEMPLATE = ItemRegistry.registerItem("zapinator_reset_smithing_template", properties -> new SmithingTemplateItem((Component)Component.translatable((String)"item.zapinators.smithing_template.zapinator_reset.applies_to").withStyle(ChatFormatting.BLUE), (Component)Component.translatable((String)"item.zapinators.smithing_template.zapinator_reset.ingredients").withStyle(ChatFormatting.BLUE), (Component)Component.translatable((String)"item.zapinators.smithing_template.zapinator_reset.base_slot_description"), (Component)Component.translatable((String)"item.zapinators.smithing_template.zapinator_reset.additions_slot_description"), null, null, properties.rarity(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Item> BEE_CORE = ItemRegistry.registerItem("bee_core", properties -> new DescriptionItem(properties, (Component)Component.translatable((String)"item.zapinators.bee_core.description").withStyle(ChatFormatting.GRAY)));
    public static final RegistrySupplier<Item> METEORITE_HELMET = ItemRegistry.registerItem("meteorite_helmet", properties -> new MeteoriteArmorItem(ModArmorMaterials.METEORITE_ARMOR, ArmorType.HELMET, properties));
    public static final RegistrySupplier<Item> METEORITE_CHESTPLATE = ItemRegistry.registerItem("meteorite_chestplate", properties -> new MeteoriteArmorItem(ModArmorMaterials.METEORITE_ARMOR, ArmorType.CHESTPLATE, properties));
    public static final RegistrySupplier<Item> METEORITE_LEGGINGS = ItemRegistry.registerItem("meteorite_leggings", properties -> new MeteoriteArmorItem(ModArmorMaterials.METEORITE_ARMOR, ArmorType.LEGGINGS, properties));
    public static final RegistrySupplier<Item> METEORITE_BOOTS = ItemRegistry.registerItem("meteorite_boots", properties -> new MeteoriteArmorItem(ModArmorMaterials.METEORITE_ARMOR, ArmorType.BOOTS, properties));
    public static final RegistrySupplier<Item> BEE_HELMET = ItemRegistry.registerItem("bee_helmet", properties -> new BeeArmorItem(ModArmorMaterials.BEE_ARMOR, ArmorType.HELMET, properties));
    public static final RegistrySupplier<Item> BEE_CHESTPLATE = ItemRegistry.registerItem("bee_chestplate", properties -> new BeeArmorItem(ModArmorMaterials.BEE_ARMOR, ArmorType.CHESTPLATE, properties));
    public static final RegistrySupplier<Item> BEE_LEGGINGS = ItemRegistry.registerItem("bee_leggings", properties -> new BeeArmorItem(ModArmorMaterials.BEE_ARMOR, ArmorType.LEGGINGS, properties));
    public static final RegistrySupplier<Item> BEE_BOOTS = ItemRegistry.registerItem("bee_boots", properties -> new BeeArmorItem(ModArmorMaterials.BEE_ARMOR, ArmorType.BOOTS, properties));

    public static void register() {
        ITEMS.register();
    }

    public static RegistrySupplier<Item> registerItem(String name) {
        return ItemRegistry.registerItem(name, Item::new);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String name, ItemFactory<T> factory) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"zapinators", (String)name));
        return ITEMS.register(name, () -> factory.create(new Item.Properties().setId(key).arch$tab(TabRegistry.ZAPINATORS_TAB)));
    }

    @FunctionalInterface
    public static interface ItemFactory<T extends Item> {
        public T create(Item.Properties var1);
    }
}

