/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import ydmsama.hundred_years_war.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.commands.ClientCommands;
import ydmsama.hundred_years_war.freecam.Freecam;
import ydmsama.hundred_years_war.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.freecam.config.ModBindings;
import ydmsama.hundred_years_war.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.item.CommandStaffHandler;
import ydmsama.hundred_years_war.models.siege.BombardCartModel;
import ydmsama.hundred_years_war.models.siege.CannonModel;
import ydmsama.hundred_years_war.models.siege.CulverinModel;
import ydmsama.hundred_years_war.models.siege.GreatBombardCartModel;
import ydmsama.hundred_years_war.models.siege.MangonelsCartModel;
import ydmsama.hundred_years_war.models.siege.RibauldequinModel;
import ydmsama.hundred_years_war.models.siege.SpringaldModel;
import ydmsama.hundred_years_war.models.siege.TrebuchetsCartModel;
import ydmsama.hundred_years_war.network.ClientPacketHandler;
import ydmsama.hundred_years_war.registry.HywEntityRenderRegistry;
import ydmsama.hundred_years_war.renderer.blockentity.BaseStructureCoreRenderer;
import ydmsama.hundred_years_war.structure.BuildModeHandler;
import ydmsama.hundred_years_war.structure.BuildModeRenderer;

@Environment(value=EnvType.CLIENT)
public class HundredYearsWarClient
implements ClientModInitializer {
    public void onInitializeClient() {
        CommandRegistrationCallback.EVENT.register((dispatcher, environment, registrationEnvironment) -> ClientCommands.register((CommandDispatcher<class_2168>)dispatcher));
        ClientModConfig.init();
        ModBindings.forEach(KeyBindingHelper::registerKeyBinding);
        HotKeyManager.getInstance().register();
        ClientTickEvents.START_CLIENT_TICK.register(Freecam::preTick);
        ClientTickEvents.END_CLIENT_TICK.register(Freecam::postTick);
        HywEntityRenderRegistry.registerAll();
        ClientPacketHandler.registerClientPackets();
        BuildModeHandler.initialize();
        BuildModeRenderer.initialize();
        BlockEntityRendererRegistry.register(ModBlockEntities.BASE_STRUCTURE_CORE, BaseStructureCoreRenderer::new);
        ClientTickEvents.END_CLIENT_TICK.register(client -> BaseStructureCoreRenderer.clearRenderedEntities());
        ClientTickEvents.END_CLIENT_TICK.register(client -> CommandStaffHandler.getInstance().clientTick());
        CommandWheelHandler.init();
        ClientTickEvents.END_CLIENT_TICK.register(client -> CommandWheelHandler.getInstance().tick());
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> this.clearSiegeModelsCache());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null && client.field_1724 == null) {
                this.clearSiegeModelsCache();
            }
        });
    }

    private void clearSiegeModelsCache() {
        RibauldequinModel.clearUnusedEntities();
        CulverinModel.clearUnusedEntities();
        CannonModel.clearUnusedEntities();
        MangonelsCartModel.clearUnusedEntities();
        TrebuchetsCartModel.clearUnusedEntities();
        BombardCartModel.clearUnusedEntities();
        GreatBombardCartModel.clearUnusedEntities();
        SpringaldModel.clearUnusedEntities();
    }
}

