/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.entities;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.entity.entities.tags.CounterLight;
import ydmsama.hundred_years_war.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.entity.goals.SkyExposedTargetGoal;
import ydmsama.hundred_years_war.entity.utils.Rider;
import ydmsama.hundred_years_war.registry.HywAttributes;
import ydmsama.hundred_years_war.registry.HywItemRegistry;

public class ArcherEntity
extends BaseCombatEntity
implements class_1603,
Rider,
LightUnit,
RangedUnit,
CounterLight {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 2.5f;
    private static final class_2940<Integer> USE_ANGLE = class_2945.method_12791(ArcherEntity.class, (class_2941)class_2943.field_13327);

    public ArcherEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(USE_ANGLE, (Object)1);
    }

    public static class_5132.class_5133 createArcherAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23724, 2.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23718, 0.0).method_26868(HywAttributes.ATTACK_REACH, 100.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 2.5);
    }

    @Override
    public void method_5773() {
        super.method_5773();
    }

    @Override
    protected void setDefaultEquipment() {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
        this.method_5673(class_1304.field_6171, class_1799.field_8037);
        this.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8283));
        this.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8873));
        this.method_5673(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8218));
        this.method_5673(class_1304.field_6166, new class_1799((class_1935)class_1802.field_8313));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 15;
    }

    @Override
    public int getAttackDamageTickDelay() {
        Random random = new Random();
        return Math.max(this.getBaseAttackAnimationTime() - random.nextInt(5), 5);
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 3 + random.nextInt(8);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        double dy;
        double dz;
        double dx;
        double distance;
        class_1665 arrow = class_1675.method_18813((class_1309)this, (class_1799)new class_1799((class_1935)class_1802.field_8107), (float)pullProgress);
        arrow.method_7438(this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE));
        class_1799 bowStack = this.method_5998(class_1268.field_5808);
        int powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)bowStack);
        int punchLevel = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)bowStack);
        int flameLevel = class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)bowStack);
        if (powerLevel > 0) {
            arrow.method_7438(arrow.method_7448() + (double)powerLevel * 0.5 + 0.5);
        }
        if (punchLevel > 0) {
            arrow.method_7449(punchLevel);
        }
        if (flameLevel > 0) {
            arrow.method_5639(100);
        }
        if ((distance = Math.sqrt((dx = target.method_23317() - this.method_23317()) * dx + (dz = target.method_23321() - this.method_23321()) * dz + (dy = target.method_23323(0.5) - arrow.method_23318()) * dy)) == 0.0) {
            return;
        }
        float speed = 2.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float maxArrowSpeed = 3.0f;
        float miss = 2.5f;
        this.setUseAngle(-1);
        while (speed <= maxArrowSpeed) {
            double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
            if (!(this.isObstructed(target) && !this.method_5765() || Double.isNaN(angles[1]) && !(distance < 5.0))) {
                angle = angles[1];
                this.setUseAngle(1);
                break;
            }
            if (!Double.isNaN(angles[0]) && this.isPathClear(arrow, angles[0], speed, dx, dy, dz, distance, target)) {
                angle = angles[0];
                this.setUseAngle(0);
                break;
            }
            if (!((speed += 0.25f) > maxArrowSpeed)) continue;
            break;
        }
        if (this.getUseAngle() == -1) {
            return;
        }
        double randomSpeedOffset = ArcherEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.method_18798().method_10216();
        double targetVelocityZ = target.method_18798().method_10215();
        double predictedX = target.method_23317() + targetVelocityX * timeToTarget;
        double predictedZ = target.method_23321() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - this.method_23317()) * (predictedX - this.method_23317()) + (predictedZ - this.method_23321()) * (predictedZ - this.method_23321()));
        double[] angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
            return;
        }
        angle = angles[this.getUseAngle()];
        dx = predictedX - this.method_23317();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = predictedZ - this.method_23321()) * dz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        if (this.getUseAngle() == 0) {
            miss = 3.5f;
            arrow.method_7438(this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE) * 1.5);
            arrow.method_7438(arrow.method_7448() + (double)powerLevel * 0.5 + 0.5);
        }
        arrow.method_7485((double)velocityX, (double)velocityY, (double)velocityZ, speed, miss);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)arrow);
        this.method_6021();
    }

    private boolean isPathClear(class_1665 arrow, double angle, float speed, double dx, double dy, double dz, double distance, class_1309 target) {
        class_243 startPos = this.method_33571();
        class_243 direction = new class_243(dx / distance, Math.tan(angle), dz / distance).method_1029();
        class_243 endPos = startPos.method_1019(direction.method_1021(5.0));
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)arrow));
        return hitResult.method_17783() == class_239.class_240.field_1333;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(5, (class_1352)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    @Override
    public void addTargetSelector() {
        Predicate<class_1309> unifiedPredicate = this::isValidTarget;
        this.field_6185.method_6277(1, (class_1352)new SkyExposedTargetGoal(this, class_1309.class, 10, true, false, unifiedPredicate));
    }

    public int getUseAngle() {
        return (Integer)this.field_6011.method_12789(USE_ANGLE);
    }

    public void setUseAngle(int useAngle) {
        this.field_6011.method_12778(USE_ANGLE, (Object)useAngle);
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected class_1792 getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> HywItemRegistry.SCROLL_ARCHER;
            case 2 -> HywItemRegistry.SCROLL_ARCHER_1;
            case 3 -> HywItemRegistry.SCROLL_ARCHER_2;
            case 4 -> HywItemRegistry.SCROLL_ARCHER_3;
            default -> null;
        };
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        super.increaseStatsOnLevelUp();
        class_1324 rangedAttackDamage = this.method_5996(HywAttributes.RANGED_ATTACK_DAMAGE);
        if (rangedAttackDamage != null) {
            rangedAttackDamage.method_6192(rangedAttackDamage.method_6201() + 0.1);
        }
    }

    @Override
    public double getLightDamageModifier() {
        return 1.2;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 0.5;
    }
}

