/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.entities.mounted;

import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.config.ServerModConfig;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.entity.entities.UseShield;
import ydmsama.hundred_years_war.entity.entities.mounted.MountedLancerHorseEntity;
import ydmsama.hundred_years_war.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.entity.entities.tags.CounterSiege;
import ydmsama.hundred_years_war.entity.entities.tags.HeavyUnit;
import ydmsama.hundred_years_war.entity.utils.Rider;
import ydmsama.hundred_years_war.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.registry.HywAttributes;
import ydmsama.hundred_years_war.registry.HywItemRegistry;
import ydmsama.hundred_years_war.utils.ServerRelationHelper;
import ydmsama.hundred_years_war.utils.WeaponTypeHelper;

public class MountedLancerRiderEntity
extends BaseCombatEntity
implements Rider,
UseShield,
CavalryUnit,
HeavyUnit,
CounterHeavy,
CounterSiege {
    private static final float ATTACK_REACH = 3.0f;
    private static final float MOVEMENT_SPEED = 0.33f;
    protected static float BASE_CHARGE_SPEED_MULTIPLIER = 0.25f;
    protected static float BASE_CHARGE_DAMAGE_MULTIPLIER = 3.0f;
    protected static float BASE_CHARGE_KNOCKBACK_STRENGTH = 1.5f;
    protected static float MIN_CHARGE_DISTANCE_SQUARED = 25.0f;
    protected static float MAX_CHARGE_DISTANCE_SQUARED = 900.0f;
    protected static int BASE_CHARGE_COOLDOWN_TICKS = 240;
    protected static int BASE_MAX_CHARGE_DURATION_TICKS = 160;
    protected static int BASE_READY_STANCE_DELAY = 40;
    private final Random shieldBlockRandom = new Random();
    protected int chargeCooldownCounter = 0;
    protected int chargeDurationCounter = 0;
    protected int readyStanceCounter = 0;
    protected static final class_2940<class_1799> DATA_CHARGE_WEAPON = class_2945.method_12791(MountedLancerRiderEntity.class, (class_2941)class_2943.field_13322);
    protected static final class_2940<class_1799> DATA_MAIN_WEAPON = class_2945.method_12791(MountedLancerRiderEntity.class, (class_2941)class_2943.field_13322);
    protected static final class_2940<Boolean> DATA_IS_USING_CHARGE_WEAPON = class_2945.method_12791(MountedLancerRiderEntity.class, (class_2941)class_2943.field_13323);

    public MountedLancerRiderEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_CHARGE_WEAPON, (Object)this.getDefaultChargeWeapon());
        this.field_6011.method_12784(DATA_MAIN_WEAPON, (Object)this.getDefaultMainWeapon());
        this.field_6011.method_12784(DATA_IS_USING_CHARGE_WEAPON, (Object)false);
    }

    protected class_1799 getDefaultChargeWeapon() {
        return new class_1799((class_1935)HywItemRegistry.WOODEN_LANCE);
    }

    protected class_1799 getDefaultMainWeapon() {
        return new class_1799((class_1935)class_1802.field_8371);
    }

    public class_1799 getChargeWeapon() {
        return (class_1799)this.field_6011.method_12789(DATA_CHARGE_WEAPON);
    }

    public void setChargeWeapon(class_1799 stack) {
        this.field_6011.method_12778(DATA_CHARGE_WEAPON, (Object)stack);
    }

    public class_1799 getMainWeapon() {
        return (class_1799)this.field_6011.method_12789(DATA_MAIN_WEAPON);
    }

    public void setMainWeapon(class_1799 stack) {
        this.field_6011.method_12778(DATA_MAIN_WEAPON, (Object)stack);
    }

    public boolean isUsingChargeWeapon() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_USING_CHARGE_WEAPON);
    }

    public void setUsingChargeWeapon(boolean usingChargeWeapon) {
        this.field_6011.method_12778(DATA_IS_USING_CHARGE_WEAPON, (Object)usingChargeWeapon);
        this.method_5673(class_1304.field_6173, usingChargeWeapon ? this.getChargeWeapon() : this.getMainWeapon());
    }

    @Override
    protected void setDefaultEquipment() {
        this.setMainWeapon(this.getDefaultMainWeapon());
        this.setChargeWeapon(this.getDefaultChargeWeapon());
        this.setUsingChargeWeapon(false);
        this.method_5673(class_1304.field_6171, new class_1799((class_1935)class_1802.field_8255));
        this.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8743));
        this.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8523));
        this.method_5673(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8396));
        this.method_5673(class_1304.field_6166, new class_1799((class_1935)class_1802.field_8660));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        class_2487 chargeWeaponTag = new class_2487();
        this.getChargeWeapon().method_7953(chargeWeaponTag);
        compound.method_10566("ChargeWeapon", (class_2520)chargeWeaponTag);
        class_2487 mainWeaponTag = new class_2487();
        this.getMainWeapon().method_7953(mainWeaponTag);
        compound.method_10566("MainWeapon", (class_2520)mainWeaponTag);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("ChargeWeapon")) {
            class_2487 chargeWeaponTag = compound.method_10562("ChargeWeapon");
            class_1799 chargeWeaponStack = class_1799.method_7915((class_2487)chargeWeaponTag);
            this.setChargeWeapon(chargeWeaponStack);
        }
        if (compound.method_10545("MainWeapon")) {
            class_2487 mainWeaponTag = compound.method_10562("MainWeapon");
            class_1799 mainWeaponStack = class_1799.method_7915((class_2487)mainWeaponTag);
            this.setMainWeapon(mainWeaponStack);
        }
    }

    @Override
    public void method_5773() {
        HywHorseEntity horse;
        class_1297 class_12972;
        super.method_5773();
        if (!this.method_37908().field_9236 && (class_12972 = this.method_5854()) instanceof HywHorseEntity) {
            horse = (HywHorseEntity)class_12972;
            class_1324 speedAttr = horse.method_5996(class_5134.field_23719);
            if (speedAttr == null) {
                return;
            }
            if (this.isChargingHorse()) {
                speedAttr.method_6192(0.0);
                this.applyChargeImpulse(horse);
            } else {
                speedAttr.method_6192((double)horse.getMOVEMENT_SPEED());
            }
        }
        if (!this.method_37908().field_9236) {
            if (this.chargeCooldownCounter > 0) {
                --this.chargeCooldownCounter;
            } else if (this.getHywTarget() == null) {
                ++this.readyStanceCounter;
                if (this.readyStanceCounter > this.getReadyStanceDelay() && !this.isUsingChargeWeapon() && this.getHywTarget() == null) {
                    this.setUsingChargeWeapon(true);
                }
            } else {
                this.readyStanceCounter = 0;
            }
            if (this.getHywTarget() != null) {
                double distanceToTarget = this.method_5858((class_1297)this.getHywTarget());
                if (!this.isChargingHorse() && distanceToTarget < (double)this.getMinChargeDistanceSquared()) {
                    this.setUsingChargeWeapon(false);
                }
                if (this.canCharge() && !this.isChargingHorse() && this.isFacingTarget(this.getHywTarget(), 10.0f)) {
                    this.startCharge();
                }
            }
            if ((class_12972 = this.method_5854()) instanceof HywHorseEntity && (horse = (HywHorseEntity)class_12972).shouldMoveOnly() && this.isCharging()) {
                this.endCharge(false);
            }
            if (this.isChargingHorse()) {
                ++this.chargeDurationCounter;
                if (this.chargeDurationCounter >= this.getMaxChargeDurationTicks()) {
                    this.endCharge(false);
                } else if (this.getHywTarget() != null && this.method_5858((class_1297)this.getHywTarget()) <= (double)(this.getChargeAttackReach() * this.getChargeAttackReach())) {
                    this.performChargeAttack();
                    this.endCharge(true);
                }
            }
        }
        if ((this.isChargingHorse() || !this.getStartAttacking()) && this.method_5854() != null) {
            this.field_6241 = this.method_5854().method_36454();
        }
    }

    protected float getMinChargeDistanceSquared() {
        return MIN_CHARGE_DISTANCE_SQUARED;
    }

    protected float getMaxChargeDistanceSquared() {
        return MAX_CHARGE_DISTANCE_SQUARED;
    }

    protected int getChargeCooldownTicks() {
        return BASE_CHARGE_COOLDOWN_TICKS;
    }

    protected int getMaxChargeDurationTicks() {
        return BASE_MAX_CHARGE_DURATION_TICKS;
    }

    protected float getChargeSpeedMultiplier() {
        return BASE_CHARGE_SPEED_MULTIPLIER;
    }

    protected float getChargeDamageMultiplier() {
        return 6.0f;
    }

    protected float getChargeKnockbackStrength() {
        return BASE_CHARGE_KNOCKBACK_STRENGTH;
    }

    protected int getReadyStanceDelay() {
        return BASE_READY_STANCE_DELAY;
    }

    public float getChargeAttackReach() {
        class_1324 attackReachAttr = this.method_5996(HywAttributes.ATTACK_REACH);
        float baseReach = attackReachAttr != null ? (float)attackReachAttr.method_6194() : 3.0f;
        return baseReach + 0.5f;
    }

    protected boolean canCharge() {
        BaseCombatEntity vehicle;
        HywHorseEntity horse;
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof HywHorseEntity && (horse = (HywHorseEntity)class_12972).shouldMoveOnly()) {
            return false;
        }
        if (this.chargeCooldownCounter > 0 || this.getHywTarget() == null || !this.isUsingChargeWeapon()) {
            return false;
        }
        if (this.method_5854() != null && (class_12972 = this.method_5854()) instanceof BaseCombatEntity && (vehicle = (BaseCombatEntity)class_12972).isHolding()) {
            return false;
        }
        double distance = this.method_5858((class_1297)this.getHywTarget());
        return distance >= (double)this.getMinChargeDistanceSquared() && distance <= (double)this.getMaxChargeDistanceSquared();
    }

    protected boolean isFacingTarget(class_1309 target, float maxAngle) {
        float yaw = this.method_5854() != null ? this.method_5854().method_36454() : this.method_36454();
        class_243 forward = new class_243((double)(-class_3532.method_15374((float)(yaw * (float)Math.PI / 180.0f))), 0.0, (double)class_3532.method_15362((float)(yaw * (float)Math.PI / 180.0f))).method_1029();
        class_243 toTarget = new class_243(target.method_23317() - this.method_23317(), 0.0, target.method_23321() - this.method_23321()).method_1029();
        double dot = forward.method_1026(toTarget);
        double angle = Math.acos(dot) * 57.29577951308232;
        return angle <= (double)maxAngle;
    }

    protected void startCharge() {
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof HywHorseEntity) {
            HywHorseEntity horse = (HywHorseEntity)class_12972;
            horse.setCharging(true);
        }
        this.chargeDurationCounter = 0;
    }

    protected void performChargeAttack() {
        class_1309 target = this.getHywTarget();
        if (target != null) {
            float weaponDamage = this.getMainHandWeaponDamage();
            float chargeDamage = weaponDamage * this.getChargeDamageMultiplier() + this.getChargeDamageBonus();
            target.method_5643(this.method_48923().method_48812((class_1309)this), chargeDamage);
            target.method_6005((double)this.getChargeKnockbackStrength(), this.method_23317() - target.method_23317(), this.method_23321() - target.method_23321());
        }
    }

    private float getMainHandWeaponDamage() {
        class_1799 mainHandItem = this.method_5998(class_1268.field_5808);
        class_1792 class_17922 = mainHandItem.method_7909();
        if (class_17922 instanceof class_1829) {
            class_1829 swordItem = (class_1829)class_17922;
            return swordItem.method_8020();
        }
        return (float)this.method_26825(class_5134.field_23721);
    }

    private float getChargeDamageBonus() {
        return (float)(this.getEquipmentLevel() - 1) * 0.5f;
    }

    protected void endCharge(boolean attacked) {
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof HywHorseEntity) {
            HywHorseEntity horse = (HywHorseEntity)class_12972;
            horse.setCharging(false);
        }
        this.chargeCooldownCounter = this.getChargeCooldownTicks();
        this.chargeDurationCounter = 0;
        this.setUsingChargeWeapon(false);
    }

    public boolean isCharging() {
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof HywHorseEntity) {
            HywHorseEntity horse = (HywHorseEntity)class_12972;
            return horse.isCharging();
        }
        return false;
    }

    private boolean isChargingHorse() {
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof HywHorseEntity) {
            HywHorseEntity horse = (HywHorseEntity)class_12972;
            return horse.isCharging();
        }
        return false;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 12;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 3 + random.nextInt(8);
    }

    protected void method_6060(class_1309 livingEntity) {
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.0f));
        super.method_5959();
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        class_1324 attackDamage;
        super.increaseStatsOnLevelUp();
        class_1324 maxHealth = this.method_5996(class_5134.field_23716);
        if (maxHealth != null) {
            maxHealth.method_6192(maxHealth.method_6201() + 2.0);
            this.method_6025(2.0f);
        }
        if ((attackDamage = this.method_5996(class_5134.field_23721)) != null) {
            attackDamage.method_6192(attackDamage.method_6201() + 0.2);
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972;
        class_1297 entity;
        if (this.method_6118(class_1304.field_6171).method_7909() instanceof class_1819 && this.method_6115() && this.shieldBlockRandom.nextInt(100) < 50) {
            amount *= 0.2f;
            this.method_5783(class_3417.field_15150, this.method_6107(), this.method_6017());
        }
        if ((entity = source.method_5526()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            this.method_6090(livingEntity);
        }
        if ((class_12972 = source.method_5529()) instanceof class_1657 && (player = (class_1657)class_12972).method_5715() && (ServerRelationHelper.hasControlOver(player, (class_1297)this) || player.method_7337()) && ServerModConfig.INSTANCE.isAllowEquipmentChange()) {
            class_1799 playerItem = player.method_5998(class_1268.field_5808);
            if (WeaponTypeHelper.isLanceLikeWeapon(playerItem)) {
                class_1799 entityItem = this.getChargeWeapon();
                this.setChargeWeapon(playerItem.method_7972());
                if (this.isUsingChargeWeapon()) {
                    this.method_5673(class_1304.field_6173, playerItem.method_7972());
                }
                player.method_6122(class_1268.field_5808, class_1799.field_8037);
                if (!entityItem.method_7960()) {
                    player.method_6122(class_1268.field_5808, entityItem);
                }
                return false;
            }
            if (WeaponTypeHelper.isSwordLikeWeapon(playerItem)) {
                class_1799 entityItem = this.getMainWeapon();
                this.setMainWeapon(playerItem.method_7972());
                if (!this.isUsingChargeWeapon()) {
                    this.method_5673(class_1304.field_6173, playerItem.method_7972());
                }
                player.method_6122(class_1268.field_5808, class_1799.field_8037);
                if (!entityItem.method_7960()) {
                    player.method_6122(class_1268.field_5808, entityItem);
                }
                return false;
            }
        }
        return super.method_5643(source, amount);
    }

    protected boolean isChargeWeaponItem(class_1799 stack) {
        return WeaponTypeHelper.isLanceLikeWeapon(stack);
    }

    public static class_5132.class_5133 createMountedLancerRiderAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 30.0).method_26868(class_5134.field_23719, (double)0.33f).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23724, 2.0).method_26868(class_5134.field_23716, 34.0).method_26868(class_5134.field_23718, 0.5).method_26868(HywAttributes.ATTACK_REACH, 3.0);
    }

    @Override
    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        super.setEquipmentFromLevelData(levelData);
        this.loadWeaponsFromLevelData(levelData);
    }

    protected void loadWeaponsFromLevelData(EquipmentLevelData levelData) {
        EquipmentOption chargeWeaponOption = this.selectRandomItem(levelData.getLanceWeapon());
        class_1799 chargeWeaponStack = this.createItemStack(chargeWeaponOption);
        this.setChargeWeapon(chargeWeaponStack);
        EquipmentOption mainWeaponOption = this.selectRandomItem(levelData.getMainWeapon());
        class_1799 mainWeaponStack = this.createItemStack(mainWeaponOption);
        this.setMainWeapon(mainWeaponStack);
    }

    @Override
    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (player.method_5715() && hand == class_1268.field_5808) {
            class_1297 vehicle = this.method_5854();
            if (vehicle instanceof MountedLancerHorseEntity) {
                MountedLancerHorseEntity horse = (MountedLancerHorseEntity)vehicle;
                return horse.method_5992(player, hand);
            }
            return class_1269.field_5811;
        }
        return super.method_5992(player, hand);
    }

    protected void applyChargeImpulse(HywHorseEntity horse) {
        double deltaZ;
        double deltaX;
        double distance;
        if (!horse.method_24828()) {
            return;
        }
        class_1309 target = this.getHywTarget();
        if (target != null && (distance = Math.sqrt((deltaX = target.method_23317() - horse.method_23317()) * deltaX + (deltaZ = target.method_23321() - horse.method_23321()) * deltaZ)) > 0.0) {
            deltaX = deltaX / distance * (double)this.getChargeSpeedMultiplier();
            deltaZ = deltaZ / distance * (double)this.getChargeSpeedMultiplier();
            horse.method_5762(deltaX, 0.0, deltaZ);
        }
    }

    @Override
    public double getLightDamageModifier() {
        return 1.0;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 1.5;
    }

    @Override
    public double getSiegeDamageModifier() {
        return 1.2;
    }
}

