/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.entities.projectile;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import ydmsama.hundred_years_war.entity.entities.projectile.BlockBreakable;
import ydmsama.hundred_years_war.utils.BlockBreakHandler;

public class TrebuchetsBulletEntity
extends class_1665
implements BlockBreakable {
    private boolean canBreakBlocks = false;
    private float breakRadius = 3.0f;
    private float maxBreakableHardness = 30.0f;
    private int maxBreakableBlocks = 15;
    private float baseBreakProbability = 1.0f;

    public TrebuchetsBulletEntity(class_1299<? extends TrebuchetsBulletEntity> entityType, class_1309 livingEntity, class_1937 level) {
        super(entityType, livingEntity, level);
    }

    public TrebuchetsBulletEntity(class_1299<TrebuchetsBulletEntity> TrebuchetsBulletEntityEntityType, class_1937 level) {
        super(TrebuchetsBulletEntityEntityType, level);
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, false, class_1937.class_7867.field_40888);
            this.applyAreaDamage();
            if (this.canBreakBlocks) {
                class_243 pos = new class_243(this.method_23317(), this.method_23318(), this.method_23321());
                BlockBreakHandler.getInstance().handleBlockBreaking((class_1676)this, this.method_37908(), pos);
            }
            if (this.method_37908() instanceof class_3218) {
                this.sendParticlesToAllNearby((class_3218)this.method_37908(), class_2398.field_11221, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.1);
            }
            this.method_31472();
        }
    }

    private void applyAreaDamage() {
        double damageRadius = 10.0;
        float damageAmount = (float)this.method_7448() * 0.1f;
        class_238 damageArea = new class_238(this.method_23317() - damageRadius, this.method_23318() - damageRadius, this.method_23321() - damageRadius, this.method_23317() + damageRadius, this.method_23318() + damageRadius, this.method_23321() + damageRadius);
        class_6880.class_6883 explosionDamageType = this.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42331);
        class_1282 damageSource = new class_1282((class_6880)explosionDamageType, this.method_24921(), (class_1297)this);
        for (class_1297 entity : this.method_37908().method_8335((class_1297)this, damageArea)) {
            if (!(entity instanceof class_1309) || entity == this.method_24921()) continue;
            entity.method_5643(damageSource, damageAmount);
        }
    }

    public void method_5773() {
        super.method_5773();
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
    }

    protected class_1799 method_7445() {
        return null;
    }

    protected class_3414 method_7440() {
        return class_3417.field_14927;
    }

    public <T extends class_2394> int sendParticlesToAllNearby(class_3218 serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        class_2675 packet = new class_2675(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (class_3222 serverPlayer : serverLevel.method_18456()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (class_2596<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(class_3218 serverLevel, class_3222 serverPlayer, double x, double y, double z, class_2596<?> packet) {
        if (serverPlayer.method_37908() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.method_19538().method_1025(new class_243(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.field_13987.method_14364(packet);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBreakBlocks() {
        return this.canBreakBlocks;
    }

    @Override
    public void setCanBreakBlocks(boolean canBreak) {
        this.canBreakBlocks = canBreak;
    }

    @Override
    public float getBreakRadius() {
        return this.breakRadius;
    }

    @Override
    public float getMaxBreakableHardness() {
        return this.maxBreakableHardness;
    }

    @Override
    public int getMaxBreakableBlocks() {
        return this.maxBreakableBlocks;
    }

    @Override
    public float getBaseBreakProbability() {
        return this.baseBreakProbability;
    }
}

