/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.entities.siege;

import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.entity.entities.projectile.SpringaldBulletEntity;
import ydmsama.hundred_years_war.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.registry.HywAttributes;
import ydmsama.hundred_years_war.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.registry.HywItemRegistry;

public class SpringaldEntity
extends BaseCombatEntity
implements class_1603,
SiegeUnit {
    private static final float ATTACK_REACH = 64.0f;
    private static final float MOVEMENT_SPEED = 0.22f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 5.0f;
    private float leftWheelRotation;
    private float rightWheelRotation;
    private static final class_2940<Boolean> SHOW_BULLETS = class_2945.method_12791(SpringaldEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2338> TARGET_POS = class_2945.method_12791(SpringaldEntity.class, (class_2941)class_2943.field_13324);
    private int bulletHideTimer = 0;

    public SpringaldEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
        this.field_6011.method_12784(TARGET_POS, (Object)class_2338.field_10980);
        this.field_6011.method_12784(SHOW_BULLETS, (Object)true);
    }

    public static class_5132.class_5133 createSpringaldAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_23719, (double)0.22f).method_26868(class_5134.field_23721, 12.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23718, 1.0).method_26868(HywAttributes.ATTACK_REACH, 64.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 5.0);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.bulletHideTimer > 0) {
            --this.bulletHideTimer;
            if (this.bulletHideTimer == 0 && !this.method_37908().field_9236) {
                this.setShowBullets(true);
            }
        }
        if (!this.method_37908().field_9236) {
            if (this.getHywTarget() != null) {
                this.setTargetPosition(this.getHywTarget().method_24515());
            } else {
                this.setTargetPosition(class_2338.field_10980);
            }
        }
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 60;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 2;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return random.nextInt(20);
    }

    @Override
    public float getRotationLimit() {
        return 1.5f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    @Override
    public double getDesiredDistance() {
        return 2.5;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        if (!this.canFireAtTarget(target)) {
            return;
        }
        SpringaldBulletEntity bullet = new SpringaldBulletEntity(HywEntityRegistry.SPRINGALD_BULLET_ENTITY, (class_1309)this, this.method_37908());
        bullet.method_7438(this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE));
        bullet.method_7451((byte)3);
        bullet.method_7444(class_3417.field_15213);
        bullet.field_7572 = class_1665.class_1666.field_7592;
        bullet.method_5875(false);
        bullet.method_7439(false);
        bullet.method_7449(0);
        float yBodyRot = this.getTrueYBodyRot() + 90.0f;
        double offsetX = Math.cos(Math.toRadians(yBodyRot)) * 2.5;
        double offsetZ = Math.sin(Math.toRadians(yBodyRot)) * 2.5;
        bullet.method_5814(this.method_23317() + offsetX, this.method_23318(), this.method_23321() + offsetZ);
        bullet.method_33574(bullet.method_19538().method_1019(new class_243(0.0, 1.5, 0.0)));
        double dx = target.method_23317() - bullet.method_23317();
        double dz = target.method_23321() - bullet.method_23321();
        double dy = target.method_23323(0.5) - bullet.method_23318();
        double distance = Math.sqrt(dx * dx + dz * dz + dy * dy);
        if (distance == 0.0) {
            return;
        }
        float speed = 4.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float miss = 1.5f;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        angle = angles[1];
        if (Double.isNaN(angle)) {
            return;
        }
        double randomSpeedOffset = SpringaldEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.method_18798().method_10216();
        double targetVelocityZ = target.method_18798().method_10215();
        double predictedX = target.method_23317() + targetVelocityX * timeToTarget;
        double predictedZ = target.method_23321() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - bullet.method_23317()) * (predictedX - bullet.method_23317()) + (predictedZ - bullet.method_23321()) * (predictedZ - bullet.method_23321()));
        angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
            return;
        }
        angle = angles[1];
        dx = predictedX - this.method_23317();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = predictedZ - this.method_23321()) * dz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        bullet.method_7485(velocityX, velocityY, velocityZ, speed, miss);
        this.method_5783(class_3417.field_15001, 5.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)bullet);
        this.setShowBullets(false);
        this.bulletHideTimer = 80;
        this.method_6021();
    }

    @Override
    public boolean canFireAtTarget(class_1309 target) {
        if (this.isObstructed(target)) {
            return false;
        }
        float allowedRotationDifference = 15.0f;
        double dx = target.method_23317() - this.method_23317();
        double dz = target.method_23321() - this.method_23321();
        float actualTargetRot = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float actualRotDifference = class_3532.method_15393((float)(actualTargetRot - this.currentRot));
        float rotationDifference = class_3532.method_15393((float)(this.targetRot - this.currentRot));
        return Math.abs(rotationDifference) <= allowedRotationDifference && Math.abs(actualRotDifference) <= allowedRotationDifference;
    }

    private boolean isPathClear(class_1665 arrow, double angle, float speed, double dx, double dy, double dz, double distance, class_1309 target) {
        class_243 startPos = this.method_33571();
        class_243 direction = new class_243(dx / distance, Math.tan(angle), dz / distance).method_1029();
        class_243 endPos = startPos.method_1019(direction.method_1021(5.0));
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)arrow));
        return hitResult.method_17783() == class_239.class_240.field_1333;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 20.0, 25.0, 50.0));
        this.field_6201.method_6277(2, (class_1352)new BaseCombatEntityAttackGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new PatrolGoal(this, 1.0, 40));
        this.field_6201.method_6277(3, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.field_6201.method_6277(4, (class_1352)new ReturnToHomeGoal(this, 1.0));
        super.addTargetSelector();
    }

    @Override
    public boolean isValidTarget(class_1309 potentialTarget) {
        if (this.isObstructed(potentialTarget)) {
            return false;
        }
        double minimumAttackDistance = 5.0;
        double allowedVerticalDistance = 30.0;
        double distanceToTarget = this.method_5649(potentialTarget.method_23317(), potentialTarget.method_23318(), potentialTarget.method_23321());
        if (distanceToTarget < minimumAttackDistance * minimumAttackDistance) {
            return false;
        }
        double verticalDistance = Math.abs(potentialTarget.method_23318() - this.method_23318());
        if (verticalDistance > allowedVerticalDistance) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    public void setTargetPosition(class_2338 pos) {
        this.field_6011.method_12778(TARGET_POS, (Object)pos);
    }

    @Override
    public float getCurrentRot() {
        return this.currentRot;
    }

    @Override
    public float getTargetRot() {
        return this.targetRot;
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("ShowBullets", this.shouldShowBullets());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("ShowBullets")) {
            this.setShowBullets(compound.method_10577("ShowBullets"));
        }
    }

    public float getLeftWheelRotation() {
        return this.leftWheelRotation;
    }

    public void setLeftWheelRotation(float leftWheelRotation) {
        this.leftWheelRotation = leftWheelRotation;
    }

    public float getRightWheelRotation() {
        return this.rightWheelRotation;
    }

    public void setRightWheelRotation(float rightWheelRotation) {
        this.rightWheelRotation = rightWheelRotation;
    }

    @Override
    protected class_1792 getScrollType() {
        return HywItemRegistry.SPRINGALD;
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    public boolean shouldShowBullets() {
        return (Boolean)this.field_6011.method_12789(SHOW_BULLETS);
    }

    public void setShowBullets(boolean showBullets) {
        this.field_6011.method_12778(SHOW_BULLETS, (Object)showBullets);
    }
}

