/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.utils;

import java.util.LinkedList;
import java.util.Queue;
import ydmsama.hundred_years_war.entity.utils.PathingTask;

public class PathingTaskManager {
    private Queue<PathingTask> taskQueue = new LinkedList<PathingTask>();
    private int maxTasksPerTick;

    public PathingTaskManager(int maxTasksPerTick) {
        this.maxTasksPerTick = maxTasksPerTick;
    }

    public void addTask(PathingTask task) {
        this.taskQueue.offer(task);
    }

    public void executeTasks() {
        int tasksThisTick = 0;
        while (!this.taskQueue.isEmpty() && tasksThisTick < this.maxTasksPerTick) {
            PathingTask task = this.taskQueue.poll();
            if (task == null) continue;
            task.execute();
            ++tasksThisTick;
        }
    }

    public void clearTasks() {
        this.taskQueue.clear();
    }
}

