/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ClientModConfig {
    private static final String CONFIG_FILE = "config/hundredyearswar/hyw_freecam.json5";
    public static ClientModConfig INSTANCE;
    private static final Gson GSON;
    public MovementConfig movement = new MovementConfig();
    public CollisionConfig collision = new CollisionConfig();
    public VisualConfig visual = new VisualConfig();
    public UtilityConfig utility = new UtilityConfig();
    public NotificationConfig notification = new NotificationConfig();
    public ServersConfig servers = new ServersConfig();
    public KeyBindingsConfig keyBindings = new KeyBindingsConfig();

    public static void init() {
        ClientModConfig.load();
    }

    public static void load() {
        File file = new File(CONFIG_FILE);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                int length;
                StringBuilder content = new StringBuilder();
                char[] buffer = new char[1024];
                while ((length = reader.read(buffer)) != -1) {
                    content.append(buffer, 0, length);
                }
                String jsonContent = content.toString().replaceAll("//.*", "").replaceAll("([a-zA-Z_][a-zA-Z0-9_]*):", "\"$1\":").replaceAll(",\\s*}", "}");
                INSTANCE = (ClientModConfig)GSON.fromJson(jsonContent, ClientModConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                INSTANCE = new ClientModConfig();
            }
        } else {
            INSTANCE = new ClientModConfig();
            ClientModConfig.save();
        }
    }

    public static void save() {
        File file = new File(CONFIG_FILE);
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            writer.write("// FreeCam Client Configuration\n");
            writer.write("// This file controls the behavior of the FreeCam feature\n");
            writer.write("{\n");
            writer.write("  // Movement settings\n");
            writer.write("  \"movement\": {\n");
            writer.write("    \"flightMode\": \"" + ClientModConfig.INSTANCE.movement.flightMode + "\",\n");
            writer.write("    \"horizontalSpeed\": " + ClientModConfig.INSTANCE.movement.horizontalSpeed + ",\n");
            writer.write("    \"verticalSpeed\": " + ClientModConfig.INSTANCE.movement.verticalSpeed + "\n");
            writer.write("  },\n\n");
            writer.write("  // Collision settings\n");
            writer.write("  \"collision\": {\n");
            writer.write("    \"ignoreTransparent\": " + ClientModConfig.INSTANCE.collision.ignoreTransparent + ",\n");
            writer.write("    \"ignoreOpenable\": " + ClientModConfig.INSTANCE.collision.ignoreOpenable + ",\n");
            writer.write("    \"ignoreCustom\": " + ClientModConfig.INSTANCE.collision.ignoreCustom + ",\n");
            writer.write("    \"whitelist\": {\n");
            writer.write("      \"ids\": " + GSON.toJson(ClientModConfig.INSTANCE.collision.whitelist.ids) + ",\n");
            writer.write("      \"patterns\": " + GSON.toJson(ClientModConfig.INSTANCE.collision.whitelist.patterns) + "\n");
            writer.write("    },\n");
            writer.write("    \"ignoreAll\": " + ClientModConfig.INSTANCE.collision.ignoreAll + ",\n");
            writer.write("    \"alwaysCheck\": " + ClientModConfig.INSTANCE.collision.alwaysCheck + "\n");
            writer.write("  },\n\n");
            writer.write("  // Visual settings\n");
            writer.write("  \"visual\": {\n");
            writer.write("    \"showPlayer\": " + ClientModConfig.INSTANCE.visual.showPlayer + ",\n");
            writer.write("    \"showHand\": " + ClientModConfig.INSTANCE.visual.showHand + ",\n");
            writer.write("    \"fullBright\": " + ClientModConfig.INSTANCE.visual.fullBright + ",\n");
            writer.write("    \"showSubmersion\": " + ClientModConfig.INSTANCE.visual.showSubmersion + ",\n");
            writer.write("    \"playerRenderMinDistance\": " + ClientModConfig.INSTANCE.visual.playerRenderMinDistance + "\n");
            writer.write("  },\n\n");
            writer.write("  // Utility settings\n");
            writer.write("  \"utility\": {\n");
            writer.write("    \"disableOnDamage\": " + ClientModConfig.INSTANCE.utility.disableOnDamage + ",\n");
            writer.write("    \"freezePlayer\": " + ClientModConfig.INSTANCE.utility.freezePlayer + ",\n");
            writer.write("    \"allowInteract\": " + ClientModConfig.INSTANCE.utility.allowInteract + ",\n");
            writer.write("    \"interactionMode\": \"" + ClientModConfig.INSTANCE.utility.interactionMode + "\"\n");
            writer.write("  },\n\n");
            writer.write("  // Notification settings\n");
            writer.write("  \"notification\": {\n");
            writer.write("    \"notifyFreecam\": " + ClientModConfig.INSTANCE.notification.notifyFreecam + ",\n");
            writer.write("    \"notifyTripod\": " + ClientModConfig.INSTANCE.notification.notifyTripod + "\n");
            writer.write("  },\n\n");
            writer.write("  // Server restriction settings\n");
            writer.write("  \"servers\": {\n");
            writer.write("    \"mode\": \"" + ClientModConfig.INSTANCE.servers.mode + "\",\n");
            writer.write("    \"whitelist\": " + GSON.toJson(ClientModConfig.INSTANCE.servers.whitelist) + ",\n");
            writer.write("    \"blacklist\": " + GSON.toJson(ClientModConfig.INSTANCE.servers.blacklist) + "\n");
            writer.write("  },\n\n");
            writer.write("  // Key binding settings\n");
            writer.write("  \"keyBindings\": {\n");
            writer.write("    \"toggleKey\": " + ClientModConfig.INSTANCE.keyBindings.toggleKey + ",\n");
            writer.write("    \"tripodResetKey\": " + ClientModConfig.INSTANCE.keyBindings.tripodResetKey + "\n");
            writer.write("  }\n");
            writer.write("}\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    @Environment(value=EnvType.CLIENT)
    public static class MovementConfig {
        public FlightMode flightMode = FlightMode.DEFAULT;
        public double horizontalSpeed = 1.0;
        public double verticalSpeed = 1.0;
    }

    @Environment(value=EnvType.CLIENT)
    public static class CollisionConfig {
        public boolean ignoreTransparent = true;
        public boolean ignoreOpenable = true;
        public boolean ignoreCustom = true;
        public CollisionWhitelist whitelist = new CollisionWhitelist();
        public boolean ignoreAll = false;
        public boolean alwaysCheck = true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class VisualConfig {
        public boolean showPlayer = true;
        public boolean showHand = false;
        public boolean fullBright = false;
        public boolean showSubmersion = true;
        public double playerRenderMinDistance = 2.0;
    }

    @Environment(value=EnvType.CLIENT)
    public static class UtilityConfig {
        public boolean disableOnDamage = false;
        public boolean freezePlayer = false;
        public boolean allowInteract = false;
        public InteractionMode interactionMode = InteractionMode.CAMERA;
    }

    @Environment(value=EnvType.CLIENT)
    public static class NotificationConfig {
        public boolean notifyFreecam = true;
        public boolean notifyTripod = true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ServersConfig {
        public ServerRestriction mode = ServerRestriction.NONE;
        public List<String> whitelist = new ArrayList<String>();
        public List<String> blacklist = new ArrayList<String>();
    }

    @Environment(value=EnvType.CLIENT)
    public static class KeyBindingsConfig {
        public int toggleKey = 293;
        public int tripodResetKey = -1;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum FlightMode {
        CREATIVE,
        DEFAULT;

    }

    @Environment(value=EnvType.CLIENT)
    public static class CollisionWhitelist {
        public List<String> ids = new ArrayList<String>();
        public List<String> patterns = new ArrayList<String>();
    }

    @Environment(value=EnvType.CLIENT)
    public static enum InteractionMode {
        CAMERA,
        PLAYER;

    }

    @Environment(value=EnvType.CLIENT)
    public static enum ServerRestriction {
        NONE,
        WHITELIST,
        BLACKLIST;

    }

    @Environment(value=EnvType.CLIENT)
    public static enum Perspective {
        FIRST_PERSON,
        THIRD_PERSON,
        THIRD_PERSON_MIRROR,
        INSIDE;

    }
}

