/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.selection;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_746;
import ydmsama.hundred_years_war.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.freecam.Freecam;
import ydmsama.hundred_years_war.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.freecam.selection.TargetInfo;

@Environment(value=EnvType.CLIENT)
public class ClientPuppetStateHandler {
    private static final Map<UUID, Boolean> playerPuppetSelectionStates = new HashMap<UUID, Boolean>();
    private static final Map<UUID, PuppetTargetState> playerPuppetTargetStates = new HashMap<UUID, PuppetTargetState>();

    public static void savePuppetSelectionState() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        UUID playerUUID = player.method_5667();
        IPuppet playerPuppet = ClientPuppetStateHandler.findPlayerPuppet(playerUUID);
        if (playerPuppet == null) {
            return;
        }
        class_1297 puppetEntity = (class_1297)playerPuppet;
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        boolean puppetSelected = false;
        for (class_1297 selectedEntity : selectionHandler.getSelectedEntities()) {
            if (selectedEntity != puppetEntity) continue;
            puppetSelected = true;
            break;
        }
        if (puppetSelected) {
            playerPuppetSelectionStates.put(playerUUID, true);
        } else {
            playerPuppetSelectionStates.remove(playerUUID);
        }
        ClientPuppetStateHandler.savePuppetTargetState(playerUUID, puppetEntity, selectionHandler);
    }

    private static void savePuppetTargetState(UUID playerUUID, class_1297 puppetEntity, SelectionHandler selectionHandler) {
        CopyOnWriteArraySet<TargetInfo> targetInfos = selectionHandler.getCombinedTargetMap().get(puppetEntity);
        CopyOnWriteArrayList<class_2338> patrolPoints = selectionHandler.getPatrolPointsMap().get(puppetEntity);
        class_2338 bombardTarget = selectionHandler.getBombardTargetMap().get(puppetEntity);
        if (targetInfos != null && !targetInfos.isEmpty() || patrolPoints != null && !patrolPoints.isEmpty() || bombardTarget != null) {
            PuppetTargetState targetState = new PuppetTargetState(targetInfos, patrolPoints, bombardTarget);
            playerPuppetTargetStates.put(playerUUID, targetState);
        } else {
            playerPuppetTargetStates.remove(playerUUID);
        }
    }

    public static void restorePuppetSelectionState() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        UUID playerUUID = player.method_5667();
        IPuppet playerPuppet = ClientPuppetStateHandler.findPlayerPuppet(playerUUID);
        if (playerPuppet == null) {
            return;
        }
        class_1297 puppetEntity = (class_1297)playerPuppet;
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        boolean restoredAny = false;
        Boolean wasSelected = playerPuppetSelectionStates.get(playerUUID);
        if (wasSelected != null && wasSelected.booleanValue() && !selectionHandler.getSelectedEntities().contains(puppetEntity)) {
            selectionHandler.getSelectedEntities().add(puppetEntity);
            restoredAny = true;
        }
        boolean restoredTargets = ClientPuppetStateHandler.restorePuppetTargetState(playerUUID, puppetEntity, selectionHandler);
        boolean bl = restoredAny = restoredAny || restoredTargets;
        if (restoredAny && wasSelected != null && wasSelected.booleanValue()) {
            playerPuppetSelectionStates.remove(playerUUID);
        }
    }

    private static boolean restorePuppetTargetState(UUID playerUUID, class_1297 puppetEntity, SelectionHandler selectionHandler) {
        class_2338 existingBombardTarget;
        CopyOnWriteArrayList<class_2338> existingPatrolPoints;
        CopyOnWriteArraySet<TargetInfo> existingTargets;
        PuppetTargetState targetState = playerPuppetTargetStates.get(playerUUID);
        if (targetState == null) {
            return false;
        }
        boolean restoredAny = false;
        if (!targetState.targetInfos.isEmpty() && ((existingTargets = selectionHandler.getCombinedTargetMap().get(puppetEntity)) == null || existingTargets.isEmpty())) {
            selectionHandler.getCombinedTargetMap().put(puppetEntity, new CopyOnWriteArraySet<TargetInfo>(targetState.targetInfos));
            restoredAny = true;
        }
        if (!targetState.patrolPoints.isEmpty() && ((existingPatrolPoints = selectionHandler.getPatrolPointsMap().get(puppetEntity)) == null || existingPatrolPoints.isEmpty())) {
            selectionHandler.getPatrolPointsMap().put(puppetEntity, new CopyOnWriteArrayList<class_2338>(targetState.patrolPoints));
            restoredAny = true;
        }
        if (targetState.bombardTarget != null && (existingBombardTarget = selectionHandler.getBombardTargetMap().get(puppetEntity)) == null) {
            selectionHandler.getBombardTargetMap().put(puppetEntity, targetState.bombardTarget);
            restoredAny = true;
        }
        if (restoredAny) {
            playerPuppetTargetStates.remove(playerUUID);
        }
        return restoredAny;
    }

    public static void checkAndRestorePuppetSelection() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null || !Freecam.isEnabled()) {
            return;
        }
        UUID playerUUID = player.method_5667();
        if (!playerPuppetSelectionStates.containsKey(playerUUID) && !playerPuppetTargetStates.containsKey(playerUUID)) {
            return;
        }
        ClientPuppetStateHandler.restorePuppetSelectionState();
    }

    private static IPuppet findPlayerPuppet(UUID playerUUID) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return null;
        }
        for (class_1297 entity : mc.field_1687.method_18112()) {
            IPuppet puppet;
            if (!(entity instanceof IPuppet) || !playerUUID.equals((puppet = (IPuppet)entity).getOwnerUUID())) continue;
            return puppet;
        }
        return null;
    }

    public static void clearPlayerState(UUID playerUUID) {
        playerPuppetSelectionStates.remove(playerUUID);
        playerPuppetTargetStates.remove(playerUUID);
    }

    public static void clearAllStates() {
        playerPuppetSelectionStates.clear();
        playerPuppetTargetStates.clear();
    }

    public static boolean hasSavedSelectionState(UUID playerUUID) {
        return playerPuppetSelectionStates.containsKey(playerUUID);
    }

    public static boolean hasSavedTargetState(UUID playerUUID) {
        return playerPuppetTargetStates.containsKey(playerUUID);
    }

    public static boolean hasSavedState(UUID playerUUID) {
        return ClientPuppetStateHandler.hasSavedSelectionState(playerUUID) || ClientPuppetStateHandler.hasSavedTargetState(playerUUID);
    }

    @Environment(value=EnvType.CLIENT)
    private static class PuppetTargetState {
        public final CopyOnWriteArraySet<TargetInfo> targetInfos;
        public final CopyOnWriteArrayList<class_2338> patrolPoints;
        public final class_2338 bombardTarget;

        public PuppetTargetState(CopyOnWriteArraySet<TargetInfo> targetInfos, CopyOnWriteArrayList<class_2338> patrolPoints, class_2338 bombardTarget) {
            this.targetInfos = targetInfos != null ? new CopyOnWriteArraySet<TargetInfo>(targetInfos) : new CopyOnWriteArraySet();
            this.patrolPoints = patrolPoints != null ? new CopyOnWriteArrayList<class_2338>(patrolPoints) : new CopyOnWriteArrayList();
            this.bombardTarget = bombardTarget;
        }
    }
}

