/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.ui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import ydmsama.hundred_years_war.entity.action.Action;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.freecam.selection.SelectionHandler;

@Environment(value=EnvType.CLIENT)
public class ActionDisplayHandler {
    private static ActionDisplayHandler instance;
    private static final int PADDING = 5;
    private static final int ITEM_HEIGHT = 12;
    private static final int BACKGROUND_COLOR = Integer.MIN_VALUE;

    private ActionDisplayHandler() {
    }

    public static ActionDisplayHandler getInstance() {
        if (instance == null) {
            instance = new ActionDisplayHandler();
        }
        return instance;
    }

    private class_304 getKeyMappingById(String keyBindingId) {
        if (keyBindingId == null || keyBindingId.isEmpty()) {
            return null;
        }
        switch (keyBindingId) {
            case "key.hyw.attackCommand": {
                return HotKeyManager.getAttackCommandKey();
            }
            case "key.hyw.holdToggle": {
                return HotKeyManager.getHoldCommandKey();
            }
            case "key.hyw.patrolToggle": {
                return HotKeyManager.getPatrolToggleKey();
            }
            case "key.hyw.cancelCommand": {
                return HotKeyManager.getCancelCommandKey();
            }
            case "key.hyw.siegeModeToggle": {
                return HotKeyManager.getSiegeModeToggleKey();
            }
            case "key.hyw.bombardPosition": {
                return HotKeyManager.getBombardPositionKey();
            }
        }
        return null;
    }

    private String getTranslationKey(String actionName) {
        return "action.hundred_years_war." + actionName.toLowerCase();
    }

    private class_2561 getFormattedDescriptionComponent(Action action) {
        class_304 keyMapping = this.getKeyMappingById(action.getKeyBindingId());
        String keyName = keyMapping != null ? keyMapping.method_16007().getString() : "";
        class_5250 actionNameComponent = class_2561.method_43471((String)this.getTranslationKey(action.getName()));
        if (action.isToggleAction()) {
            String stateKey = action.getCurrentState() ? "action.hundred_years_war.state.on" : "action.hundred_years_war.state.off";
            class_5250 stateComponent = class_2561.method_43471((String)stateKey).method_27692(action.getCurrentState() ? class_124.field_1060 : class_124.field_1061);
            return class_2561.method_43469((String)"action.hundred_years_war.format.toggle", (Object[])new Object[]{actionNameComponent, keyName, stateComponent});
        }
        return class_2561.method_43469((String)"action.hundred_years_war.format.basic", (Object[])new Object[]{actionNameComponent, keyName});
    }

    public void renderActionList(class_332 guiGraphics) {
        class_310 minecraft = class_310.method_1551();
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        if (!selectionHandler.hasSelectedEntities()) {
            return;
        }
        List<class_1297> selectedEntities = selectionHandler.getSelectedEntities();
        List combatEntities = selectedEntities.stream().filter(entity -> entity instanceof BaseCombatEntity).map(entity -> (BaseCombatEntity)((Object)entity)).collect(Collectors.toList());
        if (combatEntities.isEmpty()) {
            return;
        }
        LinkedHashMap actionsByType = new LinkedHashMap();
        if (!combatEntities.isEmpty()) {
            BaseCombatEntity firstEntity = (BaseCombatEntity)((Object)combatEntities.get(0));
            for (Action action : firstEntity.getActions()) {
                String actionClass = action.getClass().getName();
                actionsByType.put(actionClass, new ArrayList());
            }
        }
        for (Object entity2 : combatEntities) {
            for (Action action : ((BaseCombatEntity)((Object)entity2)).getActions()) {
                String actionClass = action.getClass().getName();
                if (!actionsByType.containsKey(actionClass)) {
                    actionsByType.put(actionClass, new ArrayList());
                }
                ((List)actionsByType.get(actionClass)).add(action);
            }
        }
        ArrayList<Action> mergedActions = new ArrayList<Action>();
        for (Map.Entry entry : actionsByType.entrySet()) {
            List actions = (List)entry.getValue();
            if (actions.isEmpty()) continue;
            if (((Action)actions.get(0)).isToggleAction()) {
                int enabledCount = (int)actions.stream().filter(Action::getCurrentState).count();
                Action representative = (Action)actions.get(0);
                representative.setCurrentState(enabledCount > actions.size() / 2);
                mergedActions.add(representative);
                continue;
            }
            mergedActions.add((Action)actions.get(0));
        }
        int screenWidth = minecraft.method_22683().method_4486();
        int n = minecraft.method_22683().method_4502();
        int listWidth = 140;
        int listHeight = mergedActions.size() * 12 + 10;
        int startX = 5;
        int startY = n - listHeight - 5;
        class_327 font = minecraft.field_1772;
        for (int i = 0; i < mergedActions.size(); ++i) {
            Action action = (Action)mergedActions.get(i);
            class_2561 text = this.getFormattedDescriptionComponent(action);
            int textY = startY + 5 + i * 12;
            guiGraphics.method_27535(font, text, startX + 5, textY, 0xFFFFFF);
        }
    }
}

