/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import ydmsama.hundred_years_war.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.freecam.ui.TeamApplicationEntry;
import ydmsama.hundred_years_war.freecam.ui.TeamApplicationsWidget;
import ydmsama.hundred_years_war.network.ClientPacketHandler;
import ydmsama.hundred_years_war.network.packets.TeamApplicationsResponsePacket;

@Environment(value=EnvType.CLIENT)
public class TeamApplicationsUI
extends class_437 {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private final class_437 parentScreen;
    private int leftPos;
    private int topPos;
    private class_342 searchBox;
    private TeamApplicationsWidget applicationsListWidget;
    private CustomButton backButton;
    private String searchText = "";
    private List<TeamApplicationsResponsePacket.Application> allApplications = new ArrayList<TeamApplicationsResponsePacket.Application>();
    private List<TeamApplicationsResponsePacket.Application> filteredApplications = new ArrayList<TeamApplicationsResponsePacket.Application>();

    public TeamApplicationsUI(class_437 parentScreen) {
        super((class_2561)class_2561.method_43471((String)"ui.hundred_years_war.team_applications_ui"));
        this.parentScreen = parentScreen;
        ClientPacketHandler.requestTeamApplications();
    }

    public void onApplicationsDataUpdate(TeamApplicationsResponsePacket packet) {
        System.out.println("\u6536\u5230\u56e2\u961f\u7533\u8bf7\u6570\u636e\u66f4\u65b0: " + packet.getApplications().size() + " \u4e2a\u7533\u8bf7");
        this.allApplications.clear();
        this.allApplications.addAll(packet.getApplications());
        for (TeamApplicationsResponsePacket.Application app : this.allApplications) {
            System.out.println("  \u7533\u8bf7\u8005: " + app.getPlayerName() + ", UUID: " + app.getPlayerUUID() + ", \u65f6\u95f4: " + app.getApplyTime());
        }
        if (this.searchBox != null && this.applicationsListWidget != null) {
            this.updateFilteredApplications();
            this.applicationsListWidget.method_25307(0.0);
        }
    }

    private void updateFilteredApplications() {
        if (this.searchBox == null) {
            return;
        }
        String searchText = this.searchBox.method_1882().toLowerCase();
        this.filteredApplications.clear();
        if (searchText.isEmpty()) {
            this.filteredApplications.addAll(this.allApplications);
        } else {
            for (TeamApplicationsResponsePacket.Application app : this.allApplications) {
                if (!app.getPlayerName().toLowerCase().contains(searchText)) continue;
                this.filteredApplications.add(app);
            }
        }
        System.out.println("\u8fc7\u6ee4\u540e\u7684\u7533\u8bf7\u6570\u91cf: " + this.filteredApplications.size());
        this.updateApplicationsList();
    }

    private void updateApplicationsList() {
        if (this.applicationsListWidget == null) {
            return;
        }
        this.applicationsListWidget.method_25339();
        for (TeamApplicationsResponsePacket.Application app : this.filteredApplications) {
            TeamApplicationEntry entry = new TeamApplicationEntry(app.getPlayerName(), app.getPlayerUUID(), app.getApplyTime(), this.applicationsListWidget);
            entry.setAcceptClickHandler(() -> this.acceptApplication(app.getPlayerUUID()));
            entry.setRejectClickHandler(() -> this.rejectApplication(app.getPlayerUUID()));
            this.applicationsListWidget.addEntry(entry);
        }
        this.applicationsListWidget.method_25307(0.0);
    }

    private void acceptApplication(UUID playerUUID) {
        ClientPacketHandler.requestTeamManage(ClientPacketHandler.getLatestTeamData().getTeamUUID(), "accept", playerUUID);
        for (int i = this.allApplications.size() - 1; i >= 0; --i) {
            if (!this.allApplications.get(i).getPlayerUUID().equals(playerUUID)) continue;
            this.allApplications.remove(i);
            break;
        }
        this.updateFilteredApplications();
    }

    private void rejectApplication(UUID playerUUID) {
        ClientPacketHandler.requestTeamManage(ClientPacketHandler.getLatestTeamData().getTeamUUID(), "reject", playerUUID);
        for (int i = this.allApplications.size() - 1; i >= 0; --i) {
            if (!this.allApplications.get(i).getPlayerUUID().equals(playerUUID)) continue;
            this.allApplications.remove(i);
            break;
        }
        this.updateFilteredApplications();
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.searchBox.method_25400(codePoint, modifiers)) {
            this.updateFilteredApplications();
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            this.updateFilteredApplications();
            return true;
        }
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (this.searchBox.method_25370()) {
            return this.searchBox.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - 240) / 2;
        this.topPos = (this.field_22790 - 250) / 2;
        this.searchBox = new class_342(this.field_22793, this.leftPos + 20, this.topPos + 20 + 25, 200, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.search"));
        this.searchBox.method_1880(32);
        this.searchBox.method_1858(true);
        this.searchBox.method_1856(true);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1852(this.searchText);
        this.searchBox.method_1863(s -> {
            this.searchText = s;
            this.updateFilteredApplications();
        });
        this.method_37063((class_364)this.searchBox);
        this.applicationsListWidget = new TeamApplicationsWidget(this.field_22787, 200, 140, this.topPos + 20 + 50, this.topPos + 250 - 20 - 20 - 5, 24);
        this.applicationsListWidget.method_25333(this.leftPos + 20);
        this.method_37063((class_364)this.applicationsListWidget);
        this.backButton = new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.back"), button -> this.method_25419());
        this.method_37063(this.backButton);
        this.allApplications.clear();
        this.filteredApplications.clear();
        ClientPacketHandler.requestTeamApplications();
        TeamApplicationsResponsePacket cachedData = ClientPacketHandler.getLatestTeamApplicationsData();
        if (cachedData != null) {
            System.out.println("\u7f13\u5b58\u7684\u7533\u8bf7\u6570\u636e: " + cachedData.getApplications().size() + " \u4e2a\u7533\u8bf7");
            for (TeamApplicationsResponsePacket.Application app : cachedData.getApplications()) {
                System.out.println("  \u7533\u8bf7\u8005: " + app.getPlayerName() + ", UUID: " + app.getPlayerUUID());
            }
            if (!cachedData.getApplications().isEmpty()) {
                this.onApplicationsDataUpdate(cachedData);
            }
        } else {
            System.out.println("\u6ca1\u6709\u7f13\u5b58\u7684\u7533\u8bf7\u6570\u636e");
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        if (this.allApplications.isEmpty()) {
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.no_applications"), this.leftPos + 120, this.topPos + 125, 0xFFFFFF);
        } else {
            this.applicationsListWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parentScreen);
    }
}

