/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import ydmsama.hundred_years_war.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.freecam.ui.CustomConfirmScreen;
import ydmsama.hundred_years_war.freecam.ui.CustomUI;
import ydmsama.hundred_years_war.freecam.ui.TeamCreateUI;
import ydmsama.hundred_years_war.freecam.ui.TeamInfoUI;
import ydmsama.hundred_years_war.freecam.ui.TeamJoinUI;
import ydmsama.hundred_years_war.freecam.ui.TeamManageUI;
import ydmsama.hundred_years_war.network.ClientPacketHandler;
import ydmsama.hundred_years_war.network.packets.TeamInfoResponsePacket;

@Environment(value=EnvType.CLIENT)
public class TeamUI
extends class_437 {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private int leftPos;
    private int topPos;
    private boolean isLoading = true;
    private boolean isInTeam = false;
    private String teamName = "";
    private UUID teamUUID = null;
    private String teamOwnerName = "";
    private List<String> teamMembers = new ArrayList<String>();
    private List<String> teamAdmins = new ArrayList<String>();
    private List<String> pendingApplications = new ArrayList<String>();
    private CustomButton createTeamButton;
    private CustomButton joinTeamButton;
    private CustomButton manageTeamButton;
    private CustomButton teamInfoButton;
    private CustomButton leaveTeamButton;
    private CustomButton backButton;

    public TeamUI() {
        super((class_2561)class_2561.method_43471((String)"ui.hundred_years_war.teams_ui"));
        this.requestTeamData();
    }

    private void requestTeamData() {
        this.isLoading = true;
        ClientPacketHandler.requestTeamData();
    }

    public void onTeamDataUpdate(TeamInfoResponsePacket packet) {
        this.isLoading = false;
        this.isInTeam = packet.isInTeam();
        if (this.isInTeam) {
            this.teamName = packet.getTeamName();
            this.teamUUID = packet.getTeamUUID();
            this.teamOwnerName = packet.getTeamOwnerName();
            this.teamMembers = packet.getTeamMembers();
            this.teamAdmins = packet.getTeamAdmins();
            this.pendingApplications = packet.getPendingApplications();
        }
        if (this.field_22787 != null && this.field_22787.field_1755 == this) {
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - 240) / 2;
        this.topPos = (this.field_22790 - 250) / 2;
        this.method_37067();
        if (this.isLoading) {
            this.backButton = new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.back"), button -> this.method_25419());
            this.method_37063(this.backButton);
            return;
        }
        if (this.isInTeam) {
            this.teamInfoButton = new CustomButton(this.leftPos + 120 - 60, this.topPos + 20 + 30, 120, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.team_info"), button -> this.openTeamInfoUI());
            this.method_37063(this.teamInfoButton);
            if (this.teamOwnerName.equals(this.field_22787.field_1724.method_5477().getString()) || this.teamAdmins.contains(this.field_22787.field_1724.method_5477().getString())) {
                this.manageTeamButton = new CustomButton(this.leftPos + 120 - 60, this.topPos + 20 + 30 + 20 + 10, 120, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.team_manage"), button -> this.manageTeam());
                this.method_37063(this.manageTeamButton);
            }
            this.leaveTeamButton = new CustomButton(this.leftPos + 120 - 60, this.topPos + 250 - 40 - 10 - 5, 120, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.team_leave"), button -> this.leaveTeam());
            this.leaveTeamButton.setColor(-5636096, -3407872, -11206656);
            this.method_37063(this.leaveTeamButton);
        } else {
            this.createTeamButton = new CustomButton(this.leftPos + 120 - 60, this.topPos + 20 + 30, 120, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.team_create"), button -> this.createTeam());
            this.method_37063(this.createTeamButton);
            this.joinTeamButton = new CustomButton(this.leftPos + 120 - 60, this.topPos + 20 + 30 + 20 + 10, 120, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.team_join"), button -> this.joinTeam());
            this.method_37063(this.joinTeamButton);
        }
        this.backButton = new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.back"), button -> this.method_25419());
        this.method_37063(this.backButton);
    }

    private void openTeamInfoUI() {
        System.out.println("\u6253\u5f00\u56e2\u961f\u4fe1\u606fUI: teamUUID=" + this.teamUUID + ", teamName=" + this.teamName);
        if (this.teamUUID == null) {
            System.out.println("\u9519\u8bef: \u56e2\u961fUUID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6253\u5f00\u56e2\u961f\u4fe1\u606fUI");
            return;
        }
        class_310.method_1551().method_1507((class_437)new TeamInfoUI(this, this.teamUUID, this.teamName));
    }

    private void manageTeam() {
        class_310.method_1551().method_1507((class_437)new TeamManageUI(this, this.teamUUID, this.teamName, this.teamOwnerName, this.teamMembers, this.teamAdmins, this.pendingApplications));
    }

    private void leaveTeam() {
        this.field_22787.method_1507((class_437)new CustomConfirmScreen(this, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.confirm"), (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.leave_team_confirm"), confirmed -> {
            if (confirmed) {
                ClientPacketHandler.requestLeaveTeam(this.teamUUID);
                this.requestTeamData();
            } else {
                class_310.method_1551().method_1507((class_437)this);
            }
        }));
    }

    private void createTeam() {
        class_310.method_1551().method_1507((class_437)new TeamCreateUI(this));
    }

    private void joinTeam() {
        class_310.method_1551().method_1507((class_437)new TeamJoinUI(this));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        if (this.isLoading) {
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.loading"), this.leftPos + 120, this.topPos + 125 - 10, 0xFFFFFF);
        } else if (this.isInTeam) {
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.teamName), this.leftPos + 120, this.topPos + 20, 0xFFFFFF);
        } else {
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.no_team"), this.leftPos + 120, this.topPos + 20, 0xFFFFFF);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        class_310.method_1551().method_1507((class_437)new CustomUI());
    }
}

