/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.ui.manual;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import ydmsama.hundred_years_war.freecam.ui.manual.ManualImage;
import ydmsama.hundred_years_war.freecam.ui.manual.ManualPage;

@Environment(value=EnvType.CLIENT)
public class ManualContentParser {
    private static final Pattern IMAGE_PATTERN = Pattern.compile("\\[img\\|u=([^|]+)(?:\\|w=(\\d+))?\\|dx=(-?\\d+)\\|dy=(-?\\d+)\\]");
    private static final int DEFAULT_IMAGE_WIDTH = 64;
    private static final Pattern FORMAT_CODE_PATTERN = Pattern.compile("\u00a7[0-9a-fk-or]");

    public static List<ManualPage> parseContent(class_2561 content, int width, class_327 font, int maxLinesPerPage, int lineHeight) {
        ArrayList<ManualPage> pages = new ArrayList<ManualPage>();
        String fullText = content.getString();
        List<ImageEntry> imageEntries = ManualContentParser.findImages(fullText);
        ManualContentParser.calculateRawLineNumbers(imageEntries, fullText, width, font, lineHeight, maxLinesPerPage);
        String processedText = ManualContentParser.replaceImagesWithPlaceholders(fullText, imageEntries, width, font, lineHeight, maxLinesPerPage);
        List<String> lines = ManualContentParser.splitIntoLinesWithFormat(processedText, width, font, maxLinesPerPage);
        int pageIndex = 0;
        int currentLine = 0;
        while (currentLine < lines.size()) {
            int endLine = Math.min(currentLine + maxLinesPerPage, lines.size());
            StringBuilder pageText = new StringBuilder();
            for (int i = currentLine; i < endLine; ++i) {
                if (i > currentLine) {
                    pageText.append("\n");
                }
                pageText.append(lines.get(i));
            }
            ArrayList<ManualImage> pageImages = new ArrayList<ManualImage>();
            for (ImageEntry entry : imageEntries) {
                if (entry.pageIndex != pageIndex) continue;
                int yOffset = entry.offsetLineInPage * lineHeight + entry.offsetY;
                ManualImage image = ManualImage.createWithLineHeight(entry.textureName, lineHeight, entry.calculatedLines, entry.offsetX, yOffset, entry.width > 0 ? entry.width : width);
                pageImages.add(image);
            }
            ManualPage page = new ManualPage(pageText.toString(), pageImages, width, font, lineHeight);
            pages.add(page);
            currentLine = endLine;
            ++pageIndex;
        }
        return pages;
    }

    private static List<ImageEntry> findImages(String text) {
        ArrayList<ImageEntry> images = new ArrayList<ImageEntry>();
        Matcher matcher = IMAGE_PATTERN.matcher(text);
        while (matcher.find()) {
            String textureName = matcher.group(1);
            int width = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : 0;
            int offsetX = Integer.parseInt(matcher.group(3));
            int offsetY = Integer.parseInt(matcher.group(4));
            images.add(new ImageEntry(textureName, width, offsetX, offsetY, matcher.start(), matcher.end()));
        }
        return images;
    }

    private static String replaceImagesWithPlaceholders(String text, List<ImageEntry> images, int width, class_327 font, int lineHeight, int maxLinesPerPage) {
        StringBuilder result = new StringBuilder(text);
        images.sort((a, b) -> Integer.compare(b.startIndex, a.startIndex));
        for (ImageEntry entry : images) {
            StringBuilder placeholder = new StringBuilder(" ");
            if (entry.wasMovedToNextPage) {
                for (int j = 0; j < entry.pageBreakLines; ++j) {
                    placeholder.append("\n ");
                }
            }
            int linesToAdd = Math.max(0, entry.calculatedLines - 1);
            for (int j = 0; j < linesToAdd; ++j) {
                placeholder.append("\n ");
            }
            result.replace(entry.startIndex, entry.endIndex, placeholder.toString());
        }
        return result.toString();
    }

    private static List<String> splitIntoLinesWithFormat(String text, int width, class_327 font, int maxLinesPerPage) {
        List splitLines = font.method_27527().method_27498(text, width, class_2583.field_24360);
        ArrayList<String> lines = new ArrayList<String>();
        FormatState globalFormatState = new FormatState();
        for (class_5348 line : splitLines) {
            String lineText = line.getString();
            String formatPrefix = globalFormatState.getFormatPrefix();
            Object formattedLine = !lineText.startsWith("\u00a7") && globalFormatState.hasActiveFormats() ? formatPrefix + lineText : lineText;
            ManualContentParser.updateFormatState(globalFormatState, (String)formattedLine);
            lines.add((String)formattedLine);
        }
        return ManualContentParser.processPageFormatInheritance(lines, maxLinesPerPage);
    }

    private static List<String> processPageFormatInheritance(List<String> lines, int maxLinesPerPage) {
        ArrayList<String> result = new ArrayList<String>();
        FormatState globalFormatState = new FormatState();
        for (int i = 0; i < lines.size(); ++i) {
            Object line = lines.get(i);
            if (i > 0 && i % maxLinesPerPage == 0) {
                String formatPrefix = globalFormatState.getFormatPrefix();
                if (globalFormatState.hasActiveFormats()) {
                    line = formatPrefix + (String)line;
                }
            }
            ManualContentParser.updateFormatState(globalFormatState, (String)line);
            result.add((String)line);
        }
        return result;
    }

    private static void updateFormatState(FormatState formatState, String text) {
        Matcher matcher = FORMAT_CODE_PATTERN.matcher(text);
        while (matcher.find()) {
            String formatCode = matcher.group();
            if (formatCode.length() != 2) continue;
            char code = formatCode.charAt(1);
            formatState.applyFormatCode(code);
        }
    }

    private static void calculateRawLineNumbers(List<ImageEntry> images, String originalText, int width, class_327 font, int lineHeight, int maxLinesPerPage) {
        images.sort(Comparator.comparingInt(e -> e.startIndex));
        int extraLineOffset = 0;
        for (ImageEntry entry : images) {
            int linesBeforeImage = font.method_27527().method_27498(originalText.substring(0, entry.startIndex), width, class_2583.field_24360).size();
            entry.lineNumber = linesBeforeImage + extraLineOffset;
            ManualContentParser.calculateImageActualLines(entry, width, lineHeight);
            int offsetInPage = entry.lineNumber % maxLinesPerPage;
            entry.pageIndex = entry.lineNumber / maxLinesPerPage;
            entry.wasMovedToNextPage = false;
            entry.pageBreakLines = 0;
            if (offsetInPage + entry.calculatedLines > maxLinesPerPage) {
                int additionalLines = maxLinesPerPage - offsetInPage;
                ++entry.pageIndex;
                offsetInPage = 0;
                entry.wasMovedToNextPage = true;
                entry.pageBreakLines = additionalLines;
                extraLineOffset += additionalLines;
            }
            entry.offsetLineInPage = offsetInPage;
            extraLineOffset += Math.max(0, entry.calculatedLines - 2);
        }
    }

    private static void calculateImageActualLines(ImageEntry entry, int contentWidth, int lineHeight) {
        int targetHeight;
        int targetWidth;
        int[] dimensions = ManualImage.getTextureDimensions(entry.textureName);
        int texWidth = dimensions[0];
        int texHeight = dimensions[1];
        if (entry.width > 0) {
            targetWidth = entry.width;
            targetHeight = Math.round((float)targetWidth * ((float)texHeight / (float)texWidth));
        } else {
            targetWidth = Math.min(contentWidth, texWidth);
            targetHeight = Math.round((float)targetWidth * ((float)texHeight / (float)texWidth));
        }
        if (contentWidth > 0 && targetWidth > contentWidth) {
            float scale = (float)contentWidth / (float)targetWidth;
            targetWidth = contentWidth;
            targetHeight = Math.round((float)targetHeight * scale);
        }
        entry.calculatedLines = (int)Math.ceil((float)targetHeight / (float)lineHeight);
        if (entry.calculatedLines < 1) {
            entry.calculatedLines = 1;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ImageEntry {
        String textureName;
        int width;
        int calculatedLines;
        int offsetX;
        int offsetY;
        int startIndex;
        int endIndex;
        int lineNumber;
        int pageIndex;
        int offsetLineInPage;
        boolean wasMovedToNextPage;
        int pageBreakLines;

        ImageEntry(String textureName, int width, int offsetX, int offsetY, int startIndex, int endIndex) {
            this.textureName = textureName;
            this.width = width;
            this.calculatedLines = 1;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.lineNumber = -1;
            this.pageIndex = 0;
            this.offsetLineInPage = 0;
            this.wasMovedToNextPage = false;
            this.pageBreakLines = 0;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class FormatState {
        private Set<Character> activeFormats = new HashSet<Character>();
        private Character currentColor = null;

        private FormatState() {
        }

        public void applyFormatCode(char code) {
            if (code >= '0' && code <= '9' || code >= 'a' && code <= 'f') {
                this.activeFormats.clear();
                this.currentColor = Character.valueOf(code);
            } else if (code == 'r') {
                this.activeFormats.clear();
                this.currentColor = null;
            } else {
                this.activeFormats.add(Character.valueOf(code));
            }
        }

        public String getFormatPrefix() {
            StringBuilder prefix = new StringBuilder();
            if (this.currentColor != null) {
                prefix.append("\u00a7").append(this.currentColor);
            }
            for (char format : this.activeFormats) {
                prefix.append("\u00a7").append(format);
            }
            return prefix.toString();
        }

        public FormatState copy() {
            FormatState copy = new FormatState();
            copy.activeFormats = new HashSet<Character>(this.activeFormats);
            copy.currentColor = this.currentColor;
            return copy;
        }

        public boolean hasActiveFormats() {
            return this.currentColor != null || !this.activeFormats.isEmpty();
        }
    }
}

